/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.assembler;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.assembler.DefaultClientTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.DefaultServerTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.dev.TubeFactory;
import com.sun.xml.internal.ws.assembler.dev.TubelineAssemblyContextUpdater;
import com.sun.xml.internal.ws.resources.TubelineassemblyMessages;
import com.sun.xml.internal.ws.runtime.config.TubeFactoryConfig;

final class TubeCreator {
    private static final Logger LOGGER = Logger.getLogger(TubeCreator.class);
    private final TubeFactory factory;
    private final String msgDumpPropertyBase;

    TubeCreator(TubeFactoryConfig tubeFactoryConfig, ClassLoader classLoader) {
        String string = tubeFactoryConfig.getClassName();
        try {
            Class<?> clazz = this.isJDKInternal(string) ? Class.forName(string, true, null) : Class.forName(string, true, classLoader);
            if (!TubeFactory.class.isAssignableFrom(clazz)) {
                throw new RuntimeException(TubelineassemblyMessages.MASM_0015_CLASS_DOES_NOT_IMPLEMENT_INTERFACE(clazz.getName(), TubeFactory.class.getName()));
            }
            Class<?> clazz2 = clazz;
            this.factory = (TubeFactory)clazz2.newInstance();
            this.msgDumpPropertyBase = this.factory.getClass().getName() + ".dump";
        }
        catch (InstantiationException instantiationException) {
            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0016_UNABLE_TO_INSTANTIATE_TUBE_FACTORY(string), instantiationException), true);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0016_UNABLE_TO_INSTANTIATE_TUBE_FACTORY(string), illegalAccessException), true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw LOGGER.logSevereException(new RuntimeException(TubelineassemblyMessages.MASM_0017_UNABLE_TO_LOAD_TUBE_FACTORY_CLASS(string), classNotFoundException), true);
        }
    }

    Tube createTube(DefaultClientTubelineAssemblyContext defaultClientTubelineAssemblyContext) {
        return this.factory.createTube(defaultClientTubelineAssemblyContext);
    }

    Tube createTube(DefaultServerTubelineAssemblyContext defaultServerTubelineAssemblyContext) {
        return this.factory.createTube(defaultServerTubelineAssemblyContext);
    }

    void updateContext(ClientTubelineAssemblyContext clientTubelineAssemblyContext) {
        if (this.factory instanceof TubelineAssemblyContextUpdater) {
            ((TubelineAssemblyContextUpdater)((Object)this.factory)).prepareContext(clientTubelineAssemblyContext);
        }
    }

    void updateContext(DefaultServerTubelineAssemblyContext defaultServerTubelineAssemblyContext) {
        if (this.factory instanceof TubelineAssemblyContextUpdater) {
            ((TubelineAssemblyContextUpdater)((Object)this.factory)).prepareContext(defaultServerTubelineAssemblyContext);
        }
    }

    String getMessageDumpPropertyBase() {
        return this.msgDumpPropertyBase;
    }

    private boolean isJDKInternal(String string) {
        return string.startsWith("com.sun.xml.internal.ws");
    }
}

