/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.webservices.internal.api.message;

import com.oracle.webservices.internal.api.message.BasePropertySet;
import com.oracle.webservices.internal.api.message.DistributedPropertySet;
import com.oracle.webservices.internal.api.message.MessageContext;
import com.oracle.webservices.internal.api.message.PropertySet;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class BaseDistributedPropertySet
extends BasePropertySet
implements DistributedPropertySet {
    private final Map<Class<? extends PropertySet>, PropertySet> satellites = new IdentityHashMap<Class<? extends PropertySet>, PropertySet>();
    private final Map<String, Object> viewthis = super.createView();

    @Override
    public void addSatellite(@NotNull PropertySet propertySet) {
        this.addSatellite(propertySet.getClass(), propertySet);
    }

    @Override
    public void addSatellite(@NotNull Class<? extends PropertySet> clazz, @NotNull PropertySet propertySet) {
        this.satellites.put(clazz, propertySet);
    }

    @Override
    public void removeSatellite(PropertySet propertySet) {
        this.satellites.remove(propertySet.getClass());
    }

    public void copySatelliteInto(@NotNull DistributedPropertySet distributedPropertySet) {
        for (Map.Entry<Class<? extends PropertySet>, PropertySet> entry : this.satellites.entrySet()) {
            distributedPropertySet.addSatellite(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void copySatelliteInto(MessageContext messageContext) {
        this.copySatelliteInto((DistributedPropertySet)messageContext);
    }

    @Override
    @Nullable
    public <T extends PropertySet> T getSatellite(Class<T> clazz) {
        PropertySet propertySet = this.satellites.get(clazz);
        if (propertySet != null) {
            return (T)propertySet;
        }
        for (PropertySet propertySet2 : this.satellites.values()) {
            if (clazz.isInstance(propertySet2)) {
                return (T)((PropertySet)clazz.cast(propertySet2));
            }
            if (!DistributedPropertySet.class.isInstance(propertySet2) || (propertySet = ((DistributedPropertySet)DistributedPropertySet.class.cast(propertySet2)).getSatellite(clazz)) == null) continue;
            return (T)propertySet;
        }
        return null;
    }

    @Override
    public Map<Class<? extends PropertySet>, PropertySet> getSatellites() {
        return this.satellites;
    }

    @Override
    public Object get(Object object) {
        for (PropertySet propertySet : this.satellites.values()) {
            if (!propertySet.supports(object)) continue;
            return propertySet.get(object);
        }
        return super.get(object);
    }

    @Override
    public Object put(String string, Object object) {
        for (PropertySet propertySet : this.satellites.values()) {
            if (!propertySet.supports(string)) continue;
            return propertySet.put(string, object);
        }
        return super.put(string, object);
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.viewthis.containsKey(object)) {
            return true;
        }
        for (PropertySet propertySet : this.satellites.values()) {
            if (!propertySet.containsKey(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Object object) {
        for (PropertySet propertySet : this.satellites.values()) {
            if (!propertySet.supports(object)) continue;
            return true;
        }
        return super.supports(object);
    }

    @Override
    public Object remove(Object object) {
        for (PropertySet propertySet : this.satellites.values()) {
            if (!propertySet.supports(object)) continue;
            return propertySet.remove(object);
        }
        return super.remove(object);
    }

    @Override
    protected void createEntrySet(Set<Map.Entry<String, Object>> set) {
        super.createEntrySet(set);
        for (PropertySet propertySet : this.satellites.values()) {
            ((BasePropertySet)propertySet).createEntrySet(set);
        }
    }

    protected Map<String, Object> asMapLocal() {
        return this.viewthis;
    }

    protected boolean supportsLocal(Object object) {
        return super.supports(object);
    }

    @Override
    protected Map<String, Object> createView() {
        return new DistributedMapView();
    }

    class DistributedMapView
    extends AbstractMap<String, Object> {
        DistributedMapView() {
        }

        @Override
        public Object get(Object object) {
            for (PropertySet propertySet : BaseDistributedPropertySet.this.satellites.values()) {
                if (!propertySet.supports(object)) continue;
                return propertySet.get(object);
            }
            return BaseDistributedPropertySet.this.viewthis.get(object);
        }

        @Override
        public int size() {
            int n = BaseDistributedPropertySet.this.viewthis.size();
            for (PropertySet propertySet : BaseDistributedPropertySet.this.satellites.values()) {
                n += propertySet.asMap().size();
            }
            return n;
        }

        @Override
        public boolean containsKey(Object object) {
            if (BaseDistributedPropertySet.this.viewthis.containsKey(object)) {
                return true;
            }
            for (PropertySet propertySet : BaseDistributedPropertySet.this.satellites.values()) {
                if (!propertySet.containsKey(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>();
            for (PropertySet object : BaseDistributedPropertySet.this.satellites.values()) {
                for (Map.Entry<String, Object> entry : object.asMap().entrySet()) {
                    hashSet.add(new AbstractMap.SimpleImmutableEntry<String, Object>(entry.getKey(), entry.getValue()));
                }
            }
            for (Map.Entry entry : BaseDistributedPropertySet.this.viewthis.entrySet()) {
                hashSet.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue()));
            }
            return hashSet;
        }

        @Override
        public Object put(String string, Object object) {
            for (PropertySet propertySet : BaseDistributedPropertySet.this.satellites.values()) {
                if (!propertySet.supports(string)) continue;
                return propertySet.put(string, object);
            }
            return BaseDistributedPropertySet.this.viewthis.put(string, object);
        }

        @Override
        public void clear() {
            BaseDistributedPropertySet.this.satellites.clear();
            BaseDistributedPropertySet.this.viewthis.clear();
        }

        @Override
        public Object remove(Object object) {
            for (PropertySet propertySet : BaseDistributedPropertySet.this.satellites.values()) {
                if (!propertySet.supports(object)) continue;
                return propertySet.remove(object);
            }
            return BaseDistributedPropertySet.this.viewthis.remove(object);
        }
    }
}

