/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableIntegerProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.util.StringConverter;

public class Slider
extends Control {
    private DoubleProperty max;
    private DoubleProperty min;
    private DoubleProperty value;
    private BooleanProperty valueChanging;
    private ObjectProperty<Orientation> orientation;
    private BooleanProperty showTickLabels;
    private BooleanProperty showTickMarks;
    private DoubleProperty majorTickUnit;
    private IntegerProperty minorTickCount;
    private BooleanProperty snapToTicks;
    private ObjectProperty<StringConverter<Double>> labelFormatter;
    private DoubleProperty blockIncrement;
    private static final String DEFAULT_STYLE_CLASS = "slider";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public Slider() {
        this.initialize();
    }

    public Slider(double d, double d2, double d3) {
        this.setMax(d2);
        this.setMin(d);
        this.setValue(d3);
        this.adjustValues();
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setMax(double d) {
        this.maxProperty().set(d);
    }

    public final double getMax() {
        return this.max == null ? 100.0 : this.max.get();
    }

    public final DoubleProperty maxProperty() {
        if (this.max == null) {
            this.max = new DoublePropertyBase(100.0){

                @Override
                protected void invalidated() {
                    if (this.get() < Slider.this.getMin()) {
                        Slider.this.setMin(this.get());
                    }
                    Slider.this.adjustValues();
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "max";
                }
            };
        }
        return this.max;
    }

    public final void setMin(double d) {
        this.minProperty().set(d);
    }

    public final double getMin() {
        return this.min == null ? 0.0 : this.min.get();
    }

    public final DoubleProperty minProperty() {
        if (this.min == null) {
            this.min = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    if (this.get() > Slider.this.getMax()) {
                        Slider.this.setMax(this.get());
                    }
                    Slider.this.adjustValues();
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "min";
                }
            };
        }
        return this.min;
    }

    public final void setValue(double d) {
        if (!this.valueProperty().isBound()) {
            this.valueProperty().set(d);
        }
    }

    public final double getValue() {
        return this.value == null ? 0.0 : this.value.get();
    }

    public final DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    Slider.this.adjustValues();
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public final void setValueChanging(boolean bl) {
        this.valueChangingProperty().set(bl);
    }

    public final boolean isValueChanging() {
        return this.valueChanging == null ? false : this.valueChanging.get();
    }

    public final BooleanProperty valueChangingProperty() {
        if (this.valueChanging == null) {
            this.valueChanging = new SimpleBooleanProperty(this, "valueChanging", false);
        }
        return this.valueChanging;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.HORIZONTAL){

                @Override
                protected void invalidated() {
                    Slider.this.impl_pseudoClassStateChanged(Slider.PSEUDO_CLASS_VERTICAL);
                    Slider.this.impl_pseudoClassStateChanged(Slider.PSEUDO_CLASS_HORIZONTAL);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setShowTickLabels(boolean bl) {
        this.showTickLabelsProperty().set(bl);
    }

    public final boolean isShowTickLabels() {
        return this.showTickLabels == null ? false : this.showTickLabels.get();
    }

    public final BooleanProperty showTickLabelsProperty() {
        if (this.showTickLabels == null) {
            this.showTickLabels = new StyleableBooleanProperty(false){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SHOW_TICK_LABELS;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "showTickLabels";
                }
            };
        }
        return this.showTickLabels;
    }

    public final void setShowTickMarks(boolean bl) {
        this.showTickMarksProperty().set(bl);
    }

    public final boolean isShowTickMarks() {
        return this.showTickMarks == null ? false : this.showTickMarks.get();
    }

    public final BooleanProperty showTickMarksProperty() {
        if (this.showTickMarks == null) {
            this.showTickMarks = new StyleableBooleanProperty(false){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SHOW_TICK_MARKS;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "showTickMarks";
                }
            };
        }
        return this.showTickMarks;
    }

    public final void setMajorTickUnit(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("MajorTickUnit cannot be less than or equal to 0.");
        }
        this.majorTickUnitProperty().set(d);
    }

    public final double getMajorTickUnit() {
        return this.majorTickUnit == null ? 25.0 : this.majorTickUnit.get();
    }

    public final DoubleProperty majorTickUnitProperty() {
        if (this.majorTickUnit == null) {
            this.majorTickUnit = new StyleableDoubleProperty(25.0){

                @Override
                public void invalidated() {
                    if (this.get() <= 0.0) {
                        throw new IllegalArgumentException("MajorTickUnit cannot be less than or equal to 0.");
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MAJOR_TICK_UNIT;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "majorTickUnit";
                }
            };
        }
        return this.majorTickUnit;
    }

    public final void setMinorTickCount(int n) {
        this.minorTickCountProperty().set(n);
    }

    public final int getMinorTickCount() {
        return this.minorTickCount == null ? 3 : this.minorTickCount.get();
    }

    public final IntegerProperty minorTickCountProperty() {
        if (this.minorTickCount == null) {
            this.minorTickCount = new StyleableIntegerProperty(3){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MINOR_TICK_COUNT;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "minorTickCount";
                }
            };
        }
        return this.minorTickCount;
    }

    public final void setSnapToTicks(boolean bl) {
        this.snapToTicksProperty().set(bl);
    }

    public final boolean isSnapToTicks() {
        return this.snapToTicks == null ? false : this.snapToTicks.get();
    }

    public final BooleanProperty snapToTicksProperty() {
        if (this.snapToTicks == null) {
            this.snapToTicks = new StyleableBooleanProperty(false){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SNAP_TO_TICKS;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "snapToTicks";
                }
            };
        }
        return this.snapToTicks;
    }

    public final void setLabelFormatter(StringConverter<Double> stringConverter) {
        this.labelFormatterProperty().set(stringConverter);
    }

    public final StringConverter<Double> getLabelFormatter() {
        return this.labelFormatter == null ? null : (StringConverter)this.labelFormatter.get();
    }

    public final ObjectProperty<StringConverter<Double>> labelFormatterProperty() {
        if (this.labelFormatter == null) {
            this.labelFormatter = new SimpleObjectProperty<StringConverter<Double>>(this, "labelFormatter");
        }
        return this.labelFormatter;
    }

    public final void setBlockIncrement(double d) {
        this.blockIncrementProperty().set(d);
    }

    public final double getBlockIncrement() {
        return this.blockIncrement == null ? 10.0 : this.blockIncrement.get();
    }

    public final DoubleProperty blockIncrementProperty() {
        if (this.blockIncrement == null) {
            this.blockIncrement = new StyleableDoubleProperty(10.0){

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.BLOCK_INCREMENT;
                }

                @Override
                public Object getBean() {
                    return Slider.this;
                }

                @Override
                public String getName() {
                    return "blockIncrement";
                }
            };
        }
        return this.blockIncrement;
    }

    public void adjustValue(double d) {
        double d2 = this.getMin();
        double d3 = this.getMax();
        if (d3 <= d2) {
            return;
        }
        d = d < d2 ? d2 : d;
        d = d > d3 ? d3 : d;
        this.setValue(this.snapValueToTicks(d));
    }

    public void increment() {
        this.adjustValue(this.getValue() + this.getBlockIncrement());
    }

    public void decrement() {
        this.adjustValue(this.getValue() - this.getBlockIncrement());
    }

    private void adjustValues() {
        if (this.getValue() < this.getMin() || this.getValue() > this.getMax()) {
            this.setValue(Utils.clamp(this.getMin(), this.getValue(), this.getMax()));
        }
    }

    private double snapValueToTicks(double d) {
        double d2 = d;
        if (this.isSnapToTicks()) {
            double d3 = 0.0;
            d3 = this.getMinorTickCount() != 0 ? this.getMajorTickUnit() / (double)(Math.max(this.getMinorTickCount(), 0) + 1) : this.getMajorTickUnit();
            int n = (int)((d2 - this.getMin()) / d3);
            double d4 = (double)n * d3 + this.getMin();
            double d5 = (double)(n + 1) * d3 + this.getMin();
            d2 = Utils.nearest(d4, d2, d5);
        }
        return Utils.clamp(this.getMin(), d2, this.getMax());
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Slider.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Slider, Number> BLOCK_INCREMENT = new StyleableProperty<Slider, Number>("-fx-block-increment", (StyleConverter)SizeConverter.getInstance(), (Number)10.0){

            @Override
            public boolean isSettable(Slider slider) {
                return slider.blockIncrement == null || !slider.blockIncrement.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Slider slider) {
                return slider.blockIncrementProperty();
            }
        };
        private static final StyleableProperty<Slider, Boolean> SHOW_TICK_LABELS = new StyleableProperty<Slider, Boolean>("-fx-show-tick-labels", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Slider slider) {
                return slider.showTickLabels == null || !slider.showTickLabels.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Slider slider) {
                return slider.showTickLabelsProperty();
            }
        };
        private static final StyleableProperty<Slider, Boolean> SHOW_TICK_MARKS = new StyleableProperty<Slider, Boolean>("-fx-show-tick-marks", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Slider slider) {
                return slider.showTickMarks == null || !slider.showTickMarks.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Slider slider) {
                return slider.showTickMarksProperty();
            }
        };
        private static final StyleableProperty<Slider, Boolean> SNAP_TO_TICKS = new StyleableProperty<Slider, Boolean>("-fx-snap-to-ticks", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Slider slider) {
                return slider.snapToTicks == null || !slider.snapToTicks.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Slider slider) {
                return slider.snapToTicksProperty();
            }
        };
        private static final StyleableProperty<Slider, Number> MAJOR_TICK_UNIT = new StyleableProperty<Slider, Number>("-fx-major-tick-unit", (StyleConverter)SizeConverter.getInstance(), (Number)25.0){

            @Override
            public boolean isSettable(Slider slider) {
                return slider.majorTickUnit == null || !slider.majorTickUnit.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Slider slider) {
                return slider.majorTickUnitProperty();
            }
        };
        private static final StyleableProperty<Slider, Number> MINOR_TICK_COUNT = new StyleableProperty<Slider, Number>("-fx-minor-tick-count", (StyleConverter)SizeConverter.getInstance(), (Number)3.0){

            @Override
            public void set(Slider slider, Number number, Stylesheet.Origin origin) {
                super.set(slider, number.intValue(), origin);
            }

            @Override
            public boolean isSettable(Slider slider) {
                return slider.minorTickCount == null || !slider.minorTickCount.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(Slider slider) {
                return slider.minorTickCountProperty();
            }
        };
        private static final StyleableProperty<Slider, Orientation> ORIENTATION = new StyleableProperty<Slider, Orientation>("-fx-orientation", new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(Slider slider) {
                return slider.getOrientation();
            }

            @Override
            public boolean isSettable(Slider slider) {
                return slider.orientation == null || !slider.orientation.isBound();
            }

            @Override
            public WritableValue<Orientation> getWritableValue(Slider slider) {
                return slider.orientationProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, BLOCK_INCREMENT, SHOW_TICK_LABELS, SHOW_TICK_MARKS, SNAP_TO_TICKS, MAJOR_TICK_UNIT, MINOR_TICK_COUNT, ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

