/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.pyramid;

import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramidBase;

public abstract class PyramidDiscrete<T extends ImageSingleBand>
extends ImagePyramidBase<T> {
    public int[] scale;

    public PyramidDiscrete(Class<T> imageType, boolean saveOriginalReference, int ... scaleFactors) {
        super(imageType, saveOriginalReference);
        if (scaleFactors.length > 0) {
            this.setScaleFactors(scaleFactors);
        }
    }

    public void setScaleFactors(int ... scaleFactors) {
        for (int i = 1; i < scaleFactors.length; ++i) {
            if (scaleFactors[i] % scaleFactors[i - 1] == 0) continue;
            throw new IllegalArgumentException("Layer " + i + " is not evenly divisible by its lower layer.");
        }
        this.bottomHeight = 0;
        this.bottomWidth = 0;
        this.scale = (int[])scaleFactors.clone();
        this.checkScales();
    }

    public int[] getScales() {
        return this.scale;
    }

    @Override
    public double getScale(int layer) {
        return this.scale[layer];
    }

    @Override
    public int getNumLayers() {
        return this.scale.length;
    }
}

