/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel1D;

public class Kernel1D_F32
extends Kernel1D {
    public float[] data;

    public Kernel1D_F32(float[] data, int width) {
        this(data, width / 2, width);
        if (width % 2 != 1) {
            throw new IllegalArgumentException("Kernel must be add to use this constructor");
        }
    }

    public Kernel1D_F32(float[] data, int offset, int width) {
        super(offset, width);
        this.data = new float[width];
        System.arraycopy(data, 0, this.data, 0, width);
    }

    public Kernel1D_F32(int width) {
        this(width / 2, width);
    }

    public Kernel1D_F32(int offset, int width) {
        super(offset, width);
        this.data = new float[width];
    }

    protected Kernel1D_F32() {
    }

    @Override
    public double getDouble(int index) {
        return this.data[index];
    }

    public static Kernel1D_F32 wrap(float[] data, int width) {
        Kernel1D_F32 ret = new Kernel1D_F32();
        ret.data = data;
        ret.width = width;
        ret.offset = width / 2;
        return ret;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public float get(int i) {
        return this.data[i];
    }

    public float computeSum() {
        float sum = 0.0f;
        for (int i = 0; i < this.data.length; ++i) {
            sum += this.data[i];
        }
        return sum;
    }

    public float[] getData() {
        return this.data;
    }

    public Kernel1D_F32 copy() {
        Kernel1D_F32 ret = new Kernel1D_F32(this.width);
        ret.offset = this.offset;
        System.arraycopy(this.data, 0, ret.data, 0, ret.width);
        return ret;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
        }
        System.out.println();
    }
}

