/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.wavelet;

import boofcv.core.image.border.BorderType;
import boofcv.factory.transform.wavelet.FactoryWaveletCoiflet;
import boofcv.factory.transform.wavelet.FactoryWaveletDaub;
import boofcv.factory.transform.wavelet.FactoryWaveletHaar;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef;

public class GFactoryWavelet {
    public static <C extends WlCoef, T extends ImageSingleBand> WaveletDescription<C> haar(Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return FactoryWaveletHaar.generate(false, 32);
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return FactoryWaveletHaar.generate(true, 32);
        }
        return null;
    }

    public static <C extends WlCoef, T extends ImageSingleBand> WaveletDescription<C> daubJ(Class<T> imageType, int J) {
        if (imageType == ImageFloat32.class) {
            return FactoryWaveletDaub.daubJ_F32(J);
        }
        return null;
    }

    public static <C extends WlCoef, T extends ImageSingleBand> WaveletDescription<C> biorthogoal(Class<T> imageType, int J, BorderType borderType) {
        if (imageType == ImageFloat32.class) {
            return FactoryWaveletDaub.biorthogonal_F32(J, borderType);
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return FactoryWaveletDaub.biorthogonal_I32(J, borderType);
        }
        return null;
    }

    public static <C extends WlCoef, T extends ImageSingleBand> WaveletDescription<C> coiflet(Class<T> imageType, int J) {
        if (imageType == ImageFloat32.class) {
            return FactoryWaveletCoiflet.generate_F32(J);
        }
        return null;
    }
}

