/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.wavelet;

import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.abst.transform.wavelet.impl.WaveletTransformFloat32;
import boofcv.abst.transform.wavelet.impl.WaveletTransformInt;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class FactoryWaveletTransform {
    public static <T extends ImageSingleBand, W extends ImageSingleBand, C extends WlCoef> WaveletTransform<T, W, C> create(Class<T> imageType, WaveletDescription<C> waveletDesc, int numLevels, double minPixelValue, double maxPixelValue) {
        if (((WlCoef)waveletDesc.getForward()).getType() == Float.TYPE) {
            return FactoryWaveletTransform.create_F32(waveletDesc, numLevels, (float)minPixelValue, (float)maxPixelValue);
        }
        if (((WlCoef)waveletDesc.getForward()).getType() == Integer.TYPE) {
            return FactoryWaveletTransform.create_I(waveletDesc, numLevels, (int)minPixelValue, (int)maxPixelValue, imageType);
        }
        throw new RuntimeException("Add support for this image type");
    }

    public static <T extends ImageInteger> WaveletTransform<T, ImageSInt32, WlCoef_I32> create_I(WaveletDescription<WlCoef_I32> waveletDesc, int numLevels, int minPixelValue, int maxPixelValue, Class<T> imageType) {
        return new WaveletTransformInt<T>(waveletDesc, numLevels, minPixelValue, maxPixelValue, imageType);
    }

    public static WaveletTransform<ImageFloat32, ImageFloat32, WlCoef_F32> create_F32(WaveletDescription<WlCoef_F32> waveletDesc, int numLevels, float minPixelValue, float maxPixelValue) {
        return new WaveletTransformFloat32(waveletDesc, numLevels, minPixelValue, maxPixelValue);
    }
}

