/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii.impl;

import boofcv.alg.transform.ii.SparseIntegralGradient_NoBorder;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.sparse.GradientValue_I32;

public class SparseIntegralGradient_NoBorder_I32
extends SparseIntegralGradient_NoBorder<ImageSInt32, GradientValue_I32> {
    private GradientValue_I32 ret = new GradientValue_I32();

    public SparseIntegralGradient_NoBorder_I32(int radius) {
        super(radius);
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
        this.x0 = this.y0 = -this.r - 1;
        this.x1 = this.y1 = this.r;
    }

    @Override
    public GradientValue_I32 compute(int x, int y) {
        int horizontalOffset = x - this.r - 1;
        int indexSrc1 = ((ImageSInt32)this.input).startIndex + (y - this.r - 1) * ((ImageSInt32)this.input).stride + horizontalOffset;
        int indexSrc2 = indexSrc1 + this.r * ((ImageSInt32)this.input).stride;
        int indexSrc3 = indexSrc2 + ((ImageSInt32)this.input).stride;
        int indexSrc4 = indexSrc3 + this.r * ((ImageSInt32)this.input).stride;
        int p0 = ((ImageSInt32)this.input).data[indexSrc1];
        int p1 = ((ImageSInt32)this.input).data[indexSrc1 + this.r];
        int p2 = ((ImageSInt32)this.input).data[indexSrc1 + this.r + 1];
        int p3 = ((ImageSInt32)this.input).data[indexSrc1 + this.w];
        int p11 = ((ImageSInt32)this.input).data[indexSrc2];
        int p4 = ((ImageSInt32)this.input).data[indexSrc2 + this.w];
        int p10 = ((ImageSInt32)this.input).data[indexSrc3];
        int p5 = ((ImageSInt32)this.input).data[indexSrc3 + this.w];
        int p9 = ((ImageSInt32)this.input).data[indexSrc4];
        int p8 = ((ImageSInt32)this.input).data[indexSrc4 + this.r];
        int p7 = ((ImageSInt32)this.input).data[indexSrc4 + this.r + 1];
        int p6 = ((ImageSInt32)this.input).data[indexSrc4 + this.w];
        int left = p8 - p9 - p1 + p0;
        int right = p6 - p7 - p3 + p2;
        int top = p4 - p11 - p3 + p0;
        int bottom = p6 - p9 - p5 + p10;
        this.ret.x = right - left;
        this.ret.y = bottom - top;
        return this.ret;
    }

    @Override
    public Class<GradientValue_I32> getGradientType() {
        return GradientValue_I32.class;
    }
}

