/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.NearestNeighborPixel;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageType;

public class NearestNeighborPixel_S32
extends NearestNeighborPixel<ImageSInt32> {
    private int[] data;

    public NearestNeighborPixel_S32() {
    }

    public NearestNeighborPixel_S32(ImageSInt32 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(ImageSInt32 image) {
        this.orig = image;
        this.data = ((ImageSInt32)this.orig).data;
        this.stride = ((ImageSInt32)this.orig).getStride();
        this.width = ((ImageSInt32)this.orig).getWidth();
        this.height = ((ImageSInt32)this.orig).getHeight();
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((ImageSInt32)this.orig).startIndex + (int)y * this.stride + (int)x];
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((ImageSInt32)this.orig).startIndex + yy * this.stride + xx];
    }

    @Override
    public ImageType<ImageSInt32> getImageType() {
        return ImageType.single(ImageSInt32.class);
    }
}

