/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

public class ThresholdSauvola {
    float k;
    int radius;
    boolean down;
    ImageFloat32 inputPow2 = new ImageFloat32(1, 1);
    ImageFloat32 inputMean = new ImageFloat32(1, 1);
    ImageFloat32 inputMeanPow2 = new ImageFloat32(1, 1);
    ImageFloat32 inputPow2Mean = new ImageFloat32(1, 1);
    ImageFloat32 stdev = new ImageFloat32(1, 1);
    ImageFloat32 tmp = new ImageFloat32(1, 1);

    public ThresholdSauvola(int radius, float k, boolean down) {
        this.k = k;
        this.radius = radius;
        this.down = down;
    }

    public void process(ImageFloat32 input, ImageUInt8 output) {
        this.inputPow2.reshape(input.width, input.height);
        this.inputMean.reshape(input.width, input.height);
        this.inputMeanPow2.reshape(input.width, input.height);
        this.inputPow2Mean.reshape(input.width, input.height);
        this.stdev.reshape(input.width, input.height);
        this.tmp.reshape(input.width, input.height);
        this.inputPow2.reshape(input.width, input.height);
        BlurImageOps.mean(input, this.inputMean, this.radius, this.tmp);
        PixelMath.pow2(input, this.inputPow2);
        BlurImageOps.mean(this.inputPow2, this.inputPow2Mean, this.radius, this.tmp);
        PixelMath.pow2(this.inputMean, this.inputMeanPow2);
        PixelMath.subtract(this.inputPow2Mean, this.inputMeanPow2, this.stdev);
        PixelMath.sqrt(this.stdev, this.stdev);
        float R = ImageStatistics.max(this.stdev);
        if (this.down) {
            for (int y = 0; y < input.height; ++y) {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.inputMean.data[i] * (1.0f + this.k * (this.stdev.data[i] / R - 1.0f));
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            }
        } else {
            for (int y = 0; y < input.height; ++y) {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.inputMean.data[i] * (1.0f + this.k * (this.stdev.data[i] / R - 1.0f));
                    output.data[indexOut++] = (byte)(input.data[indexIn++] >= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            }
        }
    }

    public float getK() {
        return this.k;
    }

    public void setK(float k) {
        this.k = k;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }
}

