/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.basic.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class ImplGrayImageOps {
    public static void invert(ImageFloat32 input, float max, ImageFloat32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = max - input.data[indexSrc++];
            }
        }
    }

    public static void brighten(ImageFloat32 input, float beta, float max, ImageFloat32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int n = indexSrc++;
                float val = input.data[n] + beta;
                if (val > max) {
                    val = max;
                }
                if (val < 0.0f) {
                    val = 0.0f;
                }
                output.data[indexDst++] = val;
            }
        }
    }

    public static void stretch(ImageFloat32 input, double gamma, float beta, float max, ImageFloat32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int n = indexSrc++;
                float val = (float)((double)input.data[n] * gamma) + beta;
                if (val > max) {
                    val = max;
                }
                if (val < 0.0f) {
                    val = 0.0f;
                }
                output.data[indexDst++] = val;
            }
        }
    }

    public static void invert(ImageUInt8 input, int max, ImageUInt8 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = (byte)(max - (input.data[indexSrc++] & 0xFF));
            }
        }
    }

    public static void brighten(ImageUInt8 input, int beta, int max, ImageUInt8 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (input.data[indexSrc++] & 0xFF) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (byte)val;
            }
        }
    }

    public static void stretch(ImageUInt8 input, double gamma, int beta, int max, ImageUInt8 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)(input.data[indexSrc++] & 0xFF) * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (byte)val;
            }
        }
    }

    public static void invert(ImageSInt16 input, int max, ImageSInt16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = (short)(max - input.data[indexSrc++]);
            }
        }
    }

    public static void brighten(ImageSInt16 input, int beta, int max, ImageSInt16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = input.data[indexSrc++] + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void stretch(ImageSInt16 input, double gamma, int beta, int max, ImageSInt16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)input.data[indexSrc++] * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void invert(ImageUInt16 input, int max, ImageUInt16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = (short)(max - (input.data[indexSrc++] & 0xFFFF));
            }
        }
    }

    public static void brighten(ImageUInt16 input, int beta, int max, ImageUInt16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (input.data[indexSrc++] & 0xFFFF) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void stretch(ImageUInt16 input, double gamma, int beta, int max, ImageUInt16 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)(input.data[indexSrc++] & 0xFFFF) * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = (short)val;
            }
        }
    }

    public static void invert(ImageSInt32 input, int max, ImageSInt32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                output.data[indexDst++] = max - input.data[indexSrc++];
            }
        }
    }

    public static void brighten(ImageSInt32 input, int beta, int max, ImageSInt32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = input.data[indexSrc++] + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = val;
            }
        }
    }

    public static void stretch(ImageSInt32 input, double gamma, int beta, int max, ImageSInt32 output) {
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + input.stride * y;
            int indexDst = output.startIndex + output.stride * y;
            for (int x = 0; x < input.width; ++x) {
                int val;
                if ((val = (int)((double)input.data[indexSrc++] * gamma) + beta) > max) {
                    val = max;
                }
                if (val < 0) {
                    val = 0;
                }
                output.data[indexDst++] = val;
            }
        }
    }
}

