/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.enhance.impl.ImplEnhanceFilter;
import boofcv.alg.enhance.impl.ImplEnhanceHistogram;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class EnhanceImageOps {
    public static void equalize(int[] histogram, int[] transform) {
        int sum = 0;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = sum += histogram[i];
        }
        int maxValue = histogram.length - 1;
        for (int i = 0; i < histogram.length; ++i) {
            transform[i] = transform[i] * maxValue / sum;
        }
    }

    public static void applyTransform(ImageUInt8 input, int[] transform, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, output);
    }

    public static void applyTransform(ImageUInt16 input, int[] transform, ImageUInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, output);
    }

    public static void applyTransform(ImageSInt8 input, int[] transform, int minValue, ImageSInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
    }

    public static void applyTransform(ImageSInt16 input, int[] transform, int minValue, ImageSInt16 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
    }

    public static void applyTransform(ImageSInt32 input, int[] transform, int minValue, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceHistogram.applyTransform(input, transform, minValue, output);
    }

    public static void equalizeLocal(ImageUInt8 input, int radius, ImageUInt8 output, int[] histogram, int[] transform) {
        InputSanityCheck.checkSameShape(input, output);
        int width = radius * 2 + 1;
        if (input.width >= width && input.height >= width) {
            ImplEnhanceHistogram.equalizeLocalInner(input, radius, output, histogram);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, input.height - radius, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, input.width - radius, output, histogram, transform);
        } else if (input.width < width && input.height < width) {
            ImageStatistics.histogram(input, histogram);
            EnhanceImageOps.equalize(histogram, transform);
            EnhanceImageOps.applyTransform(input, transform, output);
        } else {
            ImplEnhanceHistogram.equalizeLocalNaive(input, radius, output, transform);
        }
    }

    public static void equalizeLocal(ImageUInt16 input, int radius, ImageUInt16 output, int[] histogram, int[] transform) {
        InputSanityCheck.checkSameShape(input, output);
        int width = radius * 2 + 1;
        if (input.width >= width && input.height >= width) {
            ImplEnhanceHistogram.equalizeLocalInner(input, radius, output, histogram);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalRow(input, radius, input.height - radius, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, 0, output, histogram, transform);
            ImplEnhanceHistogram.equalizeLocalCol(input, radius, input.width - radius, output, histogram, transform);
        } else if (input.width < width && input.height < width) {
            ImageStatistics.histogram(input, histogram);
            EnhanceImageOps.equalize(histogram, transform);
            EnhanceImageOps.applyTransform(input, transform, output);
        } else {
            ImplEnhanceHistogram.equalizeLocalNaive(input, radius, output, transform);
        }
    }

    public static void sharpen4(ImageUInt8 input, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner4(input, output, 0, 255);
        ImplEnhanceFilter.sharpenBorder4(input, output, 0, 255);
    }

    public static void sharpen4(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner4(input, output, 0.0f, 255.0f);
        ImplEnhanceFilter.sharpenBorder4(input, output, 0.0f, 255.0f);
    }

    public static void sharpen8(ImageUInt8 input, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner8(input, output, 0, 255);
        ImplEnhanceFilter.sharpenBorder8(input, output, 0, 255);
    }

    public static void sharpen8(ImageFloat32 input, ImageFloat32 output) {
        InputSanityCheck.checkSameShape(input, output);
        ImplEnhanceFilter.sharpenInner8(input, output, 0.0f, 255.0f);
        ImplEnhanceFilter.sharpenBorder8(input, output, 0.0f, 255.0f);
    }
}

