/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform;

import georegression.struct.InvertibleTransform;
import java.util.ArrayList;
import java.util.List;

public class InvertibleTransformSequence<T extends InvertibleTransform> {
    private List<Node<T>> path = new ArrayList<Node<T>>();

    public void addTransform(boolean forward, T tran) {
        this.path.add(new Node<T>(tran, forward));
    }

    public void clear() {
        this.path.clear();
    }

    public void computeTransform(T result) {
        if (this.path.size() == 0) {
            return;
        }
        Object tmp0 = result.createInstance();
        Object tmp1 = result.createInstance();
        Object inv = result.createInstance();
        Node<T> n = this.path.get(0);
        Object nodeTran = n.tran;
        if (n.forward) {
            tmp0.set(nodeTran);
        } else {
            nodeTran.invert(tmp0);
        }
        for (int i = 1; i < this.path.size(); ++i) {
            n = this.path.get(i);
            nodeTran = n.tran;
            if (n.forward) {
                tmp0.concat(nodeTran, tmp1);
            } else {
                nodeTran.invert(inv);
                tmp0.concat(inv, tmp1);
            }
            Object swap = tmp0;
            tmp0 = tmp1;
            tmp1 = swap;
        }
        result.set(tmp0);
    }

    public List<Node<T>> getPath() {
        return this.path;
    }

    public static class Node<T extends InvertibleTransform> {
        public T tran;
        public boolean forward;

        public Node(T tran, boolean forward) {
            this.tran = tran;
            this.forward = forward;
        }
    }
}

