/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_I32;
import georegression.struct.shapes.Rectangle2D_I32;
import georegression.struct.shapes.RectangleLength2D_I32;

public class Intersection2D_I32 {
    public static boolean intersects(Rectangle2D_I32 a, Rectangle2D_I32 b) {
        return a.x0 < b.x1 && a.x1 > b.x0 && a.y0 < b.y1 && a.y1 > b.y0;
    }

    public static boolean intersection(Rectangle2D_I32 a, Rectangle2D_I32 b, Rectangle2D_I32 result) {
        if (!Intersection2D_I32.intersects(a, b)) {
            return false;
        }
        result.x0 = Math.max(a.x0, b.x0);
        result.x1 = Math.min(a.x1, b.x1);
        result.y0 = Math.max(a.y0, b.y0);
        result.y1 = Math.min(a.y1, b.y1);
        return true;
    }

    public static boolean containConvex(Polygon2D_I32 polygon, Point2D_I32 pt) {
        int N = polygon.size();
        boolean c = false;
        int i = 0;
        int j = N - 1;
        while (i < N) {
            Point2D_I32 a = ((Point2D_I32[])polygon.vertexes.data)[i];
            Point2D_I32 b = ((Point2D_I32[])polygon.vertexes.data)[j];
            if (a.y > pt.y != b.y > pt.y && pt.x < (b.x - a.x) * (pt.y - a.y) / (b.y - a.y) + a.x) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static boolean containConcave(Polygon2D_I32 polygon, Point2D_I32 pt) {
        int N = polygon.size();
        int left = 0;
        int right = 0;
        for (int i = 0; i < N - 1; ++i) {
            double x;
            Point2D_I32 a = ((Point2D_I32[])polygon.vertexes.data)[i];
            Point2D_I32 b = ((Point2D_I32[])polygon.vertexes.data)[i + 1];
            if ((pt.y < a.y || pt.y >= b.y) && (pt.y < b.y || pt.y >= a.y)) continue;
            double d = x = b.y == a.y ? (double)pt.x : (double)((pt.y - a.y) * (b.x - a.x)) / (double)(b.y - a.y) + (double)a.x;
            if (x <= (double)pt.x) {
                ++left;
                continue;
            }
            if (!(x > (double)pt.x)) continue;
            ++right;
        }
        Point2D_I32 a = ((Point2D_I32[])polygon.vertexes.data)[N - 1];
        Point2D_I32 b = ((Point2D_I32[])polygon.vertexes.data)[0];
        if (pt.y >= a.y && pt.y < b.y || pt.y >= b.y && pt.y < a.y) {
            double x;
            double d = x = b.y == a.y ? (double)pt.x : (double)((pt.y - pt.y) * (b.x - a.x)) / (double)(b.y - a.y) + (double)a.x;
            if (x <= (double)pt.x) {
                ++left;
            } else if (x > (double)pt.x) {
                ++right;
            }
        }
        return left % 2 == 1 && right % 2 == 1;
    }

    public static boolean contains(RectangleLength2D_I32 a, int x, int y) {
        if (a.getX() <= x && a.getX() + a.getWidth() > x) {
            return a.getY() <= y && a.getY() + a.getHeight() > y;
        }
        return false;
    }
}

