/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint2D_F64;
import georegression.metric.ClosestPoint2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;

public class Distance2D_F64 {
    public static double distance(LineParametric2D_F64 line, Point2D_F64 p) {
        return Math.sqrt(Distance2D_F64.distanceSq(line, p));
    }

    public static double distanceSq(LineParametric2D_F64 line, Point2D_F64 p) {
        double t = ClosestPoint2D_F64.closestPointT(line, p);
        double a = line.slope.x * t + line.p.x;
        double b = line.slope.y * t + line.p.y;
        double dx = p.x - a;
        double dy = p.y - b;
        return dx * dx + dy * dy;
    }

    public static double distance(LineSegment2D_F64 line, Point2D_F64 p) {
        double a = line.b.x - line.a.x;
        double b = line.b.y - line.a.y;
        double t = a * (p.x - line.a.x) + b * (p.y - line.a.y);
        if ((t /= a * a + b * b) < 0.0) {
            return UtilPoint2D_F64.distance(line.a.x, line.a.y, p.x, p.y);
        }
        if (t > 1.0) {
            return UtilPoint2D_F64.distance(line.b.x, line.b.y, p.x, p.y);
        }
        return UtilPoint2D_F64.distance(line.a.x + t * a, line.a.y + t * b, p.x, p.y);
    }

    public static double distance(LineGeneral2D_F64 line, Point2D_F64 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C) / Math.sqrt(line.A * line.A + line.B * line.B);
    }
}

