/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.affine;

import georegression.fitting.MotionTransformPoint;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class MotionAffinePoint2D_F32
implements MotionTransformPoint<Affine2D_F32, Point2D_F32> {
    private LinearSolver<DenseMatrix64F> solver;
    private DenseMatrix64F A;
    protected DenseMatrix64F x;
    private DenseMatrix64F y;
    Affine2D_F32 model = new Affine2D_F32();

    public MotionAffinePoint2D_F32() {
        this.solver = LinearSolverFactory.leastSquares((int)100, (int)2);
        this.x = new DenseMatrix64F(3, 2);
        this.A = new DenseMatrix64F(0, 3);
        this.y = new DenseMatrix64F(0, 2);
    }

    @Override
    public Affine2D_F32 getTransformSrcToDst() {
        return this.model;
    }

    @Override
    public boolean process(List<Point2D_F32> srcPts, List<Point2D_F32> dstPts) {
        int i;
        int N = srcPts.size();
        if (N != dstPts.size()) {
            throw new IllegalArgumentException("From and to lists must be the same size");
        }
        if (N < 3) {
            throw new IllegalArgumentException("Must be at least 3 points");
        }
        if (this.A.data.length < N * 3) {
            this.A.reshape(N, 3, true);
            this.y.reshape(N, 2, true);
            for (i = 0; i < N; ++i) {
                this.A.set(i, 2, 1.0);
            }
        } else {
            this.A.reshape(N, 3, false);
            this.y.reshape(N, 2, false);
        }
        for (i = 0; i < N; ++i) {
            Point2D_F32 pt2 = srcPts.get(i);
            Point2D_F32 pt1 = dstPts.get(i);
            this.A.set(i, 0, (double)pt2.x);
            this.A.set(i, 1, (double)pt2.y);
            this.y.set(i, 0, (double)pt1.x);
            this.y.set(i, 1, (double)pt1.y);
        }
        if (!this.solver.setA((Matrix64F)this.A)) {
            return false;
        }
        this.solver.solve((Matrix64F)this.y, (Matrix64F)this.x);
        this.model.a11 = (float)this.x.data[0];
        this.model.a12 = (float)this.x.data[2];
        this.model.tx = (float)this.x.data[4];
        this.model.a21 = (float)this.x.data[1];
        this.model.a22 = (float)this.x.data[3];
        this.model.ty = (float)this.x.data[5];
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

