/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.core.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.ImageSingleBand;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public abstract class ProcessImageSequence<T extends ImageSingleBand>
implements MouseListener,
KeyListener {
    private SimpleImageSequence<T> sequence;
    private T image;
    private volatile boolean paused;
    private volatile boolean step;
    protected int imgWidth;
    protected int imgHeight;
    protected int savedIndex;

    public ProcessImageSequence(SimpleImageSequence<T> sequence) {
        this.sequence = sequence;
        if (!sequence.hasNext()) {
            throw new IllegalArgumentException("Image sequence must have at least one image in it.");
        }
        this.image = (ImageSingleBand)sequence.next();
        this.imgWidth = this.image.getWidth();
        this.imgHeight = this.image.getHeight();
        System.out.println("Input Image size = " + this.imgWidth + " " + this.imgHeight);
        System.out.println();
    }

    public void addComponent(JComponent comp) {
        comp.addMouseListener(this);
        comp.addKeyListener(this);
    }

    public void process() {
        long totalTime = 0L;
        int numFrames = 0;
        this.paused = false;
        this.step = false;
        long startNano = System.nanoTime();
        while (true) {
            long before = System.nanoTime();
            this.processFrame(this.image);
            long after = System.nanoTime();
            if (numFrames > 0) {
                this.printFPS(totalTime += after - before, numFrames, startNano);
            } else {
                System.out.println("First frame processed.");
            }
            ++numFrames;
            this.updateGUI((BufferedImage)this.sequence.getGuiImage(), this.image);
            while (this.paused) {
                if (this.step) {
                    this.step = false;
                    break;
                }
                Thread.yield();
            }
            if (!this.sequence.hasNext()) break;
            this.image = (ImageSingleBand)this.sequence.next();
        }
        this.finishedSequence();
        this.printFPS(totalTime, numFrames, startNano);
        this.sequence.close();
    }

    private void printFPS(long totalTime, int numFrames, long startNano) {
        double seconds = (double)totalTime / 1.0E9;
        double allSeconds = (double)(System.nanoTime() - startNano) / 1.0E9;
        double fps = (double)numFrames / seconds;
        double tfps = (double)numFrames / allSeconds;
        System.out.printf("Frame # = %5d FPS = %6.2f TFPS = %6.2f ET = %7.1f\n", numFrames, fps, tfps, allSeconds);
    }

    public abstract void processFrame(T var1);

    public abstract void updateGUI(BufferedImage var1, T var2);

    public void finishedSequence() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof JComponent) {
            JComponent jc = (JComponent)e.getSource();
            jc.requestFocusInWindow();
        }
        this.paused = !this.paused;
        System.out.println("Pause = " + this.paused);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == 'p') {
            this.paused = false;
        } else if (e.getKeyChar() == 's') {
            System.out.println("Saving image");
            String name = String.format("image%05d.jpg", this.savedIndex++);
            BufferedImage img = ConvertBufferedImage.convertTo(this.image, null, (boolean)true);
            UtilImageIO.saveImage((BufferedImage)img, (String)name);
        } else {
            this.paused = true;
            this.step = true;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

