/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Device;
import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GetPropReceiver
extends MultiLineReceiver {
    static final String GETPROP_COMMAND = "getprop";
    private static final Pattern GETPROP_PATTERN = Pattern.compile("^\\[([^]]+)\\]\\:\\s*\\[(.*)\\]$");
    private Device mDevice = null;

    public GetPropReceiver(Device device) {
        this.mDevice = device;
    }

    @Override
    public void processNewLines(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (line.length() != 0 && !line.startsWith("#") && (m = GETPROP_PATTERN.matcher(line)).matches()) {
                String label = m.group(1);
                String value = m.group(2);
                if (label.length() > 0) {
                    this.mDevice.addProperty(label, value);
                }
            }
            ++n2;
        }
    }

    @Override
    public void commandId(String commandId) {
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void done() {
        this.mDevice.update(4);
    }
}

