/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.parsing;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.SingleReaderStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReaderException;
import java.io.IOException;
import java.text.MessageFormat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XmlStreamReader {
    private AbstractReadStrategy readStrategy;
    private boolean isWaitTimeExpired;

    public XmlStreamReader(XmlPullParser xpp) {
        this(new SingleReaderStrategy(xpp));
    }

    public XmlStreamReader(AbstractReadStrategy readStrategy) {
        this.readStrategy = readStrategy;
        this.isWaitTimeExpired = false;
    }

    public void read() throws XmlPullParserException, IOException, XmlStreamReaderException {
        this.readStrategy.readElement(this);
    }

    public void read(long maxWaitTime) throws XmlPullParserException, IOException, XmlStreamReaderException {
        this.readStrategy.readElement(this, maxWaitTime);
    }

    protected abstract boolean processStartElement(XmlPullParser var1) throws XmlStreamReaderException;

    protected boolean processEndElement(XmlPullParser xpp) {
        String name = xpp.getName();
        RubyDebugCorePlugin.debug(MessageFormat.format("Reader {0} received End element: {1}", this.getClass().getName(), name));
        return true;
    }

    public void processContent(String text) {
    }

    public boolean isWaitTimeExpired() {
        return this.isWaitTimeExpired;
    }

    protected void setWaitTimeExpired(boolean isWaitTimeExpired) {
        this.isWaitTimeExpired = isWaitTimeExpired;
    }
}

