/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core.parsing;

import com.aptana.ruby.debug.core.RubyDebugCorePlugin;
import com.aptana.ruby.internal.debug.core.model.RubyProcessingException;
import com.aptana.ruby.internal.debug.core.parsing.AbstractReadStrategy;
import com.aptana.ruby.internal.debug.core.parsing.XmlStreamReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmlpull.v1.XmlPullParser;

public class LoadResultReader
extends XmlStreamReader {
    private LoadResult loadResult;

    public LoadResultReader(XmlPullParser xpp) {
        super(xpp);
    }

    public LoadResultReader(AbstractReadStrategy readStrategy) {
        super(readStrategy);
    }

    public IStatus readLoadResult() throws RubyProcessingException {
        this.loadResult = new LoadResult();
        try {
            this.read();
        }
        catch (Exception ex) {
            RubyDebugCorePlugin.log(ex);
        }
        int code = 4;
        if (this.loadResult.isOk()) {
            code = 0;
        }
        StringBuilder builder = new StringBuilder();
        if (this.loadResult.exceptionType != null) {
            builder.append(this.loadResult.exceptionType).append(": ");
        }
        builder.append(this.loadResult.exceptionMessage);
        return new Status(code, "com.aptana.ruby.debug.core", -1, builder.toString(), null);
    }

    @Override
    protected boolean processStartElement(XmlPullParser xpp) {
        String name = xpp.getName();
        if (name.equals("loadResult")) {
            this.loadResult.setFileName(xpp.getAttributeValue("", "fileName"));
            this.loadResult.setExceptionType(xpp.getAttributeValue("", "exceptionType"));
            this.loadResult.setExceptionMessage(xpp.getAttributeValue("", "exceptionMessage"));
            return true;
        }
        return false;
    }

    public class LoadResult {
        private String fileName;
        private String exceptionMessage;
        private String exceptionType;

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public void setExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        public String getExceptionType() {
            return this.exceptionType;
        }

        public void setExceptionType(String exceptionType) {
            this.exceptionType = exceptionType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public boolean isOk() {
            return this.exceptionType == null;
        }
    }
}

