/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.Messages;
import com.aptana.core.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class URLUtil {
    public static String joinParameters(Map<String, String> parameters) throws UnsupportedEncodingException {
        return URLUtil.joinParameters(parameters, true);
    }

    public static String joinParameters(Map<String, String> parameters, boolean encode) throws UnsupportedEncodingException {
        if (parameters == null) {
            return "";
        }
        ArrayList<String> builder = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (encode) {
                String value = entry.getValue() != null ? entry.getValue() : "";
                builder.add(String.valueOf(URLEncoder.encode(entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8"));
                continue;
            }
            builder.add(String.valueOf(entry.getKey()) + "=" + entry.getValue());
        }
        return StringUtil.join("&", builder);
    }

    public static URL appendParameters(URL url, String[] parameters) throws MalformedURLException, UnsupportedEncodingException {
        if (parameters == null) {
            return url;
        }
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException(Messages.URLUtil_EvenNumberUrlParameters);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < parameters.length) {
            params.put(parameters[i], parameters[i + 1]);
            i += 2;
        }
        return URLUtil.appendParameters(url, params, true);
    }

    public static URL appendParameters(URL url, Map<String, String> parameters) throws MalformedURLException, UnsupportedEncodingException {
        return URLUtil.appendParameters(url, parameters, true);
    }

    public static URL appendDefaultParameters(URL url) throws MalformedURLException, UnsupportedEncodingException {
        Map<String, String> parameters = URLUtil.getDefaultParameters();
        return URLUtil.appendParameters(url, parameters, true);
    }

    public static Map<String, String> getDefaultParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("nl", System.getProperty("osgi.nl", Locale.getDefault().toString()));
        parameters.put("v", EclipseUtil.getProductVersion());
        return parameters;
    }

    public static URL appendParameters(URL url, Map<String, String> parameters, boolean encode) throws MalformedURLException, UnsupportedEncodingException {
        if (url == null) {
            return null;
        }
        if (parameters == null) {
            return url;
        }
        String urlString = url.toString();
        int questionIndex = urlString.indexOf(63);
        int anchorIndex = urlString.indexOf(35);
        String separator = questionIndex < 0 ? "?" : "&";
        String params = URLUtil.joinParameters(parameters, encode);
        String newUrl = null;
        newUrl = anchorIndex < 0 ? String.valueOf(urlString) + separator + params : String.valueOf(urlString.substring(0, anchorIndex)) + separator + params + urlString.substring(anchorIndex);
        return new URL(newUrl);
    }

    public static String getHttpUrlFileName(URLConnection http) {
        String field = http.getHeaderField("Content-Disposition");
        String filename = null;
        if (StringUtil.isNotBlank(field)) {
            filename = field.substring(field.indexOf("filename") + 10, field.length() - 1);
        } else {
            int index;
            String path = http.getURL().getPath();
            if (StringUtil.isNotBlank(path) && (index = path.replace("\\", "/").lastIndexOf("/")) < path.length() - 1) {
                index = index < 0 ? 0 : index + 1;
                filename = path.substring(index);
            }
        }
        return filename;
    }
}

