/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IStatusCollectorListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;

public class StatusCollector {
    private Map<Object, IStatus> statuses = new HashMap<Object, IStatus>();
    private Set<IStatusCollectorListener> listeners = new HashSet<IStatusCollectorListener>(5);

    public void setStatus(IStatus status, Object id) {
        if (status == null) {
            this.clearStatus(id);
            return;
        }
        IStatus oldStatus = this.statuses.put(id, status);
        if (oldStatus == null || !oldStatus.equals(status)) {
            this.notifyChange(oldStatus, status);
        }
    }

    public IStatus getStatus(Object id) {
        return this.statuses.get(id);
    }

    public void clearStatus(Object id) {
        IStatus removed = this.statuses.remove(id);
        if (removed != null) {
            this.notifyChange(removed, null);
        }
    }

    public IStatus[] getStatuses(int severity) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        for (IStatus status : this.statuses.values()) {
            if (!status.matches(severity)) continue;
            result.add(status);
        }
        return result.toArray(new IStatus[result.size()]);
    }

    public int getStatusCount(int severity) {
        return this.getStatuses(severity).length;
    }

    public void addListener(IStatusCollectorListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IStatusCollectorListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyChange(final IStatus oldStatus, final IStatus newStatus) {
        IStatusCollectorListener[] notifyTo;
        IStatusCollectorListener[] iStatusCollectorListenerArray = notifyTo = this.listeners.toArray(new IStatusCollectorListener[this.listeners.size()]);
        int n = notifyTo.length;
        int n2 = 0;
        while (n2 < n) {
            final IStatusCollectorListener listener = iStatusCollectorListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.statusChanged(oldStatus, newStatus);
                }

                public void handleException(Throwable exception) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), "StatusCollector: Error while notifying a staus change event.", exception);
                }
            });
            ++n2;
        }
    }
}

