/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.Messages;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;

public abstract class IOUtil {
    public static final String UTF_8 = "UTF-8";
    private static final int BUFFER_SIZE = 8192;

    public static String read(InputStream stream) {
        return IOUtil.read(stream, null);
    }

    /*
     * Loose catch block
     */
    public static String read(InputStream stream, String charset) {
        char[] bomBuffer;
        if (stream == null) {
            return null;
        }
        BufferedReader reader = null;
        if (charset == null) {
            if (stream.markSupported()) {
                CharsetDetector detector = new CharsetDetector();
                CharsetMatch match = detector.setText(stream).detect();
                charset = match.getName();
                reader = new BufferedReader(match.getReader());
            } else {
                charset = UTF_8;
                reader = new BufferedReader(new InputStreamReader(stream, charset));
            }
        } else {
            reader = new BufferedReader(new InputStreamReader(stream, charset));
        }
        StringBuilder output = new StringBuilder();
        if (charset.toUpperCase().equals(UTF_8) && reader.read(bomBuffer = new char[1]) != -1 && bomBuffer[0] != '\ufeff') {
            output.append(bomBuffer, 0, bomBuffer.length);
        }
        char[] buffer = new char[8192];
        int read = 0;
        while ((read = reader.read(buffer)) != -1) {
            output.append(buffer, 0, read);
        }
        String string = output.toString();
        try {
            if (reader != null) {
                reader.close();
            } else if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException e) {
            try {
                IOUtil.log(e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    } else if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                } else if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void log(Exception e) {
        if (CorePlugin.getDefault() == null) {
            return;
        }
        IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
    }

    public static IStatus copyDirectoryWithProgress(File source, File destination, IProgressMonitor monitor, boolean cancelable) {
        if (source.isDirectory()) {
            int updateSize = 2;
            if (monitor != null) {
                int totalFiles = IOUtil.countFiles(source);
                updateSize = IOUtil.determineProgressBatchUpdateCount(totalFiles);
                int totalWork = totalFiles / updateSize;
                if (totalFiles % updateSize > 0) {
                    ++totalWork;
                }
                monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
            }
            try {
                return IOUtil.copyDirectory(source, destination, monitor, new int[1], updateSize, cancelable);
            }
            catch (IOException e) {
                return new Status(4, "com.aptana.core", 4, Messages.IOUtil_Directory_Copy_Error, (Throwable)e);
            }
        }
        return new Status(4, "com.aptana.core", 4, Messages.IOUtil_Source_Not_Directory_Error, null);
    }

    private static int countFiles(File source) {
        String[] list = source.list();
        int count = list.length;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File child = new File(source, file);
            if (child.isDirectory()) {
                count += IOUtil.countFiles(child);
            }
            ++n2;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private static IStatus copyDirectory(File source, File destination, IProgressMonitor monitor, int[] count, int updateSize, boolean cancelable) throws IOException {
        if (monitor != null) {
            if (cancelable && monitor.isCanceled()) {
                return new Status(8, "com.aptana.core", 8, "", null);
            }
            count[0] = count[0] + 1;
            if (updateSize < 2 || count[0] % updateSize == 0) {
                monitor.setTaskName(MessageFormat.format(Messages.IOUtil_Copy_Label, new Object[]{destination.toString()}));
                monitor.worked(1);
            }
        }
        if (!source.isDirectory()) ** GOTO lbl37
        error = null;
        if (!source.canRead()) {
            error = Messages.IOUtil_Source_Directory_Not_Readable;
        } else if (!destination.exists()) {
            if (!destination.mkdir()) {
                error = Messages.IOUtil_Destination_Directory_Uncreatable;
            }
        } else if (!destination.isDirectory()) {
            error = Messages.IOUtil_Destination_Is_Not_A_Directory;
        } else if (!destination.canWrite()) {
            error = Messages.IOUtil_Destination_Directory_Not_Writable;
        }
        if (error == null) {
            var10_8 = source.list();
            var9_9 = var10_8.length;
            var8_10 = 0;
            while (var8_10 < var9_9) {
                filename = var10_8[var8_10];
                status = IOUtil.copyDirectory(new File(source, filename), new File(destination, filename), monitor, count, updateSize, cancelable);
                if (status != null && !status.isOK()) {
                    return status;
                }
                ++var8_10;
            }
        } else {
            message = MessageFormat.format(Messages.IOUtil_Unable_To_Copy_Because, new Object[]{source, destination, error});
            IdeLog.logError((Plugin)CorePlugin.getDefault(), message);
            return new Status(4, "com.aptana.core", 4, message, null);
lbl37:
            // 1 sources

            src = EFS.getLocalFileSystem().fromLocalFile(source);
            try {
                src.copy(EFS.getLocalFileSystem().fromLocalFile(destination), 2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                return new Status(4, "com.aptana.core", 4, e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus copyDirectory(File source, File destination) throws IOException {
        return IOUtil.copyDirectory(source, destination, null, new int[1], 0, false);
    }

    public static void copyFile(File source, File destination) throws IOException {
        long fileSize = source.length();
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        if (fileSize > 0x1400000L) {
            try {
                IOUtil.pipe(in, out);
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        } else {
            IOUtil.copy(in, out);
        }
    }

    private static void copy(FileInputStream iStream, FileOutputStream oStream) throws IOException {
        try {
            FileChannel inChannel = iStream.getChannel();
            FileChannel outChannel = oStream.getChannel();
            long fileSize = inChannel.size();
            long offs = 0L;
            long doneCnt = 0L;
            long copyCnt = Math.min(65536L, fileSize);
            do {
                doneCnt = inChannel.transferTo(offs, copyCnt, outChannel);
                offs += doneCnt;
            } while ((fileSize -= doneCnt) > 0L);
        }
        catch (Throwable throwable) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (oStream != null) {
                oStream.close();
            }
        }
        catch (Exception exception) {}
    }

    public static void extractFile(String bundleId, IPath path, File file) throws IOException {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)bundleId), (IPath)path, null);
        InputStream in = null;
        FileOutputStream out = null;
        if (url == null) {
            return;
        }
        try {
            in = url.openStream();
            out = new FileOutputStream(file);
            IOUtil.pipe(in, out);
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(OutputStream stream, String rawSource) {
        IOUtil.write(stream, rawSource, null);
    }

    public static void write(OutputStream stream, String rawSource, String charset) {
        block17: {
            if (stream == null) {
                return;
            }
            if (rawSource == null) {
                rawSource = "";
            }
            if (charset == null) {
                charset = UTF_8;
            }
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new OutputStreamWriter(stream, charset);
                    writer.write(rawSource);
                }
                catch (IOException e) {
                    IOUtil.log(e);
                    try {
                        if (writer != null) {
                            ((Writer)writer).close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static int determineProgressBatchUpdateCount(int numberOfUpdates) {
        int updateSize = 2;
        if (numberOfUpdates > 1000) {
            updateSize = 25;
        } else if (numberOfUpdates > 100) {
            updateSize = 5;
        }
        return updateSize;
    }

    public static void pipe(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        int bytes = input.read(buffer);
        while (bytes >= 0) {
            output.write(buffer, 0, bytes);
            bytes = input.read(buffer);
        }
    }

    public static boolean isWritableDirectory(File dir) {
        if (dir.isDirectory() && dir.exists()) {
            File tempFile = null;
            try {
                boolean canWrite;
                tempFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".tmp", dir);
                boolean bl = canWrite = tempFile != null && tempFile.exists();
                return bl;
            }
            catch (IOException e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Failed to create a temporary file to check if the directory is writable.", e);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        return false;
    }

    public static boolean isWritablePath(IPath path) {
        if (path.toFile().isFile()) {
            return false;
        }
        int i = 1;
        while (i <= path.segmentCount()) {
            if (IOUtil.isWritableDirectory(path.removeLastSegments(i).toFile())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

