/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class FileUtil {
    public static String NEW_LINE = System.getProperty("line.separator");

    private FileUtil() {
    }

    public static IPath getTempDirectory() {
        return Path.fromOSString((String)System.getProperty("java.io.tmpdir"));
    }

    public static File convertIFileToFile(IFile ifile) throws FileNotFoundException {
        File file = null;
        if (!ifile.exists()) {
            throw new FileNotFoundException(ifile.getFullPath().toOSString());
        }
        file = ifile.getLocation().toFile();
        return file;
    }

    public static boolean isDirectoryAccessible(File directory) {
        if (directory == null) {
            return false;
        }
        return ExecutableUtil.isExecutable(Path.fromOSString((String)directory.getAbsolutePath()));
    }

    public static boolean isSymlink(File file) throws IOException {
        File canonical;
        Assert.isLegal((file != null ? 1 : 0) != 0);
        if (file.getParent() == null) {
            canonical = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            canonical = new File(canonicalDir, file.getName());
        }
        return !canonical.getCanonicalFile().equals(canonical.getAbsoluteFile());
    }

    public static String compressPath(String path, int pathLength) {
        if (StringUtil.isEmpty(path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).length() > pathLength) {
            int firstSlash = path.indexOf(47, 1);
            int endSearch = path.length() - pathLength - firstSlash;
            if (firstSlash < 0 || endSearch < 0) {
                return path;
            }
            int lastSlash = path.indexOf(47, endSearch);
            if (lastSlash > firstSlash) {
                return String.valueOf(path.substring(0, firstSlash)) + "/..." + path.substring(lastSlash);
            }
            lastSlash = path.lastIndexOf(47, path.length() - 2);
            if (lastSlash > firstSlash) {
                return String.valueOf(path.substring(0, firstSlash)) + "/..." + path.substring(lastSlash);
            }
        }
        return path;
    }

    public static String compressLeadingPath(String path, int pathLength) {
        if (StringUtil.isEmpty(path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).length() <= pathLength) {
            return path;
        }
        int endSearch = path.length() - pathLength;
        int lastSlash = path.indexOf(47, endSearch);
        if (lastSlash < 0) {
            return path;
        }
        return "..." + path.substring(lastSlash);
    }

    public static String getExtension(String fileName) {
        if (StringUtil.isEmpty(fileName)) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1 || index == fileName.length()) {
            return "";
        }
        return fileName.substring(index + 1, fileName.length());
    }

    public static String getRandomFileName(String prefix, String suffix) {
        StringBuilder name = new StringBuilder();
        if (prefix != null) {
            name.append(prefix);
        }
        name.append((long)(2.147483647E9 * Math.random()));
        if (suffix != null) {
            name.append(suffix);
        }
        return name.toString();
    }

    public static boolean deleteRecursively(File dir) {
        if (dir == null) {
            return false;
        }
        boolean result = true;
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result = result && FileUtil.deleteRecursively(child);
                ++n2;
            }
        }
        return result && dir.delete();
    }

    public static List<File> gatherFilesFromCommandLineArguments(String[] arguments) {
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < arguments.length) {
            if ("-keyring".equalsIgnoreCase(arguments[i])) {
                if (arguments.length > i + 1) {
                    ++i;
                }
            } else {
                File file = new File(arguments[i]);
                if (file.exists()) {
                    files.add(file);
                }
            }
            ++i;
        }
        return files;
    }

    public static int countFiles(File file) {
        block6: {
            if (file == null) {
                return 0;
            }
            if (!FileUtil.isSymlink(file)) break block6;
            return 1;
        }
        try {
            if (file.isDirectory()) {
                File[] children;
                int sum = 0;
                File[] fileArray = children = file.listFiles();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    sum += FileUtil.countFiles(child);
                    ++n2;
                }
                return sum;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return 1;
    }

    public static boolean isValidDirectory(String path) {
        File file = new File(path);
        try {
            file.getCanonicalPath();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean checkFileExistsAndExtension(IFile file, String extension) {
        return file != null && file.exists() && file.getFileExtension() != null && file.getFileExtension().toLowerCase().equals(extension);
    }

    public static void copyFile(File sourceFile, File targetFile) {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            try {
                int len;
                inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
                outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] b = new byte[5120];
                while ((len = inBuff.read(b)) != -1) {
                    ((BufferedOutputStream)outBuff).write(b, 0, len);
                }
                ((BufferedOutputStream)outBuff).flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inBuff != null) {
                    try {
                        inBuff.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (outBuff != null) {
                    try {
                        outBuff.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                block30: {
                    e.printStackTrace();
                    if (inBuff == null) break block30;
                    try {
                        inBuff.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (outBuff != null) {
                    try {
                        outBuff.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyDirectiory(String sourceDir, String targetDir) {
        File[] files;
        new File(targetDir).mkdirs();
        File[] fileArray = files = new File(sourceDir).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                String fname = file.getName();
                if (file.isFile()) {
                    File sourceFile = file;
                    File targetFile = new File(String.valueOf(new File(targetDir).getAbsolutePath()) + File.separator + fname);
                    FileUtil.copyFile(sourceFile, targetFile);
                }
                if (file.isDirectory()) {
                    String dir1 = String.valueOf(sourceDir) + "/" + fname;
                    String dir2 = String.valueOf(targetDir) + "/" + fname;
                    FileUtil.copyDirectiory(dir1, dir2);
                }
            }
            ++n2;
        }
    }
}

