/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.resources;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class TaskTag {
    private static final String PREF_PLUGIN_ID = "com.aptana.editor.common";
    public static final String HIGH = "High";
    public static final String NORMAL = "Normal";
    public static final String LOW = "Low";
    private static final Pattern fgCommaSplitter = Pattern.compile(",");
    private static boolean fgCaseSensitive;
    private static IEclipsePreferences.IPreferenceChangeListener fgPrefListener;
    private static volatile List<TaskTag> fgTaskTags;
    private int fPriority;
    private String fName;

    public TaskTag(String name, String priority) {
        this(name, TaskTag.toIntegerValue(priority));
    }

    public TaskTag(String name, int priority) {
        this.fName = name;
        this.fPriority = priority;
    }

    private static int toIntegerValue(String priority) {
        if (HIGH.equalsIgnoreCase(priority)) {
            return 2;
        }
        if (LOW.equalsIgnoreCase(priority)) {
            return 0;
        }
        return 1;
    }

    public Integer getPriority() {
        return this.fPriority;
    }

    public String getName() {
        return this.fName;
    }

    public String getPriorityName() {
        switch (this.fPriority) {
            case 2: {
                return HIGH;
            }
            case 0: {
                return LOW;
            }
        }
        return NORMAL;
    }

    public static boolean isCaseSensitive() {
        TaskTag.initializeValues();
        return fgCaseSensitive;
    }

    protected static synchronized void initializeValues() {
        if (fgPrefListener == null) {
            final IScopeContext[] contexts = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
            try {
                fgPrefListener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        if ("com.aptana.editor.common.taskTagsCaseSensitive".equals(event.getKey())) {
                            fgCaseSensitive = Platform.getPreferencesService().getBoolean(TaskTag.PREF_PLUGIN_ID, "com.aptana.editor.common.taskTagsCaseSensitive", true, contexts);
                        } else if ("com.aptana.editor.common.taskTagPriorities".equals(event.getKey()) || "com.aptana.editor.common.taskTagNames".equals(event.getKey())) {
                            fgTaskTags = TaskTag.getCurrentTaskTags();
                        }
                    }
                };
                EclipseUtil.instanceScope().getNode(PREF_PLUGIN_ID).addPreferenceChangeListener(fgPrefListener);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), "Failed to attach preference listener for task tag prefs", e);
                fgPrefListener = null;
            }
            fgCaseSensitive = Platform.getPreferencesService().getBoolean(PREF_PLUGIN_ID, "com.aptana.editor.common.taskTagsCaseSensitive", true, contexts);
        }
        if (fgTaskTags == null) {
            fgTaskTags = TaskTag.getCurrentTaskTags();
        }
    }

    protected static List<TaskTag> getCurrentTaskTags() {
        try {
            IScopeContext[] contexts = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
            String rawTagNames = Platform.getPreferencesService().getString(PREF_PLUGIN_ID, "com.aptana.editor.common.taskTagNames", null, contexts);
            String rawTagPriorities = Platform.getPreferencesService().getString(PREF_PLUGIN_ID, "com.aptana.editor.common.taskTagPriorities", null, contexts);
            return TaskTag.createTaskTags(rawTagNames, rawTagPriorities);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), "Failed to lookup task tag strings and priorities", e);
            return Collections.emptyList();
        }
    }

    public static Collection<TaskTag> getTaskTags() {
        TaskTag.initializeValues();
        if (fgTaskTags == null) {
            return Collections.emptyList();
        }
        return fgTaskTags;
    }

    private static List<TaskTag> createTaskTags(String rawTagNames, String rawTagPriorities) {
        String[] tagPriorities;
        ArrayList<TaskTag> tags = new ArrayList<TaskTag>();
        String[] tagNames = fgCommaSplitter.split(rawTagNames);
        if (tagNames.length != (tagPriorities = fgCommaSplitter.split(rawTagPriorities)).length) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("Tag name and priority lists weren't the same length. Names: {0}; Priorities: {1}", rawTagNames, rawTagPriorities));
        }
        int i = 0;
        while (i < tagNames.length) {
            String priority = NORMAL;
            if (i < tagPriorities.length) {
                priority = tagPriorities[i];
            }
            tags.add(new TaskTag(tagNames[i], priority));
            ++i;
        }
        return tags;
    }
}

