/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.resources;

import com.aptana.core.internal.resources.MarkerInfo;
import com.aptana.core.internal.resources.MarkerManager;
import com.aptana.core.internal.resources.UniformResourceMarker;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceChangeListener;
import com.aptana.core.util.ArrayUtil;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class MarkerUtils {
    private static final IMarker[] NO_MARKERS = new IMarker[0];

    private MarkerUtils() {
    }

    public static IMarker createMarker(IUniformResource resource, Map attributes, String markerType) throws CoreException {
        MarkerInfo info = new MarkerInfo();
        info.setType(markerType);
        info.setCreationTime(System.currentTimeMillis());
        if (attributes != null) {
            info.setAttributes(attributes, MarkerUtils.getMarkerManager().isPersistent(info));
        }
        MarkerUtils.getMarkerManager().add(resource, info);
        return new UniformResourceMarker(resource, info.getId());
    }

    public static IMarker[] findMarkers(IUniformResource resource, String type, boolean includeSubtypes) {
        MarkerManager markerManager = MarkerUtils.getMarkerManager();
        MarkerInfo[] list = markerManager.findMarkersInfo(resource, type, includeSubtypes);
        if (ArrayUtil.isEmpty((Object[])list)) {
            return NO_MARKERS;
        }
        IMarker[] result = new IMarker[list.length];
        int i = 0;
        while (i < list.length) {
            result[i] = new UniformResourceMarker(resource, list[i].getId());
            ++i;
        }
        return result;
    }

    public static void deleteMarkers(IUniformResource resource, String type, boolean includeSubtypes) throws CoreException {
        IMarker[] toDelete = MarkerUtils.findMarkers(resource, type, includeSubtypes);
        MultiStatus status = new MultiStatus("com.aptana.core", 0, "Errors deleting markers", null);
        IMarker[] iMarkerArray = toDelete;
        int n = toDelete.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                marker.delete();
            }
            catch (CoreException e) {
                status.add((IStatus)new Status(4, "com.aptana.core", e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        if (status.getChildren().length > 0) {
            throw new CoreException((IStatus)status);
        }
    }

    private static MarkerManager getMarkerManager() {
        return MarkerManager.getInstance();
    }

    public static void addResourceChangeListener(IUniformResourceChangeListener listener) {
        MarkerUtils.getMarkerManager().addResourceChangeListener(listener);
    }

    public static void removeResourceChangeListener(IUniformResourceChangeListener listener) {
        MarkerUtils.getMarkerManager().removeResourceChangeListener(listener);
    }

    public static void setCharEnd(Map attributes, int charEnd) {
        attributes.put("charEnd", charEnd);
    }

    public static void setCharStart(Map attributes, int charStart) {
        attributes.put("charStart", charStart);
    }

    public static void setMessage(Map attributes, String message) {
        attributes.put("message", message);
    }

    public static void setLineNumber(Map attributes, int line) {
        attributes.put("lineNumber", line);
    }
}

