/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.resources;

import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceChangeEvent;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.resources.IMarkerDelta;

public class UniformResourceChangeEvent
extends EventObject
implements IUniformResourceChangeEvent {
    private static final IMarkerDelta[] NO_MARKER_DELTAS = new IMarkerDelta[0];
    private static final long serialVersionUID = 1L;
    private transient IUniformResource resource;
    private transient IMarkerDelta[] deltas;

    public UniformResourceChangeEvent(Object source, IUniformResource resource, IMarkerDelta[] deltas) {
        super(source);
        this.resource = resource;
        this.deltas = deltas;
    }

    @Override
    public IMarkerDelta[] findMarkerDeltas(String type, boolean includeSubtypes) {
        ArrayList<IMarkerDelta> matching = new ArrayList<IMarkerDelta>();
        IMarkerDelta[] deltas = this.getMarkerDeltas();
        int i = 0;
        while (i < deltas.length) {
            IMarkerDelta markerDelta = deltas[i];
            if (type == null || (includeSubtypes ? markerDelta.isSubtypeOf(type) : markerDelta.getType().equals(type))) {
                matching.add(markerDelta);
            }
            ++i;
        }
        if (matching.size() == 0) {
            return NO_MARKER_DELTAS;
        }
        return matching.toArray(new IMarkerDelta[matching.size()]);
    }

    @Override
    public IUniformResource getResource() {
        return this.resource;
    }

    @Override
    public IMarkerDelta[] getMarkerDeltas() {
        if (this.deltas == null) {
            return NO_MARKER_DELTAS;
        }
        return this.deltas;
    }
}

