/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core;

import com.aptana.core.Messages;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.eaio.uuid.MACAddress;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String PLUGIN_ID = "com.aptana.core";
    private static final String MID_SEPARATOR = "-";
    private static String mid;
    private static CorePlugin plugin;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        super.start(context);
        plugin = this;
        Job job = new Job("Enable debugging and flush log cache"){

            protected IStatus run(IProgressMonitor monitor) {
                CorePlugin.this.enableDebugging();
                IdeLog.flushCache();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob(job);
        job.schedule();
    }

    private void enableDebugging() {
        EclipseUtil.instanceScope().getNode(PLUGIN_ID).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        IdeLog.StatusLevel currentSeverity = IdeLog.getSeverityPreference();
        IdeLog.setCurrentSeverity(currentSeverity);
        if (!Platform.inDebugMode()) {
            Boolean checked = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "pref_enable_component_debugging", false, null);
            EclipseUtil.setPlatformDebugging(checked);
            if (checked.booleanValue()) {
                String[] components = EclipseUtil.getCurrentDebuggableComponents();
                EclipseUtil.setBundleDebugOptions(components, true);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            EclipseUtil.instanceScope().getNode(PLUGIN_ID).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static String getAptanaStudioVersion() {
        return EclipseUtil.getStudioVersion();
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("pref_debug_level".equals(event.getKey())) {
            IdeLog.setCurrentSeverity(IdeLog.getSeverityPreference());
        }
    }

    public static String getMID() {
        if (mid == null) {
            mid = CorePlugin.generateMID();
        }
        return mid;
    }

    private static String generateMID() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] result = md.digest(MACAddress.getMACAddress().getBytes("UTF-8"));
            Formatter formatter = new Formatter();
            byte[] byArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                formatter.format("%02x", b);
                ++n2;
            }
            String value = formatter.toString();
            StringBuilder buildMe = new StringBuilder();
            buildMe.append(value.substring(0, 8));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(8, 12));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(12, 16));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(16, 20));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(20, 32));
            return buildMe.toString();
        }
        catch (NoSuchAlgorithmException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), Messages.CorePlugin_MD5_generation_error, e);
        }
        catch (UnsupportedEncodingException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return null;
    }
}

