/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.parsing;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.parsing.XMLTokenScanner;
import com.aptana.editor.xml.parsing.lexer.XMLTokenType;
import com.aptana.parsing.lexer.Lexeme;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class XMLParserScanner
implements ITokenScanner {
    private XMLTokenScanner fTokenScanner = new XMLTokenScanner();
    private IDocument fDocument;

    protected Lexeme<XMLTokenType> createLexeme(Object data) throws Exception {
        int offset = this.fTokenScanner.getTokenOffset();
        int length = this.fTokenScanner.getTokenLength();
        XMLTokenType type = data == null ? XMLTokenType.EOF : (XMLTokenType)((Object)data);
        try {
            int totalLength = this.fDocument.getLength();
            if (offset > totalLength) {
                offset = totalLength;
            }
            if (length == -1) {
                length = 0;
            }
            return new Lexeme((Object)type, offset, offset + length - 1, this.fDocument.get(offset, length));
        }
        catch (BadLocationException e) {
            throw new Exception(e.getLocalizedMessage());
        }
    }

    public String getSource(int offset, int length) {
        String result = "";
        try {
            result = this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    public int getTokenLength() {
        return this.fTokenScanner.getTokenLength();
    }

    public int getTokenOffset() {
        return this.fTokenScanner.getTokenOffset();
    }

    public Lexeme<XMLTokenType> nextLexeme() throws Exception {
        IToken token = this.fTokenScanner.nextToken();
        Object data = token.getData();
        while (token.isWhitespace()) {
            token = this.fTokenScanner.nextToken();
            data = token.getData();
        }
        return this.createLexeme(data);
    }

    public IToken nextToken() {
        try {
            Lexeme<XMLTokenType> lexeme = this.nextLexeme();
            return new Token(lexeme.getType());
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            return Token.UNDEFINED;
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fDocument = document;
        this.fTokenScanner.setRange(document, offset, length);
    }

    public void setSource(IDocument document) {
        this.fDocument = document;
        this.fTokenScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
    }

    public void setSource(String text) {
        this.setSource((IDocument)new Document(text));
    }
}

