/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.parsing;

import com.aptana.editor.xml.parsing.XMLAttributeScanner;
import com.aptana.editor.xml.parsing.XMLParseRootNode;
import com.aptana.editor.xml.parsing.XMLParserScanner;
import com.aptana.editor.xml.parsing.ast.XMLCDATANode;
import com.aptana.editor.xml.parsing.ast.XMLCommentNode;
import com.aptana.editor.xml.parsing.ast.XMLElementNode;
import com.aptana.editor.xml.parsing.ast.XMLNode;
import com.aptana.editor.xml.parsing.lexer.XMLTokenType;
import com.aptana.parsing.AbstractParser;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.lexer.Lexeme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;

public class XMLParser
extends AbstractParser {
    public static final XMLNode[] NO_XML_NODES = new XMLNode[0];
    private XMLParserScanner fScanner;
    private XMLAttributeScanner fAttributeScanner;
    private Stack<IParseNode> fElementStack;
    private IProgressMonitor fMonitor;
    protected IParseNode fCurrentElement;
    protected Lexeme<XMLTokenType> fCurrentLexeme;
    private List<IParseNode> fCommentNodes = new ArrayList<IParseNode>();

    protected void advance() throws Exception {
        this.fCurrentLexeme = this.fScanner.nextLexeme();
    }

    protected void closeElement() {
        this.fCurrentElement = this.fElementStack.size() > 0 ? this.fElementStack.pop() : null;
    }

    protected String getSource(int offset, int length) {
        return this.fScanner.getSource(offset, length);
    }

    protected void openElement(XMLElementNode element) {
        if (this.fCurrentElement != null) {
            this.fCurrentElement.addChild((IParseNode)element);
        }
        this.fElementStack.push(this.fCurrentElement);
        this.fCurrentElement = element;
    }

    protected void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fMonitor = parseState.getProgressMonitor();
        this.fScanner = new XMLParserScanner();
        this.fAttributeScanner = new XMLAttributeScanner();
        this.fElementStack = new Stack();
        String source = parseState.getSource();
        this.fScanner.setSource(source);
        int startingOffset = parseState.getStartingOffset();
        XMLParseRootNode root = new XMLParseRootNode(startingOffset, startingOffset + source.length() - 1);
        try {
            this.fCurrentElement = root;
            this.parseAll((IParseNode)root);
            root.setCommentNodes(this.fCommentNodes.toArray(new IParseNode[this.fCommentNodes.size()]));
            working.setParseResult((IParseRootNode)root);
        }
        finally {
            this.fMonitor = null;
            this.fScanner = null;
            this.fAttributeScanner = null;
            this.fElementStack = null;
            this.fCurrentElement = null;
            this.fCurrentLexeme = null;
            this.fCommentNodes.clear();
        }
    }

    protected void parseAll(IParseNode root) throws IOException, Exception {
        this.advance();
        while (this.fCurrentLexeme.getType() != XMLTokenType.EOF && !this.fMonitor.isCanceled()) {
            this.processStatement();
            this.advance();
        }
    }

    protected void parseAttributes(XMLElementNode element) {
        String rawText = this.fCurrentLexeme.getText();
        this.fAttributeScanner.setRange((IDocument)new Document(rawText), 0, rawText.length());
        IToken token = this.fAttributeScanner.nextToken();
        String name = null;
        String value = null;
        while (!token.isEOF()) {
            Object data = token.getData();
            if (data instanceof XMLTokenType) {
                switch ((XMLTokenType)((Object)data)) {
                    case ATTRIBUTE: {
                        name = this.fAttributeScanner.getText();
                        break;
                    }
                    case VALUE: {
                        if (name == null) break;
                        value = this.fAttributeScanner.getText();
                        value = value.substring(1, value.length() - 1);
                        element.setAttribute(name, value);
                        name = null;
                        value = null;
                    }
                }
            }
            token = this.fAttributeScanner.nextToken();
        }
    }

    protected void processComment() {
        XMLCommentNode comment = new XMLCommentNode(this.fCurrentLexeme.getText(), this.fCurrentLexeme.getStartingOffset(), this.fCurrentLexeme.getEndingOffset());
        this.fCommentNodes.add((IParseNode)comment);
        if (this.fCurrentElement != null) {
            this.fCurrentElement.addChild((IParseNode)comment);
        }
    }

    protected void processCDATA() {
        if (this.fCurrentElement != null) {
            XMLCDATANode comment = new XMLCDATANode(this.fCurrentLexeme.getText(), this.fCurrentLexeme.getStartingOffset(), this.fCurrentLexeme.getEndingOffset());
            this.fCurrentElement.addChild((IParseNode)comment);
        }
    }

    protected void processEndTag() {
        ((ParseNode)this.fCurrentElement).setLocation(this.fCurrentElement.getStartingOffset(), this.fCurrentLexeme.getEndingOffset());
        this.closeElement();
    }

    protected void processStartTag() {
        XMLElementNode element = new XMLElementNode(this.fCurrentLexeme.getText(), this.fCurrentLexeme.getStartingOffset(), this.fCurrentLexeme.getEndingOffset());
        this.parseAttributes(element);
        this.openElement(element);
        if (element.isSelfClosing()) {
            this.closeElement();
        }
    }

    protected void processStatement() {
        switch ((XMLTokenType)((Object)this.fCurrentLexeme.getType())) {
            case COMMENT: {
                this.processComment();
                break;
            }
            case CDATA: {
                this.processCDATA();
                break;
            }
            case START_TAG: {
                this.processStartTag();
                break;
            }
            case END_TAG: {
                this.processEndTag();
            }
        }
    }
}

