/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.CorePlugin;
import com.aptana.core.build.IndexBuildHelper;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.build.BuildContext;
import com.pandora.core.stats.Stats;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class IndexBuildParticipant
extends RequiredBuildParticipant {
    private Index fIndex;
    private boolean index_trace_enabled = false;
    private boolean advanced_trace_enabled = false;
    private boolean needSave = true;

    @Override
    public void clean(IProject project, IProgressMonitor monitor) {
        if (this.isCanceled(monitor)) {
            return;
        }
        URI uri = this.getURI(project);
        if (uri != null) {
            if (IndexBuildParticipant.isTraceEnabled()) {
                IndexBuildParticipant.logTrace(MessageFormat.format("Cleaning index for project ''{0}'' ({1})", project.getName(), uri));
            }
            this.getIndexManager().removeIndex(uri);
        }
        this.index_trace_enabled = IdeLog.isTraceEnabled((Plugin)BuildPathCorePlugin.getDefault(), (String)"com.aptana.core/debug/builder/indexer");
        this.advanced_trace_enabled = IdeLog.isTraceEnabled((Plugin)BuildPathCorePlugin.getDefault(), (String)"com.aptana.core/debug/builder/advanced");
    }

    @Override
    public void buildStarting(IProject project, int kind, IProgressMonitor monitor) {
        if (this.isCanceled(monitor)) {
            return;
        }
        this.fIndex = this.getIndex(project, monitor);
    }

    @Override
    public void buildEnding(IProgressMonitor monitor) {
        if (this.isCanceled(monitor)) {
            return;
        }
        if (this.needSave && this.fIndex != null) {
            try {
                this.fIndex.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
        this.fIndex = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        block15: {
            if (this.isCanceled(monitor)) {
                return;
            }
            v0 = this.needSave = context != null && context.isSave() == false;
            if (!this.needSave) {
                return;
            }
            sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (this.fIndex == null) {
                    this.fIndex = this.getIndex(context.getProject(), (IProgressMonitor)sub);
                    if (this.fIndex == null) {
                        return;
                    }
                }
                if (sub.isCanceled()) ** continue;
                this.deleteFile(context, (IProgressMonitor)sub.newChild(10));
                indexers = this.getIndexParticipants(context);
                IndexBuildHelper.startListening((boolean)(context.isReconcile() == false), (IFile)context.getFile());
                if (!CollectionsUtil.isEmpty(indexers)) {
                    workPerIndexer = 90 / indexers.size();
                    for (IFileStoreIndexingParticipant indexer : indexers) {
                        if (sub.isCanceled()) {
                            break block15;
                        }
                        try {
                            startTime = 0L;
                            startTime = System.nanoTime();
                            indexer.index(context, this.fIndex, (IProgressMonitor)sub.newChild(workPerIndexer));
                            endTime = ((double)System.nanoTime() - (double)startTime) / 1000000.0;
                            if (!(endTime >= 1000.0)) continue;
                            Stats.addOperateInfo((String)"performance", (String)"IN", (String)MessageFormat.format("{0} ms build ''{1}'' with ''{2}''", new Object[]{endTime, context.getURI(), indexer.getClass().getName()}));
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Failed to index file {0} with indexer {1}", new Object[]{context.getURI(), indexer.getClass().getName()}), (Throwable)e);
                        }
                    }
                    break block15;
                }
                if (this.advanced_trace_enabled) {
                    IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("No indexers available for file ''{0}''", new Object[]{context.getURI()}), (String)"com.aptana.core/debug/builder/advanced");
                }
            }
            finally {
                sub.done();
            }
        }
    }

    @Override
    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (this.fIndex == null) {
            this.fIndex = this.getIndex(context.getProject(), monitor);
            if (this.fIndex == null) {
                return;
            }
        }
        this.fIndex.remove(context.getURI());
        if (this.advanced_trace_enabled) {
            IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Wiped index for file ''{0}''", context.getURI()), (String)"com.aptana.core/debug/builder/advanced");
        }
    }

    private boolean isCanceled(IProgressMonitor monitor) {
        if (monitor != null) {
            return monitor.isCanceled();
        }
        return false;
    }

    protected URI getURI(IProject project) {
        if (project == null) {
            return null;
        }
        URI uri = project.getLocationURI();
        if (uri != null) {
            return uri;
        }
        IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Project's location URI is null. raw location: {0}, path: {1}", project.getRawLocationURI(), project.getFullPath()));
        return project.getRawLocationURI();
    }

    protected Index getIndex(IProject project, IProgressMonitor monitor) {
        if (project == null || this.isCanceled(monitor)) {
            return null;
        }
        return this.getIndexManager().getIndex(this.getURI(project));
    }

    protected List<IFileStoreIndexingParticipant> getIndexParticipants(BuildContext context) {
        return this.getIndexManager().getIndexParticipants(context.getName());
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected static void logTrace(String message) {
        IdeLog.logInfo((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (String)"com.aptana.core/debug/builder");
    }

    protected static boolean isTraceEnabled() {
        return IdeLog.isTraceEnabled((Plugin)CorePlugin.getDefault(), (String)"com.aptana.core/debug/builder");
    }
}

