/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantWorkingCopy;
import com.aptana.core.build.PreferenceUtil;
import com.aptana.core.internal.build.LazyBuildParticipant;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.index.core.build.BuildContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class BuildParticipantWorkingCopy
implements IBuildParticipantWorkingCopy {
    private IBuildParticipant wrapped;
    private Boolean enabledForBuild;
    private Boolean enabledForReconcile;
    private String[] filters;
    private Map<String, Object> preferences;
    private String qualifier;

    public BuildParticipantWorkingCopy(IBuildParticipant wrapped, String qualifier) {
        this.wrapped = wrapped;
        this.qualifier = qualifier;
        this.enabledForBuild = wrapped.isEnabled(IBuildParticipant.BuildType.BUILD);
        this.enabledForReconcile = wrapped.isEnabled(IBuildParticipant.BuildType.RECONCILE);
    }

    @Override
    public void clean(IProject project, IProgressMonitor monitor) {
        this.wrapped.clean(project, monitor);
    }

    @Override
    public void initContext(BuildContext context) {
    }

    @Override
    public void buildStarting(IProject project, int kind, IProgressMonitor monitor) {
        this.wrapped.buildStarting(project, kind, monitor);
    }

    @Override
    public void buildEnding(IProgressMonitor monitor) {
        this.wrapped.buildEnding(monitor);
    }

    @Override
    public int getPriority() {
        return this.wrapped.getPriority();
    }

    @Override
    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        this.wrapped.buildFile(context, monitor);
    }

    @Override
    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        this.wrapped.deleteFile(context, monitor);
    }

    @Override
    public Set<IContentType> getContentTypes() {
        return this.wrapped.getContentTypes();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public String getId() {
        return this.wrapped.getId();
    }

    @Override
    public boolean isEnabled(IBuildParticipant.BuildType type) {
        switch (type) {
            case BUILD: {
                if (this.enabledForBuild == null) break;
                return this.enabledForBuild;
            }
            case RECONCILE: {
                if (this.enabledForReconcile == null) break;
                return this.enabledForReconcile;
            }
        }
        return this.wrapped.isEnabled(type);
    }

    @Override
    public void setEnabled(IBuildParticipant.BuildType type, boolean enabled) {
        if (this.isRequired()) {
            return;
        }
        switch (type) {
            case BUILD: {
                this.enabledForBuild = enabled;
                break;
            }
            case RECONCILE: {
                this.enabledForReconcile = enabled;
                break;
            }
        }
    }

    @Override
    public void restoreDefaults() {
        this.wrapped.restoreDefaults();
        this.enabledForBuild = null;
        this.enabledForReconcile = null;
        this.filters = null;
    }

    @Override
    public boolean isRequired() {
        return this.wrapped.isRequired();
    }

    @Override
    public List<String> getFilters() {
        if (this.filters != null) {
            return Arrays.asList(this.filters);
        }
        return this.wrapped.getFilters();
    }

    @Override
    public boolean isEnabled(IProject project) {
        return this.wrapped.isEnabled(project);
    }

    @Override
    public void setFilters(String ... filters) {
        this.filters = filters;
    }

    @Override
    public boolean needsRebuild() {
        return this.enabledForBuild == null || !this.enabledForBuild.equals(this.wrapped.isEnabled(IBuildParticipant.BuildType.BUILD)) || this.wrapped.isEnabled(IBuildParticipant.BuildType.BUILD) && (this.filters != null || this.preferences != null);
    }

    @Override
    public IBuildParticipant doSave() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.qualifier);
        if (this.enabledForBuild != null && !this.enabledForBuild.equals(this.wrapped.isEnabled(IBuildParticipant.BuildType.BUILD))) {
            prefs.putBoolean(PreferenceUtil.getEnablementPreferenceKey(this.getId(), IBuildParticipant.BuildType.BUILD), this.enabledForBuild.booleanValue());
        }
        this.enabledForBuild = this.wrapped.isEnabled(IBuildParticipant.BuildType.BUILD);
        if (this.enabledForReconcile != null && !this.enabledForReconcile.equals(this.wrapped.isEnabled(IBuildParticipant.BuildType.RECONCILE))) {
            prefs.putBoolean(PreferenceUtil.getEnablementPreferenceKey(this.getId(), IBuildParticipant.BuildType.RECONCILE), this.enabledForReconcile.booleanValue());
        }
        this.enabledForReconcile = this.wrapped.isEnabled(IBuildParticipant.BuildType.BUILD);
        if (this.filters != null) {
            prefs.put(PreferenceUtil.getFiltersKey(this.getId()), PreferenceUtil.serializeFilters(this.filters));
            this.filters = null;
        }
        if (this.preferences != null) {
            this.setPreferences(prefs, this.preferences);
            this.preferences = null;
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
        return this.wrapped;
    }

    private void setPreferences(IEclipsePreferences prefs, Map<String, ? extends Object> preferences) {
        if (CollectionsUtil.isEmpty(preferences)) {
            return;
        }
        for (Map.Entry<String, ? extends Object> entry : preferences.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                prefs.putBoolean(entry.getKey(), ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Long) {
                prefs.putLong(entry.getKey(), ((Long)value).longValue());
                continue;
            }
            if (value instanceof Integer) {
                prefs.putInt(entry.getKey(), ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                prefs.putDouble(entry.getKey(), ((Double)value).doubleValue());
                continue;
            }
            if (value == null) continue;
            prefs.put(entry.getKey(), value.toString());
        }
    }

    @Override
    public boolean needsReconcile() {
        return false;
    }

    @Override
    public IBuildParticipant getOriginal() {
        if (this.wrapped instanceof LazyBuildParticipant) {
            return ((LazyBuildParticipant)this.wrapped).getParticipant();
        }
        return this.wrapped;
    }

    @Override
    public String getPreferenceString(String prefKey) {
        if (this.preferences != null && this.preferences.containsKey(prefKey)) {
            return (String)this.preferences.get(prefKey);
        }
        return ((AbstractBuildParticipant)this.wrapped).getPreferenceString(prefKey);
    }

    @Override
    public boolean getPreferenceBoolean(String prefKey) {
        if (this.preferences != null && this.preferences.containsKey(prefKey)) {
            return (Boolean)this.preferences.get(prefKey);
        }
        return this.wrapped.getPreferenceBoolean(prefKey);
    }

    @Override
    public void setPreference(String prefKey, Object value) {
        if (this.preferences == null) {
            this.preferences = new HashMap<String, Object>();
        }
        this.preferences.put(prefKey, value);
    }

    @Override
    public IBuildParticipantWorkingCopy getWorkingCopy() {
        return this;
    }

    @Override
    public int getPreferenceInt(String prefKey, int defaultValue) {
        if (this.preferences != null && this.preferences.containsKey(prefKey)) {
            return (Integer)this.preferences.get(prefKey);
        }
        return this.wrapped.getPreferenceInt(prefKey, defaultValue);
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public Set<IFile> relatedFile(BuildContext context, IBuildParticipant.RelatedType tyep, IProgressMonitor monitor) {
        return null;
    }
}

