/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.build.util.BuildHelper;
import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.CorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.build.BuildFileManager;
import com.aptana.core.build.BuildTerminateException;
import com.aptana.core.build.BuilderJob;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Messages;
import com.aptana.core.build.SDocMLFileIndexingFilter;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TimeLogUtils;
import com.aptana.index.core.FileStoreBuildContext;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.IIndexFileContributor;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.build.BuildContext;
import com.aptana.index.core.filter.IIndexFilterParticipant;
import com.aptana.index.core.filter.IndexFilterManager;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.RegularUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class UnifiedBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "com.aptana.ide.core.unifiedBuilder";
    private boolean traceParticipantsEnabled = false;
    static String SPLIT = " ";
    boolean isClean = false;
    Set<IProject> cleanProjects;
    public static final ConcurrentHashMap<URI, Boolean> saveMap = new ConcurrentHashMap();
    HashMap<String, String> buildPathCache = new HashMap();

    private static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("com.aptana.core.problem", true, 2);
                if (UnifiedBuilder.getValitationType() == null) {
                    resource.deleteMarkers("com.aptana.core.task", true, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getProjectHandle();
        List<IBuildParticipant> participants = this.getBuildParticipantManager().getAllBuildParticipants();
        participants = this.filterToEnabled(participants, project);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(participants.size() + 2));
        sub.worked(1);
        UnifiedBuilder.removeProblemsAndTasksFor((IResource)project);
        sub.worked(1);
        if (UnifiedBuilder.getValitationType() != null) {
            participants = this.filterToLazy(participants, true);
        }
        for (IBuildParticipant participant : participants) {
            if (sub.isCanceled()) {
                return;
            }
            participant.clean(project, (IProgressMonitor)sub.newChild(1));
        }
        sub.done();
        this.isClean = true;
        if (this.cleanProjects == null) {
            this.cleanProjects = new HashSet<IProject>();
        }
        this.cleanProjects.add(project);
    }

    private List<IBuildParticipant> filterToEnabled(List<IBuildParticipant> participants, final IProject project) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return item != null && item.isEnabled(project) && item.isEnabled(IBuildParticipant.BuildType.BUILD);
            }
        });
    }

    private List<IBuildParticipant> filterToEnabledForActiveEditor(List<IBuildParticipant> participants, BuildContext context, IFile file) {
        block6: {
            try {
                IFile ifile;
                IEditorInput input;
                boolean result = false;
                final IEditorPart[] editor = new IEditorPart[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            editor[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        }
                        catch (Exception exception) {}
                    }
                });
                if (editor[0] == null || !((input = editor[0].getEditorInput()) instanceof FileEditorInput) || !(ifile = ((FileEditorInput)input).getFile()).equals((Object)file)) break block6;
                Class<?> editorClass = editor[0].getClass();
                try {
                    Field field = editorClass.getField("openManualValidator");
                    field.setAccessible(true);
                    result = field.getBoolean(editor[0]);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Method method = editorClass.getDeclaredMethod("isOpenManualValidator", new Class[0]);
                    method.setAccessible(true);
                    result = (Boolean)method.invoke((Object)editor[0], new Object[0]);
                }
                if (result) {
                    context.setOpenManualValidator(result);
                    return this.getBuildParticipantManager().filterParticipants(participants, context.getContentType());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List<IBuildParticipant> filterToLazy(List<IBuildParticipant> participants, final boolean isLazy) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return item != null && item.isLazy() == isLazy;
            }
        });
    }

    protected IProject[] build(final int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.traceParticipantsEnabled = IdeLog.isTraceEnabled((Plugin)BuildPathCorePlugin.getDefault(), (String)"com.aptana.core/debug/builder/participants");
        final boolean logTraceEnabled = this.traceLoggingEnabled();
        IProject project = this.getProjectHandle();
        final String projectName = project.getName();
        long startTime = System.nanoTime();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final List<IBuildParticipant> allParticipants = this.getBuildParticipantManager().getAllBuildParticipants();
        List<IBuildParticipant> participants = this.filterToEnabled(allParticipants, project);
        IResourceDelta delta = this.getResourceDelta();
        ResourceCollector collector = null;
        Collection buildFiles = new HashSet();
        if (delta != null) {
            HashSet<IFile> relatedFiles = new HashSet<IFile>();
            collector = new ResourceCollector();
            delta.accept((IResourceDeltaVisitor)collector);
            this.relatedFiles(participants, collector.removedFiles, relatedFiles, IBuildParticipant.RelatedType.DELETE, sub.newChild(5));
            this.relatedFiles(participants, collector.addFiles, relatedFiles, IBuildParticipant.RelatedType.ADD, sub.newChild(5));
            buildFiles = CollectionsUtil.union((Collection)CollectionsUtil.union(collector.addFiles, collector.updatedFiles), relatedFiles);
        }
        final HashSet tempSaveFiles = new HashSet();
        final IResourceDelta fDelta = delta;
        final ResourceCollector fCollector = collector;
        final List<IBuildParticipant> fParticipants = participants;
        final HashSet fBuildFiles = buildFiles;
        final String validationType = UnifiedBuilder.getValitationType();
        BuilderJob run = new BuilderJob(project, true){
            private boolean needIndex;
            {
                super($anonymous0, $anonymous1);
                this.needIndex = true;
            }

            public boolean shouldSchedule() {
                if (UnifiedBuilder.this.cleanProjects == null || UnifiedBuilder.this.cleanProjects.isEmpty()) {
                    UnifiedBuilder.this.isClean = false;
                }
                if (UnifiedBuilder.this.isClean && UnifiedBuilder.this.cleanProjects != null && UnifiedBuilder.this.cleanProjects.contains(this.project)) {
                    UnifiedBuilder.this.cleanProjects.remove(this.project);
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)("*********clean \u89e6\u53d1 FULL BUILD **********" + this.project.getLocation().toString()));
                    return true;
                }
                if (kind == 6 || fDelta == null) {
                    boolean isExist = UnifiedBuilder.this.getIndexManager().isExistsUri(this.project.getLocationURI());
                    if (!isExist) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)("*********\u7d22\u5f15\u4e0d\u5b58\u5728\u89e6\u53d1 FULL BUILD **********" + this.project.getLocation().toString()));
                        return true;
                    }
                    if (saveMap.isEmpty()) {
                        this.needIndex = false;
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)("*********\u7d22\u5f15\u5b58\u5728\uff0c\u4e0d\u6267\u884c FULL BUILD **********" + this.project.getLocation().toString()));
                        return false;
                    }
                    return true;
                }
                return true;
            }

            /*
             * Unable to fully structure code
             */
            protected IStatus run(IProgressMonitor monitor) {
                block26: {
                    block25: {
                        block24: {
                            if (validationType != null) {
                                this.setProperty(BuilderJob.BUILDTYPE_VALIDATION, validationType);
                            }
                            if (monitor == null) {
                                monitor = new NullProgressMonitor();
                            }
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            log = TimeLogUtils.getTimeLog();
                            visitor = null;
                            if (!this.needIndex) ** GOTO lbl41
                            buildFileManager = UnifiedBuilder.access$2(UnifiedBuilder.this);
                            buildFileManager.clearProjectFiles(this.project);
                            if (kind == 6 || fDelta == null) {
                                visitor = new CollectingResourceVisitor();
                                visitor.checkWXBuildPath(this.project);
                                this.project.accept((IResourceVisitor)visitor);
                                visitor.files.trimToSize();
                                UnifiedBuilder.this.clearCache();
                                buildFileManager.addProjectHighPriorityIFiles(this.project, visitor.htmlFiles);
                                break block24;
                            }
                            if (!CollectionsUtil.isEmpty((Collection)fBuildFiles)) break block24;
                            sub.done();
                            var7_7 = Status.OK_STATUS;
                            ** for (file : tempSaveFiles)
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    UnifiedBuilder.saveMap.remove(file.getLocationURI());
                                }
                                catch (Exception e) {
                                    IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                                }
                                continue;
                            }
lbl33:
                            // 1 sources

                            return var7_7;
                        }
                        try {
                            try {
                                if (validationType == null) {
                                    sub.setTaskName("\u6784\u5efa\u7d22\u5f15");
                                    UnifiedBuilder.access$4(UnifiedBuilder.this, fDelta, fCollector, kind, logTraceEnabled, projectName, UnifiedBuilder.access$3(UnifiedBuilder.this, fParticipants, false), Collections.EMPTY_LIST, fBuildFiles, tempSaveFiles, sub, visitor);
                                }
                                buildFileManager.clearProjectFiles(this.project);
lbl41:
                                // 2 sources

                                if (validationType == "VALIDATION_ONLY_REMOVE_MARKEER") {
                                    sub.setTaskName("\u6e05\u7406\u9a8c\u8bc1\u7ed3\u679c");
                                } else {
                                    sub.setTaskName("\u8fd0\u884c\u9a8c\u8bc1\u5668");
                                }
                                UnifiedBuilder.access$4(UnifiedBuilder.this, fDelta, fCollector, kind, logTraceEnabled, projectName, UnifiedBuilder.access$3(UnifiedBuilder.this, fParticipants, true), UnifiedBuilder.access$3(UnifiedBuilder.this, allParticipants, true), fBuildFiles, tempSaveFiles, sub, visitor);
                                sub.done();
                                log.logTaskCostTime(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u6784\u5efa\u9879\u76ee", true);
                                break block25;
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                                ** for (file : tempSaveFiles)
                            }
                        }
                        catch (Throwable var6_20) {
                            ** for (file : tempSaveFiles)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                UnifiedBuilder.saveMap.remove(file.getLocationURI());
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                            }
                            continue;
lbl59:
                            // 1 sources

                            break block26;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                UnifiedBuilder.saveMap.remove(file.getLocationURI());
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                            }
                            continue;
                        }
lbl69:
                        // 1 sources

                        throw var6_20;
                    }
                    for (IFile file : tempSaveFiles) {
                        try {
                            UnifiedBuilder.saveMap.remove(file.getLocationURI());
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        boolean isFullBuild = kind == 6 || fDelta == null;
        run.setIsFullBuild(isFullBuild);
        if (isFullBuild || fBuildFiles.size() == 1) {
            run.cancelSameJobs();
        }
        run.schedule();
        if (logTraceEnabled) {
            double endTime = ((double)System.nanoTime() - (double)startTime) / 1000000.0;
            UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_FinishedBuild, projectName, endTime));
        }
        return null;
    }

    private BuildFileManager getBuildFileManager() {
        return BuildFileManager.getInstance();
    }

    private void buildParticipants(IResourceDelta delta, ResourceCollector collector, int kind, boolean logTraceEnabled, String projectName, List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants, Collection<IFile> buildFiles, Set<IFile> tempSaveFiles, SubMonitor sub, CollectingResourceVisitor visitor) throws CoreException {
        if (sub.isCanceled()) {
            return;
        }
        this.buildStarting(participants, kind, (IProgressMonitor)sub.newChild(5));
        if (kind == 6) {
            if (logTraceEnabled) {
                UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_PerformingFullBuld, projectName));
            }
            this.fullBuild(participants, allParticipants, (IProgressMonitor)sub.newChild(40), visitor);
        } else if (delta == null) {
            if (logTraceEnabled) {
                UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_PerformingFullBuildNullDelta, projectName));
            }
            this.fullBuild(participants, allParticipants, (IProgressMonitor)sub.newChild(40), visitor);
        } else {
            if (logTraceEnabled) {
                UnifiedBuilder.logTrace(MessageFormat.format(Messages.UnifiedBuilder_PerformingIncrementalBuild, projectName));
            }
            this.incrementalBuild(collector, kind, participants, allParticipants, buildFiles, tempSaveFiles, (IProgressMonitor)sub.newChild(35));
        }
        this.buildEnding(participants, (IProgressMonitor)sub.newChild(5));
    }

    protected boolean traceLoggingEnabled() {
        return IdeLog.isTraceEnabled((Plugin)CorePlugin.getDefault(), (String)"com.aptana.core/debug/builder");
    }

    private static void logTrace(String msg) {
        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)msg, (String)"com.aptana.core/debug/builder");
    }

    private void buildEnding(List<IBuildParticipant> participants, IProgressMonitor monitor) {
        if (participants == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            if (sub.isCanceled()) break;
            participant.buildEnding((IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    private void buildStarting(List<IBuildParticipant> participants, int kind, IProgressMonitor monitor) {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(participants)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            if (sub.isCanceled()) break;
            participant.buildStarting(this.getProjectHandle(), kind, (IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    private void incrementalBuild(ResourceCollector collector, int kind, List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants, Collection<IFile> buildFiles, Set<IFile> tempSaveFiles, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.removeFiles(participants, collector.removedFiles, (IProgressMonitor)sub.newChild(25));
            this.buildFiles(kind == 9, participants, allParticipants, buildFiles, tempSaveFiles, (IProgressMonitor)sub.newChild(55));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void removeFiles(List<IBuildParticipant> participants, List<IFile> removedFiles, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(removedFiles)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(16 * removedFiles.size()));
        for (IFile file : removedFiles) {
            if (sub.isCanceled()) break;
            BuildContext context = new BuildContext(file);
            sub.worked(1);
            List<IBuildParticipant> filteredParticipants = this.getBuildParticipantManager().filterParticipants(participants, context.getContentType());
            sub.worked(5);
            this.deleteFile(context, filteredParticipants, (IProgressMonitor)sub.newChild(10));
        }
        sub.done();
    }

    private void deleteFile(BuildContext context, List<IBuildParticipant> participants, IProgressMonitor monitor) {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(participants)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            if (sub.isCanceled()) break;
            participant.deleteFile(context, (IProgressMonitor)sub.newChild(1));
        }
        sub.done();
    }

    private void relatedFiles(List<IBuildParticipant> participants, List<IFile> addFiles, Set<IFile> relatedFiles, IBuildParticipant.RelatedType type, SubMonitor monitor) throws CoreException {
        if (!monitor.isCanceled() && !CollectionsUtil.isEmpty(addFiles)) {
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(16 * addFiles.size()));
            for (IFile file : addFiles) {
                if (monitor.isCanceled()) break;
                String relativePath = file.getProjectRelativePath().toString();
                if (relativePath.startsWith("unpackage/")) continue;
                BuildContext context = new BuildContext(file);
                monitor.worked(1);
                List<IBuildParticipant> filteredParticipants = this.getBuildParticipantManager().filterParticipants(participants, context.getContentType());
                monitor.worked(5);
                this.relatedFile(context, filteredParticipants, relatedFiles, type, monitor.newChild(10));
            }
        }
        monitor.done();
    }

    private void relatedFile(BuildContext context, List<IBuildParticipant> participants, Set<IFile> relatedFiles, IBuildParticipant.RelatedType type, SubMonitor monitor) {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(participants)) {
            monitor.done();
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        for (IBuildParticipant participant : participants) {
            if (sub.isCanceled()) break;
            Set<IFile> files = participant.relatedFile(context, type, (IProgressMonitor)sub.newChild(1));
            if (files == null || files.isEmpty()) continue;
            relatedFiles.addAll(files);
        }
        sub.done();
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        return BuildPathCorePlugin.getDefault().getBuildParticipantManager();
    }

    private void fullBuild(List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants, IProgressMonitor monitor, CollectingResourceVisitor visitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProject project = this.getProjectHandle();
        URI uri = project.getLocationURI();
        Set<IFileStore> contributedFiles = this.getContributedFiles(uri);
        sub.worked(5);
        this.buildContributedFiles(participants, contributedFiles, (IProgressMonitor)sub.newChild(10));
        sub.worked(5);
        this.buildFiles(false, participants, allParticipants, visitor.files, null, (IProgressMonitor)sub.newChild(80));
        sub.done();
    }

    protected List<IFileStoreIndexingParticipant> getIndexParticipants(BuildContext context) {
        return this.getIndexManager().getIndexParticipants(context.getName());
    }

    private void buildContributedFiles(List<IBuildParticipant> participants, Set<IFileStore> files, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(files)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(15 * files.size()));
        IProject project = this.getProjectHandle();
        for (IFileStore file : files) {
            if (sub.isCanceled()) break;
            FileStoreBuildContext context = new FileStoreBuildContext(project, file);
            sub.worked(1);
            List<IBuildParticipant> filteredParticipants = this.getBuildParticipantManager().filterParticipants(participants, context.getContentType());
            sub.worked(2);
            this.buildFile((BuildContext)context, filteredParticipants, (IProgressMonitor)sub.newChild(12));
        }
        sub.done();
    }

    protected Set<IFileStore> getContributedFiles(URI container) {
        if (container == null) {
            return null;
        }
        HashSet<IFileStore> result = new HashSet<IFileStore>();
        IndexManager manager = this.getIndexManager();
        if (manager != null) {
            for (IIndexFileContributor contributor : manager.getFileContributors()) {
                Set files = contributor.getFiles(container);
                if (CollectionsUtil.isEmpty((Collection)files)) continue;
                result.addAll(files);
            }
        }
        return result;
    }

    protected IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin == null ? null : plugin.getIndexManager();
    }

    protected IProject getProjectHandle() {
        return this.getProject();
    }

    protected IResourceDelta getResourceDelta() {
        return this.getDelta(this.getProjectHandle());
    }

    private void buildFiles(boolean isIncrementalBuild, List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants, Collection<IFile> buildFiles, Set<IFile> tempSaveFiles, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        if (CollectionsUtil.isEmpty(buildFiles)) {
            monitor.done();
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        buildFiles = this.filterFiles(buildFiles, (IProgressMonitor)sub.newChild(10));
        BuildFileManager buildFileManager = this.getBuildFileManager();
        buildFileManager.addProjectIFiles(this.getProjectHandle(), buildFiles);
        if (buildFiles != null && buildFiles.size() > 1) {
            buildFileManager.initHighPriorityIFiles();
        }
        this.doBuildFiles(isIncrementalBuild, participants, allParticipants, buildFiles, tempSaveFiles, (IProgressMonitor)sub.newChild(90));
        sub.done();
    }

    private void doBuildFiles(boolean isIncrementalBuild, List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants, Collection<IFile> buildFiles, Set<IFile> tempSaveFiles, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        if (CollectionsUtil.isEmpty(buildFiles)) {
            monitor.done();
            return;
        }
        boolean isFullBuild = !isIncrementalBuild;
        int fileSize = buildFiles.size();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(15 * fileSize));
        int i = 0;
        BuildFileManager buildFileManager = this.getBuildFileManager();
        i = this.buildHighPriorityIFiles(isIncrementalBuild, participants, allParticipants, buildFiles, tempSaveFiles, isFullBuild, fileSize, sub, i, buildFileManager);
        List<IFile> noBuildFiles = buildFileManager.getProjectNoBuildIFiles(this.getProjectHandle());
        for (IFile file : noBuildFiles) {
            String relativePath;
            i = this.buildHighPriorityIFiles(isIncrementalBuild, participants, allParticipants, buildFiles, tempSaveFiles, isFullBuild, fileSize, sub, i, buildFileManager);
            if (buildFileManager.isBuilded(file) || (relativePath = file.getProjectRelativePath().toString()).startsWith("unpackage/")) continue;
            i = this.buildFile(i, sub, file, isFullBuild, fileSize, tempSaveFiles, isIncrementalBuild, participants, allParticipants);
            buildFileManager.addProjectBuildedIFile(this.getProjectHandle(), file);
        }
        sub.done();
    }

    private int buildHighPriorityIFiles(boolean isIncrementalBuild, List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants, Collection<IFile> buildFiles, Set<IFile> tempSaveFiles, boolean isFullBuild, int fileSize, SubMonitor sub, int i, BuildFileManager buildFileManager) throws CoreException {
        if (fileSize < 2) {
            return i;
        }
        List<IFile> hFiles = buildFileManager.getProjectHighPriorityIFiles(this.getProjectHandle());
        for (IFile file : hFiles) {
            String relativePath;
            if (!buildFiles.contains(file) || buildFileManager.isBuilded(file) || (relativePath = file.getProjectRelativePath().toString()).startsWith("unpackage/")) continue;
            i = this.buildFile(i, sub, file, isFullBuild, fileSize, tempSaveFiles, isIncrementalBuild, participants, allParticipants);
            buildFileManager.addProjectBuildedIFile(this.getProjectHandle(), file);
        }
        return i;
    }

    private int buildFile(int i, SubMonitor sub, IFile file, boolean isFullBuild, int fileSize, Set<IFile> tempSaveFiles, boolean isIncrementalBuild, List<IBuildParticipant> participants, List<IBuildParticipant> allParticipants) throws CoreException {
        block14: {
            ++i;
            if (sub.isCanceled()) {
                return i;
            }
            BuildContext context = new BuildContext(file, isFullBuild);
            if (i == fileSize) {
                context.setCompleted(true);
            }
            context.setNeedSleep(true);
            sub.worked(1);
            try {
                if (tempSaveFiles != null && isIncrementalBuild && saveMap.containsKey(context.getURI())) {
                    tempSaveFiles.add(file);
                    context.setSave(Boolean.valueOf(true));
                    if (allParticipants != null && !allParticipants.isEmpty()) {
                        List<IBuildParticipant> filters = this.filterToEnabledForActiveEditor(allParticipants, context, file);
                        filters.removeAll(participants);
                        participants.addAll(filters);
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
            if (!isFullBuild) {
                boolean isRemove = this.autoExcludeAndAddBuildPath(file);
                this.clearCache();
                if (isRemove) {
                    return i;
                }
            }
            List filteredParticipants = this.getBuildParticipantManager().filterParticipants(participants, context.getContentType());
            sub.worked(2);
            try {
                List<IBuildParticipant> allContentTypeParticipants = this.getBuildParticipantManager().filterParticipants(allParticipants, context.getContentType());
                for (IBuildParticipant participant : allContentTypeParticipants) {
                    if (participant.isRequired() || !participant.isLazy()) continue;
                    participant.initContext(context);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
            if ("VALIDATION_ONLY_REMOVE_MARKEER".equals(UnifiedBuilder.getValitationType())) {
                filteredParticipants = Collections.EMPTY_LIST;
            }
            try {
                this.buildFile(context, filteredParticipants, (IProgressMonitor)sub.newChild(12));
            }
            catch (Exception e) {
                if (!(e instanceof BuildTerminateException)) break block14;
                Stats.addExceptionInfo((Throwable)e);
                return i;
            }
        }
        BuildHelper.sleep((String)"BUILD_FILE_TYPE");
        return i;
    }

    private Collection<IFile> filterFiles(Collection<IFile> files, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        final SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        files = CollectionsUtil.filter(files, (IFilter)new IFilter<IFile>(){

            public boolean include(IFile item) {
                return !ResourceUtil.shouldIgnore((IFile)item);
            }
        });
        sub.worked(10);
        Set fileStores = new HashSet(CollectionsUtil.map((Collection)files, (IMap)new IMap<IFile, IFileStore>(){

            public IFileStore map(IFile item) {
                IPath path = item.getLocation();
                return path == null ? null : EFS.getLocalFileSystem().getStore(path);
            }
        }));
        sub.worked(15);
        if (!CollectionsUtil.isEmpty(fileStores)) {
            IndexManager manager = this.getIndexManager();
            if (manager != null) {
                for (IIndexFilterParticipant filterParticipant : manager.getFilterParticipants()) {
                    if (sub.isCanceled()) break;
                    fileStores = filterParticipant.applyFilter(fileStores);
                }
            }
            sub.worked(60);
            return CollectionsUtil.map(fileStores, (IMap)new IMap<IFileStore, IFile>(){

                public IFile map(IFileStore fileStore) {
                    if (sub.isCanceled()) {
                        return null;
                    }
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    Object[] iFiles = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
                    if (ArrayUtil.isEmpty((Object[])iFiles)) {
                        return null;
                    }
                    return iFiles[0];
                }
            });
        }
        return files;
    }

    private void buildFile(BuildContext context, List<IBuildParticipant> participants, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * participants.size()));
        for (IBuildParticipant participant : participants) {
            long startTime = System.nanoTime();
            participant.buildFile(context, (IProgressMonitor)sub.newChild(1));
            if (this.traceParticipantsEnabled) {
                double endTime = ((double)System.nanoTime() - (double)startTime) / 1000000.0;
                IdeLog.logTrace((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Executed build participant ''{0}'' on ''{1}'' in {2} ms.", participant.getName(), context.getURI(), endTime), (String)"com.aptana.core/debug/builder/participants");
            }
            BuildHelper.sleep((String)"BUILD_FILE_TYPE");
            if (sub.isCanceled()) break;
        }
        this.updateMarkers(context, (IProgressMonitor)sub.newChild(participants.size()));
        sub.done();
    }

    private void updateMarkers(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        final IFile file = context.getFile();
        final Map itemsByType = context.getProblems();
        if (CollectionsUtil.isEmpty((Map)itemsByType)) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                UnifiedBuilder.this.updateMarkers(file, itemsByType, monitor);
            }
        };
        try {
            runnable.run(monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static ISchedulingRule getMarkerRule(Object resource) {
        if (resource instanceof IResource) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)resource);
        }
        return null;
    }

    private synchronized void updateMarkers(IFile file, Map<String, Collection<IProblem>> itemsByType, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !file.exists()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(itemsByType.size() * 10));
        for (String markerType : itemsByType.keySet()) {
            try {
                if (sub.isCanceled()) break;
                Collection<IProblem> newItems = itemsByType.get(markerType);
                file.deleteMarkers(markerType, false, 2);
                sub.worked(1);
                this.addMarkers(newItems, markerType, file, (IProgressMonitor)sub.newChild(9));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
        sub.done();
    }

    private void addMarkers(Collection<IProblem> items, String markerType, IFile file, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(items)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(items.size() * 2));
        for (IProblem item : items) {
            if (sub.isCanceled()) break;
            IMarker marker = file.createMarker(markerType);
            sub.worked(1);
            marker.setAttributes(item.createMarkerAttributes());
            sub.worked(1);
        }
        sub.done();
    }

    private static String getValitationType() {
        Object property;
        if (Job.getJobManager().currentJob() != null && (property = Job.getJobManager().currentJob().getProperty(BuilderJob.BUILDTYPE_VALIDATION)) != null) {
            return property.toString();
        }
        return null;
    }

    private boolean autoExcludeAndAddBuildPath(IFile iFile) throws CoreException {
        if (SDocMLFileIndexingFilter.buildPathEntrys == null || SDocMLFileIndexingFilter.buildPathEntrys.isEmpty()) {
            SDocMLFileIndexingFilter.init();
        }
        IFileStore iFileStore = EFSUtils.getFileStore((IResource)iFile);
        IndexFilterManager manager = IndexFilterManager.getInstance();
        File file = iFileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
        if (file == null) {
            return true;
        }
        String fname = file.getName();
        fname = fname.toLowerCase();
        boolean isRemove = false;
        String md5 = "";
        String disPlayName = "";
        BuildPathManager buildPathManager = BuildPathManager.getInstance();
        String reg = "\\d+\\.?(\\d*\\.?)\\d*";
        String jqKey = "jquery";
        String jqDisplayName = "jquery 2.0";
        String muiKey = "mui";
        String zeptoKey = "zepto";
        if (StringUtil.isNotBlank((String)fname) && (fname.endsWith(".js") || fname.endsWith(".jsx") || fname.endsWith(".htc"))) {
            Set<String[]> keySet = SDocMLFileIndexingFilter.displayNames.keySet();
            for (String[] nv : keySet) {
                String key = nv[0];
                if (!fname.contains(key = key.toLowerCase())) continue;
                boolean isJQKey = jqKey.equals(key);
                if (!isJQKey) {
                    disPlayName = SDocMLFileIndexingFilter.displayNames.get(nv);
                    if (key.equals(muiKey)) {
                        isRemove = SDocMLFileIndexingFilter.checkIsMuiJS(file);
                        break;
                    }
                    if (!key.equals(zeptoKey)) break;
                    isRemove = SDocMLFileIndexingFilter.checkIsZeptoJS(fname);
                    break;
                }
                if (StringUtil.isBlank((String)md5)) {
                    md5 = SDocMLFileIndexingFilter.getMD5(file);
                }
                isRemove = SDocMLFileIndexingFilter.checkIsJQ(fname);
                if (StringUtil.isBlank((String)md5)) break;
                Object o = buildPathManager.properties.get(md5);
                if (o == null) {
                    this.buildPathCache.put(jqDisplayName, jqKey);
                } else {
                    String jsName = o.toString();
                    if (StringUtil.isBlank((String)jsName) || !(jsName = jsName.toLowerCase()).contains(key)) break;
                }
                String v = RegularUtils.match((String)reg, (String)fname, (int)0);
                if (StringUtil.isBlank((String)v)) break;
                String[] vs = v.split("\\.");
                String lv = vs[0];
                boolean isR = false;
                if (lv.equals("2")) {
                    isR = true;
                } else if (lv.equals("1")) {
                    isR = true;
                }
                if (!isR) continue;
                isRemove = isR;
                if (nv[1].startsWith(lv)) {
                    disPlayName = SDocMLFileIndexingFilter.displayNames.get(nv);
                    break;
                }
                boolean isexist = false;
                for (String[] nvs : keySet) {
                    if (!nvs[0].equals(key) || !nvs[1].startsWith(lv)) continue;
                    disPlayName = SDocMLFileIndexingFilter.displayNames.get(nvs);
                    isexist = true;
                    break;
                }
                if (isexist) break;
            }
        }
        if (StringUtil.isNotBlank((String)disPlayName)) {
            BuildPathEntry buildPathEntry = SDocMLFileIndexingFilter.buildPathEntryMap.get(disPlayName);
            IProject project = iFile.getProject();
            Set<BuildPathEntry> buildPathEntrySet = buildPathManager.getBuildPaths(project);
            if (!buildPathEntrySet.contains(buildPathEntry)) {
                this.buildSDOCmlFile(buildPathEntry, project);
            }
            buildPathEntrySet.add(buildPathEntry);
            Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
            ArrayList<BuildPathEntry> list = new ArrayList<BuildPathEntry>();
            buildPathEntrySet.toArray(bea);
            CollectionsUtil.addToList(list, (Object[])bea);
            buildPathManager.setBuildPaths(project, list);
        }
        if (isRemove) {
            manager.addFilterItem(iFileStore);
            manager.commitFilteredItems();
        }
        return isRemove;
    }

    private void buildSDOCmlFile(BuildPathEntry buildPathEntry, IProject project) throws CoreException {
        if (buildPathEntry == null || project == null) {
            return;
        }
        HashSet<IFileStore> result = new HashSet<IFileStore>();
        IFileStore fileStore = EFS.getStore((URI)buildPathEntry.getPath());
        result.add(fileStore);
        List<IBuildParticipant> participants = this.getBuildParticipantManager().getAllBuildParticipants();
        participants = this.filterToEnabled(participants, project);
        participants = this.filterToLazy(participants, false);
        this.buildContributedFiles(participants, result, (IProgressMonitor)new NullProgressMonitor());
    }

    public void clearCache() {
        try {
            BuildPathManager buildPathManager = BuildPathManager.getInstance();
            Set<BuildPathEntry> buildPathEntrySet = buildPathManager.getBuildPaths(this.getProject());
            Set<String> keys = this.buildPathCache.keySet();
            for (String key : keys) {
                BuildPathEntry buildPathEntry = SDocMLFileIndexingFilter.buildPathEntryMap.get(key);
                if (!buildPathEntrySet.contains(buildPathEntry)) {
                    boolean isAdded = false;
                    for (BuildPathEntry bpe : buildPathEntrySet) {
                        if (!bpe.getDisplayName().toLowerCase().contains(this.buildPathCache.get(key))) continue;
                        isAdded = true;
                        break;
                    }
                    if (!isAdded) {
                        this.buildSDOCmlFile(buildPathEntry, this.getProject());
                        buildPathEntrySet.add(buildPathEntry);
                        Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
                        ArrayList<BuildPathEntry> list = new ArrayList<BuildPathEntry>();
                        buildPathEntrySet.toArray(bea);
                        CollectionsUtil.addToList(list, (Object[])bea);
                        buildPathManager.setBuildPaths(this.getProject(), list);
                        this.buildPathCache.clear();
                        this.buildPathCache = new HashMap();
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ BuildFileManager access$2(UnifiedBuilder unifiedBuilder) {
        return unifiedBuilder.getBuildFileManager();
    }

    static /* synthetic */ List access$3(UnifiedBuilder unifiedBuilder, List list, boolean bl) {
        return unifiedBuilder.filterToLazy(list, bl);
    }

    static /* synthetic */ void access$4(UnifiedBuilder unifiedBuilder, IResourceDelta iResourceDelta, ResourceCollector resourceCollector, int n, boolean bl, String string, List list, List list2, Collection collection, Set set, SubMonitor subMonitor, CollectingResourceVisitor collectingResourceVisitor) throws CoreException {
        unifiedBuilder.buildParticipants(iResourceDelta, resourceCollector, n, bl, string, list, list2, collection, set, subMonitor, collectingResourceVisitor);
    }

    private class CollectingResourceVisitor
    implements IResourceVisitor {
        ArrayList<IFile> files;
        String[] extendtions;
        ArrayList<IFile> htmlFiles;
        String[] hHtmlName = new String[]{"default", "index"};

        private CollectingResourceVisitor() {
            try {
                IContentType[] contentTypes = UnifiedBuilder.this.getProjectHandle().getContentTypeMatcher().findContentTypesFor("1.html");
                if (contentTypes != null && contentTypes.length > 0) {
                    IContentType contentType = contentTypes[0];
                    this.extendtions = contentType.getFileSpecs(8);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.files = new ArrayList();
            this.htmlFiles = new ArrayList();
        }

        public void checkWXBuildPath(IProject project) {
            try {
                if (!project.hasNature("com.pandora.projects.ui.wxNature")) {
                    return;
                }
                if (SDocMLFileIndexingFilter.buildPathEntrys == null || SDocMLFileIndexingFilter.buildPathEntrys.isEmpty()) {
                    SDocMLFileIndexingFilter.init();
                }
                String key = "weixin";
                Set<String[]> keySet = SDocMLFileIndexingFilter.displayNames.keySet();
                String disPlayName = "";
                for (String[] nv : keySet) {
                    String k = nv[0];
                    if (!(k = k.toLowerCase()).contains(key)) continue;
                    disPlayName = SDocMLFileIndexingFilter.displayNames.get(nv);
                    break;
                }
                if (StringUtil.isNotBlank((String)disPlayName)) {
                    BuildPathManager buildPathManager = BuildPathManager.getInstance();
                    BuildPathEntry buildPathEntry = SDocMLFileIndexingFilter.buildPathEntryMap.get(disPlayName);
                    Set<BuildPathEntry> buildPathEntrySet = buildPathManager.getBuildPaths(project);
                    if (!buildPathEntrySet.contains(buildPathEntry)) {
                        UnifiedBuilder.this.buildSDOCmlFile(buildPathEntry, project);
                    }
                    buildPathEntrySet.add(buildPathEntry);
                    Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
                    ArrayList<BuildPathEntry> list = new ArrayList<BuildPathEntry>();
                    buildPathEntrySet.toArray(bea);
                    CollectionsUtil.addToList(list, (Object[])bea);
                    buildPathManager.setBuildPaths(project, list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            if (1 == resource.getType()) {
                boolean isRemove;
                IFile iFile = (IFile)resource;
                String relativePath = iFile.getProjectRelativePath().toString();
                if (relativePath.startsWith("unpackage/")) {
                    return false;
                }
                String fExtendtion = iFile.getFileExtension();
                String fName = iFile.getName();
                fName = StringUtil.isNotBlank((String)fName) && StringUtil.isNotBlank((String)fExtendtion) && fName.indexOf(fExtendtion) - 1 > 0 ? fName.substring(0, fName.indexOf(fExtendtion) - 1) : "";
                if (StringUtil.contains((String[])this.extendtions, (String)fExtendtion) && StringUtil.contains((String[])this.hHtmlName, (String)fName.toLowerCase())) {
                    this.htmlFiles.add(iFile);
                }
                if (!(isRemove = UnifiedBuilder.this.autoExcludeAndAddBuildPath(iFile))) {
                    this.files.add(iFile);
                }
                return false;
            }
            return 2 != resource.getType() || !"unpackage".equals(resource.getName());
        }
    }

    private static class ResourceCollector
    implements IResourceDeltaVisitor {
        List<IFile> updatedFiles = new ArrayList<IFile>();
        List<IFile> addFiles = new ArrayList<IFile>();
        List<IFile> removedFiles = new ArrayList<IFile>();

        private ResourceCollector() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (delta.getKind() == 4 && (delta.getFlags() & 0x100100) != 0) {
                    if (!this.updatedFiles.contains(file)) {
                        this.updatedFiles.add(file);
                    }
                } else if (delta.getKind() == 1) {
                    if (!this.addFiles.contains(file)) {
                        this.addFiles.add(file);
                    }
                } else if (delta.getKind() == 2 && !this.removedFiles.contains(file)) {
                    this.removedFiles.add(file);
                }
            }
            return true;
        }
    }
}

