/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionStatusPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolutionResultsWizardPage
extends ResolutionStatusPage {
    private static final String DIALOG_SETTINGS_SECTION = "ResolutionResultsPage";
    protected IUElementListRoot input;
    ProfileChangeOperation resolvedOperation;
    TreeViewer treeViewer;
    ProvElementContentProvider contentProvider;
    IUDetailsLabelProvider labelProvider;
    protected Display display;
    private IUDetailsGroup iuDetailsGroup;
    SashForm sashForm;

    protected ResolutionResultsWizardPage(ProvisioningUI ui, ProvisioningOperationWizard wizard, IUElementListRoot input, ProfileChangeOperation operation) {
        super("ResolutionPage", ui, wizard);
        this.resolvedOperation = operation;
        this.input = input == null ? new IUElementListRoot() : input;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.sashForm = new SashForm(parent, 512);
        FillLayout layout = new FillLayout();
        this.sashForm.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)this.sashForm);
        Composite composite = new Composite((Composite)this.sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.treeViewer = this.createTreeViewer(composite);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        this.activateCopy((Control)tree);
        IUColumnConfig[] columns = this.getColumnConfig();
        int i = 0;
        while (i < columns.length) {
            TreeColumn tc = new TreeColumn(tree, 16384, i);
            tc.setResizable(true);
            tc.setText(columns[i].getColumnTitle());
            tc.setWidth(columns[i].getWidthInPixels((Control)tree));
            ++i;
        }
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(this.getColumnConfig());
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.contentProvider = new ProvElementContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new IUDetailsLabelProvider(null, this.getColumnConfig(), this.getShell());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.createSizingInfo(composite);
        this.iuDetailsGroup = new IUDetailsGroup((Composite)this.sashForm, (ISelectionProvider)this.treeViewer, this.convertWidthInCharsToPixels(80), true);
        this.setControl((Control)this.sashForm);
        this.sashForm.setWeights(this.getSashWeights());
        Dialog.applyDialogFont((Control)this.sashForm);
        final Runnable runnable = new Runnable(){

            public void run() {
                ResolutionResultsWizardPage.this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ResolutionResultsWizardPage.this.setDetailText((this).ResolutionResultsWizardPage.this.resolvedOperation);
                    }
                });
                ResolutionResultsWizardPage.this.updateStatus(ResolutionResultsWizardPage.this.input, ResolutionResultsWizardPage.this.resolvedOperation);
                ResolutionResultsWizardPage.this.setDrilldownElements(ResolutionResultsWizardPage.this.input, ResolutionResultsWizardPage.this.resolvedOperation);
                ResolutionResultsWizardPage.this.treeViewer.setInput((Object)ResolutionResultsWizardPage.this.input);
                if (ResolutionResultsWizardPage.this.treeViewer.getTree().getTopItem() != null) {
                    ResolutionResultsWizardPage.this.treeViewer.getTree().select(ResolutionResultsWizardPage.this.treeViewer.getTree().getTopItem());
                }
            }
        };
        if (this.resolvedOperation != null && !this.resolvedOperation.hasResolved()) {
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        ResolutionResultsWizardPage.this.resolvedOperation.resolveModal(monitor);
                        ResolutionResultsWizardPage.this.display.asyncExec(runnable);
                    }
                });
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e));
            }
        } else {
            runnable.run();
        }
    }

    protected void createSizingInfo(Composite parent) {
    }

    public boolean performFinish() {
        if (this.resolvedOperation.getResolutionResult().getSeverity() != 4) {
            this.getProvisioningUI().schedule(this.resolvedOperation.getProvisioningJob(null), 3);
            return true;
        }
        return false;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public IProvisioningPlan getCurrentPlan() {
        if (this.resolvedOperation != null) {
            return this.resolvedOperation.getProvisioningPlan();
        }
        return null;
    }

    @Override
    protected Object[] getSelectedElements() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toArray();
    }

    @Override
    protected IInstallableUnit getSelectedIU() {
        List<IInstallableUnit> units = ElementUtils.elementsToIUs(this.getSelectedElements());
        if (units.size() == 0) {
            return null;
        }
        return units.get(0);
    }

    @Override
    protected boolean shouldCompleteOnCancel() {
        return false;
    }

    protected Collection<IInstallableUnit> getIUs() {
        return ElementUtils.elementsToIUs(this.input.getChildren(this.input));
    }

    void setDrilldownElements(IUElementListRoot root, ProfileChangeOperation operation) {
        if (operation == null || operation.getProvisioningPlan() == null) {
            return;
        }
        Object[] elements = root.getChildren(root);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof QueriedElement) {
                ((QueriedElement)elements[i]).setQueryable(this.getQueryable(operation.getProvisioningPlan()));
            }
            ++i;
        }
    }

    protected abstract String getOperationLabel();

    protected int getRestartPolicy() {
        return 2;
    }

    protected String getOperationTaskName() {
        return null;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 67586);
    }

    protected abstract IQueryable<IInstallableUnit> getQueryable(IProvisioningPlan var1);

    @Override
    protected String getClipboardText(Control control) {
        return CopyUtils.getIndentedClipboardText(this.getSelectedElements(), this.labelProvider);
    }

    @Override
    protected IUDetailsGroup getDetailsGroup() {
        return this.iuDetailsGroup;
    }

    @Override
    protected boolean isCreated() {
        return this.treeViewer != null;
    }

    @Override
    protected void updateCaches(IUElementListRoot newRoot, ProfileChangeOperation op) {
        this.resolvedOperation = op;
        if (newRoot != null) {
            this.setDrilldownElements(newRoot, this.resolvedOperation);
            if (this.treeViewer != null) {
                if (this.input != newRoot) {
                    this.treeViewer.setInput((Object)newRoot);
                } else {
                    this.treeViewer.refresh();
                }
            }
            this.input = newRoot;
        }
    }

    @Override
    protected String getDialogSettingsName() {
        return String.valueOf(this.getWizard().getClass().getName()) + "." + DIALOG_SETTINGS_SECTION;
    }

    @Override
    protected int getColumnWidth(int index) {
        return this.treeViewer.getTree().getColumn(index).getWidth();
    }

    @Override
    protected SashForm getSashForm() {
        return this.sashForm;
    }
}

