/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.internal.model.JSDebugElement;
import com.aptana.js.debug.core.internal.model.JSDebugTarget;
import com.aptana.js.debug.core.model.IJSVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;

public class JSDebugVariable
extends JSDebugElement
implements IJSVariable {
    protected static final int FLAGS_MODIFIABLE = 1;
    protected static final int FLAGS_LOCAL = 2;
    protected static final int FLAGS_ARGUMENT = 4;
    protected static final int FLAGS_EXCEPTION = 8;
    protected static final int FLAGS_CONST = 16;
    protected static final int FLAGS_TOPLEVEL = 128;
    private final String threadId;
    private final String qualifier;
    private final String name;
    private IValue value;
    int flags;

    public JSDebugVariable(IDebugTarget target, String threadId, String qualifier, String name, IValue value) {
        this(target, threadId, qualifier, name, value, 0);
    }

    public JSDebugVariable(IDebugTarget target, String threadId, String qualifier, String name, int flags) {
        this(target, threadId, qualifier, name, null, flags);
    }

    public JSDebugVariable(IDebugTarget target, String threadId, String qualifier, String name, IValue value, int flags) {
        super(target);
        this.threadId = threadId;
        this.qualifier = qualifier;
        this.name = name;
        this.value = value;
        this.flags = flags;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        Object result = ((JSDebugTarget)this.getDebugTarget()).evaluateExpression(expression, (IDebugElement)this);
        if (result instanceof IValue && (result = ((JSDebugTarget)this.getDebugTarget()).setValue(this, (IValue)result)) instanceof IValue) {
            this.value = (IValue)result;
            this.fireChangeEvent(512);
            return;
        }
        if (result instanceof String[]) {
            this.throwDebugException(((String[])result)[0]);
        } else {
            this.throwDebugException("");
        }
    }

    public void setValue(IValue value) throws DebugException {
        this.throwNotImplemented();
    }

    public boolean supportsValueModification() {
        return (this.flags & 1) != 0;
    }

    public boolean verifyValue(String expression) throws DebugException {
        Object result = ((JSDebugTarget)this.getDebugTarget()).evaluateExpression(expression, (IDebugElement)this);
        if (result instanceof IValue) {
            return true;
        }
        if (result == null) {
            this.throwDebugException("unknown behaviour");
        }
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isLocal() throws DebugException {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isException() throws DebugException {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isArgument() throws DebugException {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isConst() throws DebugException {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isTopLevel() throws DebugException {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public String getFullName() {
        String fullname = this.getQualifier();
        int index = fullname.indexOf(46);
        if (index >= 0) {
            fullname = fullname.substring(index + 1);
        }
        return fullname;
    }

    String getQualifier() {
        return this.qualifier;
    }

    String getThreadId() {
        return this.threadId;
    }
}

