/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core;

import com.aptana.core.IBrowserProvider;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.browsers.BrowserUtil;
import com.pandora.core.utils.RegistryUtils;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class JSLaunchConfigurationHelper {
    private static IBrowserProvider browserProvider;

    private JSLaunchConfigurationHelper() {
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy configuration, String nature) {
        JSLaunchConfigurationHelper.setBrowserDefaults(configuration, nature);
        JSLaunchConfigurationHelper.setServerDefaults(configuration);
        JSLaunchConfigurationHelper.setHttpDefaults(configuration);
        JSLaunchConfigurationHelper.setDebugDefaults(configuration);
        JSLaunchConfigurationHelper.setAdvancedDefaults(configuration);
    }

    public static void setBrowserDefaults(ILaunchConfigurationWorkingCopy configuration, String nature) {
        IBrowserUtil.BrowserInfo info;
        if (nature == null) {
            try {
                nature = configuration.getAttribute("browserNature", null);
            }
            catch (CoreException coreException) {}
        }
        if ((info = JSLaunchConfigurationHelper.getBrowserDefaultPath(nature)) != null) {
            configuration.setAttribute("browserID", info.getId());
        }
        if (nature != null) {
            configuration.setAttribute("browserNature", nature);
        }
    }

    public static void setServerDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("startActionType", 1);
        configuration.setAttribute("serverType", 1);
        configuration.setAttribute("startPagePath", "");
        configuration.setAttribute("startPageUrl", "");
        configuration.setAttribute("externalBaseUrl", "");
        configuration.setAttribute("appendProjectName", true);
    }

    public static void setDebugDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IScopeContext[] scopes = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
        configuration.setAttribute("overrideDebugPreferences", false);
        configuration.setAttribute("suspendOnFirstLine", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_first_line", false, scopes));
        configuration.setAttribute("suspendOnExceptions", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_exceptions", false, scopes));
        configuration.setAttribute("suspendOnErrors", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_errors", false, scopes));
        configuration.setAttribute("suspendOnDebuggerKeywords", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_debugger_keyword", false, scopes));
    }

    public static void setAdvancedDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("advancedRunEnabled", false);
    }

    public static void setHttpDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("httpGetData", "");
        configuration.setAttribute("httpPostData", "");
        configuration.setAttribute("httpPostContentType", "");
    }

    public static boolean isBrowserDebugCompatible(String browser) {
        if (browser != null && BrowserUtil.isBrowserDebugCompatible(browser)) {
            return new File(browser).exists();
        }
        return false;
    }

    private static Object getContributedAdapter(Object object, Class<?> clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter(object, clazz.getName()) && (adapter = manager.getAdapter(object, clazz.getName())) == null) {
            adapter = manager.loadAdapter(object, clazz.getName());
        }
        return adapter;
    }

    public static void initializeLaunchAttributes(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        if (configuration.getAttribute("overrideDebugPreferences", false)) {
            launch.setAttribute("suspendOnFirstLine", Boolean.toString(configuration.getAttribute("suspendOnFirstLine", false)));
            launch.setAttribute("suspendOnExceptions", Boolean.toString(configuration.getAttribute("suspendOnExceptions", false)));
            launch.setAttribute("suspendOnErrors", Boolean.toString(configuration.getAttribute("suspendOnErrors", false)));
            launch.setAttribute("suspendOnDebuggerKeywords", Boolean.toString(configuration.getAttribute("suspendOnDebuggerKeywords", false)));
        } else {
            IScopeContext[] scopes = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
            launch.setAttribute("suspendOnFirstLine", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_first_line", false, scopes)));
            launch.setAttribute("suspendOnExceptions", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_exceptions", false, scopes)));
            launch.setAttribute("suspendOnErrors", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_errors", false, scopes)));
            launch.setAttribute("suspendOnDebuggerKeywords", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_debugger_keyword", false, scopes)));
        }
    }

    public static IBrowserUtil.BrowserInfo getBrowserDefaultPath(String nature) {
        JSLaunchConfigurationHelper.initBrowserProvider();
        if (browserProvider != null) {
            return browserProvider.getDefaultBrowserInfo(nature);
        }
        return null;
    }

    public static IBrowserUtil.BrowserInfo getBrowserByID(String id) {
        JSLaunchConfigurationHelper.initBrowserProvider();
        if (browserProvider != null) {
            return browserProvider.findBrowserInfoByID(id);
        }
        return null;
    }

    private static void initBrowserProvider() {
        if (browserProvider == null) {
            try {
                List bps = RegistryUtils.getEp(IBrowserProvider.class, (String)"com.aptana.ui.browserProvider", (String)"browserProvider", (String)"class");
                if (bps != null && !bps.isEmpty()) {
                    browserProvider = (IBrowserProvider)bps.get(0);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

