/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.startup;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.pandora.core.stats.Stats;
import com.pandora.ui.action.ImportFolderAction;
import com.pandora.ui.utils.IDEUtils;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenFileCommandLineHandler
implements IStartup {
    public void earlyStartup() {
        try {
            String[] args = Platform.getCommandLineArgs();
            List files = FileUtil.gatherFilesFromCommandLineArguments((String[])args);
            if (files != null && !files.isEmpty()) {
                for (File file : files) {
                    if (!file.exists()) continue;
                    if (file.isFile()) {
                        this.openFile(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    this.openFolder(file);
                }
            }
        }
        catch (Exception e) {
            Stats.addExceptionInfo((Throwable)e);
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void openFile(final File file) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IDEUtils.openLocalFile((File)file, (IWorkbenchWindow)window);
            }
        });
    }

    protected void openFolder(final File folder) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ImportFolderAction action = new ImportFolderAction(folder);
                action.run();
            }
        });
    }
}

