/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.page;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.TemplateAbility;
import com.aptana.core.util.URIUtil;
import com.aptana.core.util.WorkspaceUtil;
import com.aptana.projects.ProjectsPlugin;
import com.pandora.core.auth.UserAuth;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.page.Messages;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class NewWebProjectComposite
extends Composite {
    protected static final String SAVED_LOCATION_ATTR = "OUTSIDE_LOCATION";
    protected Composite contentComposite;
    protected Group projectSettingGroup;
    protected Label appNameLabel;
    protected Text newAppNameTxt = null;
    protected Text locationTxt = null;
    protected Button fileBotton = null;
    private WizardPage wizardPage = null;
    protected IProjectTemplate projectTemplate = null;

    public Text getLocationTxt() {
        return this.locationTxt;
    }

    public NewWebProjectComposite(WizardPage wizardPage, Composite parent, int style, List<IProjectTemplate> templates) {
        super(parent, style);
        this.wizardPage = wizardPage;
        this.setLayout((Layout)new FillLayout(512));
        this.addNewAppTab(templates);
    }

    protected void addNewAppTab(List<IProjectTemplate> templates) {
        this.contentComposite = new Composite((Composite)this, 0);
        GridLayout newAppCompositeGridLayout = GridLayoutFactory.fillDefaults().numColumns(1).create();
        this.contentComposite.setLayout((Layout)newAppCompositeGridLayout);
        this.projectSettingGroup = new Group(this.contentComposite, 0);
        this.projectSettingGroup.setText("\u9879\u76ee\u4fe1\u606f");
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(3).create();
        this.projectSettingGroup.setLayout((Layout)gridLayout);
        this.projectSettingGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.appNameLabel = new Label((Composite)this.projectSettingGroup, 0);
        this.appNameLabel.setLayoutData((Object)new GridData());
        this.appNameLabel.setText("\u9879\u76ee\u540d\u79f0\uff1a");
        this.newAppNameTxt = new Text((Composite)this.projectSettingGroup, 2048);
        this.newAppNameTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.newAppNameTxt.setFocus();
        new Label((Composite)this.projectSettingGroup, 0).setLayoutData((Object)new GridData());
        Label appNameLabelpos = new Label((Composite)this.projectSettingGroup, 0);
        appNameLabelpos.setLayoutData((Object)new GridData());
        appNameLabelpos.setText("\u4f4d\u7f6e\uff1a");
        this.locationTxt = new Text((Composite)this.projectSettingGroup, 2048);
        this.locationTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        String codedir = "";
        codedir = !Platform.inDevelopmentMode() ? WorkspaceUtil.getCodeDir((String)UserAuth.getUsername()) : WorkspaceUtil.getCodeLocation();
        this.locationTxt.setText(codedir);
        this.fileBotton = new Button((Composite)this.projectSettingGroup, 8);
        this.fileBotton.setText("\u6d4f\u89c8...");
        this.fileBotton.setLayoutData((Object)new GridData());
        this.fileBotton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewWebProjectComposite.this.handleLocationBrowseButtonPressed();
            }
        });
        Group selectTemplatesGroup = new Group(this.contentComposite, 0);
        selectTemplatesGroup.setText(Messages.NewHMobileProjectComposite_16);
        gridLayout = GridLayoutFactory.fillDefaults().margins(8, 8).create();
        selectTemplatesGroup.setLayout((Layout)gridLayout);
        selectTemplatesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.needUserTemplate()) {
            Link link = new Link((Composite)selectTemplatesGroup, 0);
            link.setText("<a>\u81ea\u5b9a\u4e49\u6a21\u677f</a>");
            link.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (NewWebProjectComposite.this.getProjectTemplate() != null) {
                        try {
                            File path = ProjectsPlugin.getDefault().getTemplatesManager().createUserTemplatePath(NewWebProjectComposite.this.getProjectTemplate().getType());
                            URIUtil.open((URI)path.toURI());
                        }
                        catch (Exception ex) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)ex);
                        }
                    }
                }
            });
        }
        Composite templatesComposite = new Composite((Composite)selectTemplatesGroup, 0);
        templatesComposite.setLayout((Layout)new FillLayout());
        templatesComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.showProjectTemplates(templatesComposite, templates);
    }

    protected boolean needUserTemplate() {
        return true;
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory = null;
        String dirName = this.locationTxt.getText();
        if (!dirName.equals("")) {
            IFileInfo info = IDEResourceInfoUtils.getFileInfo((String)dirName);
            if (info == null || !info.exists()) {
                dirName = "";
            }
        } else {
            String value = this.getDialogSettings().get(SAVED_LOCATION_ATTR);
            if (value != null) {
                dirName = value;
            }
        }
        DirectoryDialog dialog = new DirectoryDialog(this.wizardPage.getShell(), 0x10000000);
        dialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateLocationField(selectedDirectory);
            this.getDialogSettings().put(SAVED_LOCATION_ATTR, selectedDirectory);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings ideDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings result = ideDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (result == null) {
            result = ideDialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return result;
    }

    protected void updateLocationField(String selectedPath) {
        this.locationTxt.setText(TextProcessor.process((String)selectedPath));
    }

    protected void showProjectTemplates(Composite templatesComposite, List<IProjectTemplate> templates) {
        if ((templates = this.getDefaultTemplate(templates)) == null || templates.size() < 1) {
            return;
        }
        this.projectTemplate = templates.get(0);
        TableViewer tagsListViewer = new TableViewer(templatesComposite, 66340);
        tagsListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tagsListViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        tagsListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table table = tagsListViewer.getTable();
        this.newAppNameTxt.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000002: {
                        if (table.getSelectionIndex() < table.getItemCount() - 1) {
                            int index = table.getSelectionIndex() + 1;
                            table.getItem(table.getSelectionIndex()).setChecked(false);
                            table.select(index);
                            table.getItem(index).setChecked(true);
                            NewWebProjectComposite.this.setProjectTemplate((IProjectTemplate)table.getItem(index).getData());
                        }
                        e.doit = false;
                        return;
                    }
                    case 0x1000001: {
                        if (table.getSelectionIndex() > 0) {
                            int index = table.getSelectionIndex() - 1;
                            table.getItem(table.getSelectionIndex()).setChecked(false);
                            table.select(index);
                            table.getItem(index).setChecked(true);
                            NewWebProjectComposite.this.setProjectTemplate((IProjectTemplate)table.getItem(index).getData());
                        }
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        tagsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TableItem[] items = table.getItems();
                    int i = 0;
                    while (i < items.length) {
                        TableItem item = items[i];
                        if (item.getData() == ((StructuredSelection)event.getSelection()).getFirstElement()) {
                            item.setChecked(true);
                            NewWebProjectComposite.this.setProjectTemplate((IProjectTemplate)item.getData());
                        } else {
                            item.setChecked(false);
                        }
                        ++i;
                    }
                }
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32 && event.item instanceof TableItem) {
                    TableItem itemChanged = (TableItem)event.item;
                    TableItem selectItem = null;
                    if (table.getSelectionIndex() >= 0) {
                        selectItem = table.getItem(table.getSelectionIndex());
                    }
                    if (!itemChanged.getChecked() || selectItem == null) {
                        TableItem[] items = table.getItems();
                        int i = 0;
                        while (i < items.length) {
                            TableItem item = items[i];
                            if (item == itemChanged) {
                                item.setChecked(true);
                                table.select(new int[]{i});
                                NewWebProjectComposite.this.setProjectTemplate((IProjectTemplate)item.getData());
                            } else {
                                item.setChecked(false);
                            }
                            ++i;
                        }
                    }
                }
            }
        });
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableColumn tblclmn1 = new TableColumn(table, 0);
        tblclmn1.setWidth(120);
        TableColumn tblclmn2 = new TableColumn(table, 0);
        tblclmn2.setWidth(360);
        TableColumn tblclmn3 = new TableColumn(table, 0);
        tblclmn3.setWidth(60);
        tagsListViewer.setInput(templates);
        tblclmn3.pack();
        if (table.getItemCount() > 0) {
            table.select(0);
            table.getItem(0).setChecked(true);
        }
    }

    protected List<IProjectTemplate> getDefaultTemplate(List<IProjectTemplate> templates) {
        if (templates.isEmpty()) {
            return null;
        }
        if (templates.size() == 1) {
            return templates;
        }
        IProjectTemplate[] tplArr = templates.toArray(new IProjectTemplate[templates.size()]);
        Arrays.sort(tplArr, new Comparator<IProjectTemplate>(){

            @Override
            public int compare(IProjectTemplate t1, IProjectTemplate t2) {
                return t1.getPriority() - t2.getPriority();
            }
        });
        templates = Arrays.asList(tplArr);
        return templates;
    }

    public Text getProjectNameTxt() {
        return this.newAppNameTxt;
    }

    public void setProjectTemplate(IProjectTemplate projectTemplate) {
        this.projectTemplate = projectTemplate;
    }

    public IProjectTemplate getProjectTemplate() {
        return this.projectTemplate;
    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IProjectTemplate) {
                if (columnIndex == 0) {
                    return ((IProjectTemplate)element).getDisplayName();
                }
                if (columnIndex == 1) {
                    return ((IProjectTemplate)element).getDescription();
                }
                if (columnIndex == 2) {
                    TemplateAbility ability = ((IProjectTemplate)element).getAbility();
                    if (ability == TemplateAbility.TEMPLATE) {
                        return "\u6a21\u677f";
                    }
                    if (ability == TemplateAbility.EXAMPLE) {
                        return "\u793a\u4f8b";
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

