/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.page;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.URIUtil;
import com.pandora.projects.templates.FileTemplate;
import com.pandora.projects.templates.FileTemplatesManager;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.wizards.Messages;
import com.pandora.projects.ui.wizards.NewFileWizard;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewFileWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private NewFileWizard fileWizard = null;
    private String[] fileExtends = null;
    private FileTemplate fileTemplate = null;
    private boolean isFileNameChanged;
    private boolean isFileNameNeedSelect = true;

    public NewFileWizardPage(ISelection selection, NewFileWizard fileWizard) {
        super("wizardPage");
        this.setTitle(String.valueOf(Messages.NewFileWizardPage_Create) + " " + fileWizard.getFileType() + " " + Messages.NewFileWizardPage_FileWizard);
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotBlank((String)fileWizard.getFileExt())) {
            String[] stringArray = this.fileExtends = fileWizard.getFileExt().toLowerCase().split("\\,");
            int n = this.fileExtends.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtend = stringArray[n2];
                sb.append("*." + fileExtend + " ");
                ++n2;
            }
        }
        this.setDescription("\u672c\u5411\u5bfc\u521b\u5efa" + sb.toString() + "\u6269\u5c55\u540d\u7684\u6587\u4ef6");
        this.selection = selection;
        this.fileWizard = fileWizard;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("\u6587\u4ef6\u6240\u5728\u76ee\u5f55(&C):");
        this.containerText = new Text(container, 2052);
        this.containerText.setEditable(false);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("\u6d4f\u89c8(&B)...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("\u6587\u4ef6\u540d(&F):");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewFileWizardPage.this.dialogChanged();
            }
        });
        if (this.fileExtends != null && this.fileExtends.length > 0) {
            label = new Label(container, 0);
            label.setText("\u9009\u62e9\u6a21\u677f: ");
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            Link link = new Link(container, 0);
            gd = new GridData(1808);
            link.setText("<a>\u81ea\u5b9a\u4e49\u6a21\u677f</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        File path = FileTemplatesManager.getInstance().createUserTemplatePath(NewFileWizardPage.this.fileExtends[0]);
                        URIUtil.open((URI)path.toURI());
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)ex);
                    }
                }
            });
            Composite templatesComposite = new Composite(container, 0);
            gd = new GridData(1808);
            gd.horizontalSpan = 3;
            templatesComposite.setLayoutData((Object)gd);
            templatesComposite.setLayout((Layout)new FillLayout());
            List templates = FileTemplatesManager.getInstance().getAllFileTemplates(this.fileExtends[0]);
            this.showFileTemplates(templatesComposite, templates);
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void showFileTemplates(Composite templatesComposite, List<FileTemplate> templates) {
        TableViewer tagsListViewer = new TableViewer(templatesComposite, 68388);
        tagsListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tagsListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FileTemplate) {
                    return ((FileTemplate)element).getName();
                }
                return super.getText(element);
            }
        });
        tagsListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table table = tagsListViewer.getTable();
        this.fileText.addKeyListener((KeyListener)new KeyAdapter(){
            private String initName;
            {
                this.initName = NewFileWizardPage.this.fileText.getText();
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000002: {
                        if (table.getSelectionIndex() < table.getItemCount() - 1) {
                            int index = table.getSelectionIndex() + 1;
                            table.getItem(table.getSelectionIndex()).setChecked(false);
                            table.select(index);
                            table.getItem(index).setChecked(true);
                            NewFileWizardPage.this.setFileTemplate((FileTemplate)table.getItem(index).getData());
                            NewFileWizardPage.this.changeFileNameFromFileTemplate();
                        }
                        e.doit = false;
                        return;
                    }
                    case 0x1000001: {
                        if (table.getSelectionIndex() > 0) {
                            int index = table.getSelectionIndex() - 1;
                            table.getItem(table.getSelectionIndex()).setChecked(false);
                            table.select(index);
                            table.getItem(index).setChecked(true);
                            NewFileWizardPage.this.setFileTemplate((FileTemplate)table.getItem(index).getData());
                            NewFileWizardPage.this.changeFileNameFromFileTemplate();
                        }
                        e.doit = false;
                        return;
                    }
                }
                if (this.initName != null && !this.initName.equals(NewFileWizardPage.this.fileText.getText())) {
                    NewFileWizardPage.this.isFileNameChanged = true;
                }
                NewFileWizardPage.this.isFileNameNeedSelect = false;
            }
        });
        this.fileText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                NewFileWizardPage.this.isFileNameNeedSelect = false;
            }
        });
        tagsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TableItem[] items = table.getItems();
                    int i = 0;
                    while (i < items.length) {
                        TableItem item = items[i];
                        if (item.getData() == ((StructuredSelection)event.getSelection()).getFirstElement()) {
                            item.setChecked(true);
                            NewFileWizardPage.this.setFileTemplate((FileTemplate)item.getData());
                            NewFileWizardPage.this.changeFileNameFromFileTemplate();
                        } else {
                            item.setChecked(false);
                        }
                        ++i;
                    }
                }
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32 && event.item instanceof TableItem) {
                    TableItem itemChanged = (TableItem)event.item;
                    TableItem selectItem = null;
                    if (table.getSelectionIndex() >= 0) {
                        selectItem = table.getItem(table.getSelectionIndex());
                    }
                    if (!itemChanged.getChecked() || selectItem == null) {
                        TableItem[] items = table.getItems();
                        int i = 0;
                        while (i < items.length) {
                            TableItem item = items[i];
                            if (item == itemChanged) {
                                item.setChecked(true);
                                table.select(new int[]{i});
                                NewFileWizardPage.this.setFileTemplate((FileTemplate)item.getData());
                                NewFileWizardPage.this.changeFileNameFromFileTemplate();
                            } else {
                                item.setChecked(false);
                            }
                            ++i;
                        }
                    }
                }
            }
        });
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableColumn tblclmn = new TableColumn(table, 0);
        tblclmn.setResizable(true);
        tblclmn.setWidth(460);
        tagsListViewer.setInput(templates);
        table.pack();
        if (table.getItemCount() > 0) {
            table.select(0);
            table.getItem(0).setChecked(true);
            this.setFileTemplate((FileTemplate)table.getItem(0).getData());
            this.changeFileNameFromFileTemplate();
        }
    }

    private void changeFileNameFromFileTemplate() {
        String name;
        if (!this.isFileNameChanged && this.fileTemplate != null) {
            name = this.fileTemplate.getName();
            if (this.fileTemplate.isDefault()) {
                name = "new_file";
            }
            this.fileText.setText(String.valueOf(name) + (this.fileExtends != null && this.fileExtends.length != 0 ? "." + this.fileExtends[0] : ""));
        }
        if (this.isFileNameNeedSelect) {
            this.fileText.setFocus();
            name = this.fileText.getText();
            if (name.lastIndexOf(46) > 0) {
                this.fileText.setSelection(0, name.lastIndexOf(46));
            } else if (name.indexOf(46) < 0) {
                this.fileText.selectAll();
            }
        }
    }

    private void initialize() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection resourceSelection = null;
        resourceSelection = activePage.getActivePart() != null && "org.eclipse.ui.navigator.ProjectExplorer".equals(activePage.getActivePart().getSite().getId()) ? this.selection : activePage.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        if (resourceSelection != null && !resourceSelection.isEmpty() && resourceSelection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)resourceSelection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        if (StringUtil.isBlank((String)this.fileText.getText())) {
            if (this.fileExtends != null && this.fileExtends.length > 0) {
                this.fileText.setText("new_file." + this.fileExtends[0]);
            } else {
                this.fileText.setText("new_file");
            }
        }
        this.fileText.setFocus();
        this.fileText.setSelection(0, "new_file".length());
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.updateStatus("\u5fc5\u987b\u6307\u5b9a\u6587\u4ef6\u540d");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("\u6587\u4ef6\u540d\u4e0d\u6b63\u786e");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1) {
            List<String> extendsList;
            String ext = fileName.substring(dotLoc + 1);
            if (this.fileExtends != null && this.fileExtends.length > 0 && !(extendsList = Arrays.asList(this.fileExtends)).contains(ext.toLowerCase())) {
                this.updateStatus("\u6587\u4ef6\u6269\u5c55\u540d\u5fc5\u987b\u662f \"" + StringUtil.join((String)",", (String[])this.fileExtends) + "\"");
                return;
            }
        } else if (this.fileExtends != null && this.fileExtends.length > 0) {
            this.updateStatus("\u6587\u4ef6\u6269\u5c55\u540d\u5fc5\u987b\u662f \"" + StringUtil.join((String)",", (String[])this.fileExtends) + "\"");
            return;
        }
        if (StringUtil.isNotEmpty((String)this.getContainerName())) {
            IFolder folder;
            IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
            if (container == null || (container.getType() & 6) == 0) {
                this.updateStatus("\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728");
                return;
            }
            if (!container.isAccessible()) {
                this.updateStatus("\u9879\u76ee\u6ca1\u6709\u8bfb\u5199\u6743\u9650");
                return;
            }
            if (container instanceof IProject) {
                IProject project = (IProject)container;
                if (project.getFile(fileName).exists()) {
                    this.updateStatus(Messages.NewFileWizardPage_FileAlreadyExsit);
                    return;
                }
            } else if (container instanceof IFolder && (folder = (IFolder)container).getFile(fileName).exists()) {
                this.updateStatus(Messages.NewFileWizardPage_FileAlreadyExsit);
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    private void setFileTemplate(FileTemplate projectTemplate) {
        this.fileTemplate = projectTemplate;
    }

    public FileTemplate getFileTemplate() {
        return this.fileTemplate;
    }
}

