/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.content;

import com.pandora.core.jslib.JavaScriptElement;
import com.pandora.core.jslib.JavaScriptFileElement;
import com.pandora.core.jslib.JavaScriptLibraryElement;
import com.pandora.projects.ui.action.OpenJSLibraryFileAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ProjectExplorerContentProviderWraper
implements ICommonContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer != null && viewer.getControl() != null) {
            viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    Tree tree;
                    if (e.getSource() instanceof Tree && (tree = (Tree)e.getSource()).getSelection().length > 0) {
                        TreeItem treeItem = tree.getSelection()[0];
                        Object obj = treeItem.getData();
                        ProjectExplorerContentProviderWraper.this.handleOpenFileAction(obj);
                    }
                    super.mouseDoubleClick(e);
                }
            });
            viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    Tree tree;
                    super.keyPressed(e);
                    if (e.keyCode != 0x1000050 && e.keyCode != 13) {
                        return;
                    }
                    if (e.getSource() instanceof Tree && (tree = (Tree)e.getSource()).getSelection().length > 0) {
                        TreeItem treeItem = tree.getSelection()[0];
                        Object obj = treeItem.getData();
                        ProjectExplorerContentProviderWraper.this.handleOpenFileAction(obj);
                    }
                }
            });
        }
    }

    protected void handleOpenFileAction(Object data) {
        if (data instanceof IFile) {
            IFile file = (IFile)data;
            if (!"manifest.json".equals(file.getName())) {
                return;
            }
            IProject project = file.getProject();
            try {
                if (!project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"com.aptana.editor.json");
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void handleDoubleClickAction(JavaScriptFileElement obj) {
        if (obj == null) {
            return;
        }
        OpenJSLibraryFileAction openAction = new OpenJSLibraryFileAction(obj);
        openAction.run();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        block11: {
            if (parentElement != null) break block11;
            return null;
        }
        try {
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                if (project.isOpen()) {
                    return project.members();
                }
            } else {
                if (parentElement instanceof IFolder) {
                    IFolder folder = (IFolder)parentElement;
                    if ("".equals(folder.getName()) && folder.getProject() == folder.getParent()) {
                        ArrayList<Object> results = new ArrayList<Object>();
                        IProject project = folder.getProject();
                        IProjectNature hmobileNature = project.getNature("com.pandora.projects.ui.MKeyNature");
                        if (hmobileNature != null) {
                            this.addJavaScriptLibrary(results, project);
                        }
                        results.addAll(Arrays.asList(folder.members()));
                        return results.toArray();
                    }
                    return folder.members();
                }
                if (parentElement instanceof JavaScriptLibraryElement) {
                    JavaScriptLibraryElement libraryElement = (JavaScriptLibraryElement)parentElement;
                    return libraryElement.getElements().toArray();
                }
                IWorkbenchAdapter adapter = this.getAdapter(parentElement);
                if (adapter != null) {
                    return adapter.getChildren(parentElement);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected IWorkbenchAdapter getAdapter(Object element) {
        return (IWorkbenchAdapter)Util.getAdapter((Object)element, IWorkbenchAdapter.class);
    }

    @Deprecated
    protected void addJavaScriptLibrary(List<Object> results, IProject project) {
    }

    protected void addJSLibrarys(Node rootLib, JavaScriptLibraryElement rootLibElement) {
        List nodes = rootLib.selectNodes("jslib");
        for (Node node : nodes) {
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            JavaScriptLibraryElement scriptLibElement = new JavaScriptLibraryElement((JavaScriptElement)rootLibElement);
            scriptLibElement.setName(el.attributeValue("name"));
            scriptLibElement.setBuildIn(Boolean.valueOf(el.attributeValue("built_in")).booleanValue());
            rootLibElement.addJavaScriptElement((JavaScriptElement)scriptLibElement);
            this.addRefLibraryFile(el, scriptLibElement);
        }
    }

    protected void addRefLibraryFile(Element el, JavaScriptLibraryElement scriptLibElement) {
        List refNodes = el.selectNodes("ref");
        for (Node refNode : refNodes) {
            if (!(refNode instanceof Element)) continue;
            Element refEl = (Element)refNode;
            String elName = refEl.attributeValue("name");
            String elLocation = refEl.attributeValue("location");
            JavaScriptFileElement scriptElement = new JavaScriptFileElement((JavaScriptElement)scriptLibElement);
            scriptElement.setName(elName);
            scriptElement.setLocation(elLocation);
            scriptLibElement.addJavaScriptElement((JavaScriptElement)scriptElement);
        }
    }

    public Object getParent(Object element) {
        if (element == null) {
            return null;
        }
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        Object[] children;
        if (element instanceof JavaScriptLibraryElement) {
            JavaScriptLibraryElement libraryElement = (JavaScriptLibraryElement)element;
            if (!libraryElement.getElements().isEmpty()) return true;
            return false;
        }
        if (element instanceof IFile) {
            return false;
        }
        if (element instanceof JavaScriptFileElement) {
            return false;
        }
        if (element instanceof IFolder) {
            try {
                IFolder folder = (IFolder)element;
                if (folder.members().length == 0) {
                    return false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (element instanceof IProject) {
            try {
                IProject project = (IProject)element;
                if (!project.isOpen()) {
                    return false;
                }
                if (project.members().length <= 1) {
                    return false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if ((children = this.getChildren(element)) == null) {
            return false;
        }
        if (children.length <= 0) return false;
        return true;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

