/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.ui.builder;

import com.aptana.core.logging.IdeLog;
import com.pandora.projects.core.IResourceChangeListener;
import com.pandora.projects.ui.Activator;
import com.pandora.projects.ui.builder.Messages;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class HMobileBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.pandora.projects.ui.MKeyBuilder";
    private static final String MARKER_TYPE = "com.pandora.projects.ui.HMobileProblem";
    private static Set<IResourceChangeListener> listeners = new HashSet<IResourceChangeListener>();

    protected IProject[] build(final int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IdeLog.logTrace((Plugin)Activator.getDefault(), (String)Messages.HMobileBuilder_StartBuildInfo);
        final IResourceDelta delta = this.getDelta(this.getProject());
        Job job = new Job("\u6b63\u5728\u540c\u6b65\u8d44\u6e90..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (kind == 6) {
                        HMobileBuilder.this.fullBuild(monitor);
                    } else if (delta == null) {
                        HMobileBuilder.this.fullBuild(monitor);
                    } else {
                        HMobileBuilder.this.incrementalBuild(delta, monitor);
                    }
                }
                catch (Throwable e) {
                    IdeLog.logTrace((Plugin)Activator.getDefault(), (String)"\u540c\u6b65\u5931\u8d25", (Throwable)e, null);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        return null;
    }

    protected void checkProject(IResource resource) {
        if (!resource.exists()) {
            return;
        }
        if (!this.checkProjectIntegrity(resource.getProject())) {
            return;
        }
    }

    protected boolean checkProjectIntegrity(IProject project) {
        if (!project.exists()) {
            return false;
        }
        try {
            if (!project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                return true;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        try {
            this.deleteMarkers((IResource)project);
            IFile ifile = project.getFile("manifest.json");
            if (!ifile.exists()) {
                this.createProjectMarker(project, String.valueOf(Messages.HMobileBuilder_MainConfigWarnInfo) + "manifest.json" + Messages.HMobileBuilder_MainConfigFile);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void createProjectMarker(IProject project, String message) {
        try {
            IMarker marker = project.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 2);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    protected void deleteMarkers(IResource resource) {
        try {
            resource.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.fireHMobileProjectChanged((IResource)this.getProject(), true, false);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        if (delta != null) {
            delta.accept((IResourceDeltaVisitor)new HMobileResourceIndexDeltaVisitor());
        }
    }

    public void fireHMobileProjectChanged(IResource resource, boolean isFullBuild, boolean isDelete) {
        for (IResourceChangeListener listener : listeners) {
            listener.resourceChanged(resource, isFullBuild, isDelete);
        }
    }

    public static void addResourceChangeListener(IResourceChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeResourceChangeListener(IResourceChangeListener listener) {
        listeners.remove(listener);
    }

    class HMobileResourceIndexDeltaVisitor
    implements IResourceDeltaVisitor {
        HMobileResourceIndexDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (delta != null && delta.getKind() == 2) {
                HMobileBuilder.this.fireHMobileProjectChanged(resource, false, true);
            } else {
                HMobileBuilder.this.fireHMobileProjectChanged(resource, false, false);
            }
            return true;
        }
    }
}

