/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.exception.NodeNotFoundException;
import com.pandora.core.utils.Messages;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLUtils {
    public static String getSingleText(Document doc, String xPath) throws NodeNotFoundException {
        Element root = doc.getRootElement();
        Node node = root.selectSingleNode(xPath);
        if (node == null) {
            throw new NodeNotFoundException(String.valueOf(xPath) + Messages.XMLUtils_NotFound);
        }
        return node.getText();
    }

    public static String getAttrValue(Document doc, String xPath, String attrName) throws NodeNotFoundException {
        Element root = doc.getRootElement();
        Node node = root.selectSingleNode(xPath);
        if (node == null) {
            throw new NodeNotFoundException(String.valueOf(xPath) + Messages.XMLUtils_NotFound);
        }
        if (node instanceof Element) {
            Element el = (Element)node;
            return el.attributeValue(attrName);
        }
        return null;
    }

    public static String getSingleText(File xmlFile, String xPath) throws IOException, DocumentException, NodeNotFoundException {
        String xmlContent = FileUtils.readFileToString((File)xmlFile);
        Document doc = DocumentHelper.parseText((String)xmlContent);
        return XMLUtils.getSingleText(doc, xPath);
    }

    public static String getAttrValue(File xmlFile, String xPath, String attrName) throws NodeNotFoundException, IOException, DocumentException {
        String xmlContent = FileUtils.readFileToString((File)xmlFile);
        Document doc = DocumentHelper.parseText((String)xmlContent);
        return XMLUtils.getAttrValue(doc, xPath, attrName);
    }
}

