/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class RegularUtils {
    public static boolean isMatch(String pattern, String str) {
        Pattern ptn = Pattern.compile(pattern);
        Matcher m = ptn.matcher(str);
        return m.find();
    }

    public static String[] matchs(String pattern, String str) {
        Pattern ptn = Pattern.compile(pattern);
        Matcher m = ptn.matcher(str);
        if (m.find()) {
            String[] result = new String[m.groupCount()];
            int i = 1;
            while (i <= m.groupCount()) {
                result[i - 1] = m.group(i);
                ++i;
            }
            return result;
        }
        return null;
    }

    public static IRegion[] matchs(String pattern, String str, int index) {
        if (StringUtil.isEmpty((String)pattern)) {
            return null;
        }
        ArrayList<Region> regions = new ArrayList<Region>();
        Pattern ptn = Pattern.compile(pattern);
        Matcher m = ptn.matcher(str);
        int offset = 0;
        while (m.find()) {
            Region region = new Region(offset + m.start(index), m.end(index) - m.start(index));
            regions.add(region);
            m = ptn.matcher(str.substring(offset += m.end()));
        }
        return regions.toArray(new IRegion[regions.size()]);
    }

    public static IRegion matchFirst(String pattern, String str, int index) {
        if (StringUtil.isEmpty((String)pattern)) {
            return null;
        }
        Pattern ptn = Pattern.compile(pattern);
        Matcher m = ptn.matcher(str);
        int offset = 0;
        if (m.find()) {
            Region region = new Region(offset + m.start(index), m.end(index) - m.start(index));
            return region;
        }
        return null;
    }

    public static String match(String pattern, String str, int group) {
        if (StringUtil.isEmpty((String)pattern) || StringUtil.isEmpty((String)str)) {
            return "";
        }
        Pattern ptn = Pattern.compile(pattern);
        Matcher m = ptn.matcher(str);
        if (m.find()) {
            return m.group(group);
        }
        return "";
    }

    public static String matchHumpName(String name) {
        String upperPattern = "[\\.]*([A-Z]+)[\\.]*";
        Pattern ptn = Pattern.compile(upperPattern);
        Matcher m = ptn.matcher(name);
        StringBuffer sb = new StringBuffer();
        int startOffset = 0;
        while (m.find()) {
            m.group();
            int offset = m.start();
            sb.append(name.substring(startOffset, offset).toLowerCase());
            if (sb.length() > 0) {
                sb.append("-");
            }
            startOffset = offset;
        }
        sb.append(name.substring(startOffset, name.length()).toLowerCase());
        return sb.toString();
    }

    public static void main(String[] args) {
        String cssProperty = "aWaKaP";
        String xxx = RegularUtils.matchHumpName(cssProperty);
        System.out.println(xxx);
    }
}

