/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.auth.RecyleListener;
import com.pandora.core.utils.ResourceUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class RecycleUtils {
    public static Set<RecyleListener> listeners = new HashSet<RecyleListener>();

    public static void addRecyleListener(RecyleListener listener) {
        listeners.add(listener);
    }

    public static boolean recycle(String path) {
        Iterator<RecyleListener> iterator = listeners.iterator();
        if (iterator.hasNext()) {
            RecyleListener listener = iterator.next();
            return listener.recyle(path);
        }
        return false;
    }

    public static void recycleResources(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray[n2];
            if (iResource != null) {
                if (iResource instanceof IFile) {
                    ResourceUtil.addToLocalHistory((IFile)((IFile)iResource));
                }
                IPath path = iResource.getLocation();
                RecycleUtils.recycle(path.toOSString());
            }
            ++n2;
        }
    }
}

