/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.proxy;

import com.pandora.core.CoreActivator;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.log.HBLog;
import com.pandora.core.proxy.Proxy;
import com.pandora.core.proxy.ProxyHelper;
import com.pandora.core.utils.StringUtil;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;

public class ProxyService {
    public static boolean setProxy() {
        boolean isSucces = false;
        isSucces = ProxyService.verifyProxy();
        if (isSucces) {
            ProxyService.saveProxy();
        }
        return isSucces;
    }

    public static boolean verifyProxy() {
        boolean isSucces = false;
        if (!ProxyService.checkProxyParam()) {
            return isSucces;
        }
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance("ProxyAction!verify");
        ResponseObj resp = httpClientUtils.excute();
        if (resp != null && "1001".equals(resp.getRspcode())) {
            isSucces = true;
        } else {
            Proxy.destroyProxy();
        }
        return isSucces;
    }

    private static boolean checkProxyParam() {
        boolean isSucces = true;
        if (StringUtil.isBlank((String)Proxy.url) || StringUtil.isBlank((String)Proxy.port) || StringUtil.isBlank((String)Proxy.type)) {
            isSucces = false;
            return isSucces;
        }
        String regx = "^[0123456789]{1,6}$";
        if (!Proxy.port.matches(regx)) {
            isSucces = false;
            return isSucces;
        }
        regx = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$";
        if (!Proxy.url.matches(regx)) {
            isSucces = false;
            return isSucces;
        }
        return isSucces;
    }

    private static void saveProxy() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proxy_type", Proxy.HTTP_TYPE);
        map.put("proxy_password", Proxy.password);
        map.put("proxy_port", Proxy.port);
        map.put("proxy_url", Proxy.url);
        map.put("proxy_username", Proxy.username);
        map.put("proxy_enable", String.valueOf(Proxy.enable));
        ProxyHelper.setValueByKey("proxy_type", Proxy.HTTP_TYPE);
        ProxyHelper.setValueByKey("proxy_password", Proxy.password);
        ProxyHelper.setValueByKey("proxy_port", Proxy.port);
        ProxyHelper.setValueByKey("proxy_url", Proxy.url);
        ProxyHelper.setValueByKey("proxy_username", Proxy.username);
        ProxyHelper.setValueByKey("proxy_enable", String.valueOf(Proxy.enable));
    }

    public static void initProxy() {
        String proxyEnable = ProxyHelper.getValueByKey("proxy_enable");
        if (StringUtil.isNotBlank((String)proxyEnable) && "true".equals(proxyEnable)) {
            HBLog.logTrace((Plugin)CoreActivator.getDefault(), (String)"init proxy");
            String type = ProxyHelper.getValueByKey("proxy_type");
            String proxyUsername = ProxyHelper.getValueByKey("proxy_username");
            String proxyPassword = ProxyHelper.getValueByKey("proxy_password");
            String url = ProxyHelper.getValueByKey("proxy_url");
            String port = ProxyHelper.getValueByKey("proxy_port");
            Proxy.initProxy(type, proxyUsername, proxyPassword, url, port);
        }
    }
}

