/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.mobile.verification;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.pandora.core.CoreActivator;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.log.HBLog;
import com.pandora.core.mobile.model.Developer;
import com.pandora.core.mobile.model.Distribute;
import com.pandora.core.mobile.model.Icons;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.Plus;
import com.pandora.core.mobile.model.SplashScreen;
import com.pandora.core.mobile.model.Version;
import com.pandora.core.mobile.model.android.AndroidIcon;
import com.pandora.core.mobile.model.android.AndroidSplashScreen;
import com.pandora.core.mobile.model.android.GoogleProfile;
import com.pandora.core.mobile.model.ios.AppleProfile;
import com.pandora.core.mobile.model.ios.IOSIcon;
import com.pandora.core.mobile.model.ios.IOSSplashScreen;
import com.pandora.core.mobile.model.ios.IPadIcon;
import com.pandora.core.mobile.model.ios.IPadSplashScreen;
import com.pandora.core.mobile.model.ios.IPhoneIcon;
import com.pandora.core.mobile.model.ios.IPhoneSplashScreen;
import com.pandora.core.mobile.model.permission.NativeUI;
import com.pandora.core.mobile.model.permission.Navigator;
import com.pandora.core.mobile.model.permission.Permission;
import com.pandora.core.mobile.model.permission.Webview;
import com.pandora.core.mobile.model.plugins.Alipay;
import com.pandora.core.mobile.model.plugins.Amap;
import com.pandora.core.mobile.model.plugins.Baidu;
import com.pandora.core.mobile.model.plugins.IGexinPush;
import com.pandora.core.mobile.model.plugins.Maps;
import com.pandora.core.mobile.model.plugins.Oauth;
import com.pandora.core.mobile.model.plugins.Payment;
import com.pandora.core.mobile.model.plugins.Plugins;
import com.pandora.core.mobile.model.plugins.Push;
import com.pandora.core.mobile.model.plugins.QQ;
import com.pandora.core.mobile.model.plugins.QqOauth;
import com.pandora.core.mobile.model.plugins.Share;
import com.pandora.core.mobile.model.plugins.Sina;
import com.pandora.core.mobile.model.plugins.SinaOauth;
import com.pandora.core.mobile.model.plugins.Speech;
import com.pandora.core.mobile.model.plugins.Statics;
import com.pandora.core.mobile.model.plugins.Tencent;
import com.pandora.core.mobile.model.plugins.WeiXinpay;
import com.pandora.core.mobile.model.plugins.Weixin;
import com.pandora.core.mobile.model.plugins.WeixinOauth;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.ProductUtils;
import com.pandora.core.utils.ReflectUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class ManifastConfigurationVerification {
    private static final String PLUGIN_ERROR_TEXT = "\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528";
    private static final String MODULE_ERROR_TEXT = "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e";
    private static final String PERMISSION_ERROR_TEXT = " \u6a21\u5757\u67d0\u4e9bAPI\u7f3a\u5c11\u6b64\u6743\u9650\u65e0\u6cd5\u4f7f\u7528";
    private static final Map<String, String> moduleNameMap = new HashMap<String, String>();
    private static final Map<String, Map<String[], List<String>>> modulePermissionMap = new HashMap<String, Map<String[], List<String>>>();

    public static Map<String, String> verify(ManifastConfiguration config, IProject project, VerificationPlatform platform) {
        return ManifastConfigurationVerification.verify(config, project, platform, false);
    }

    public static Map<String, String> verify(ManifastConfiguration config, IProject project, VerificationPlatform platform, boolean checkIosFullPlatform) {
        return ManifastConfigurationVerification.verify(config, project, platform, false, true);
    }

    public static Map<String, String> verify(ManifastConfiguration config, IProject project, VerificationPlatform platform, boolean checkIosFullPlatform, boolean checkPlugin) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (config != null) {
            Distribute distribute;
            String delay;
            String icon;
            Version version;
            if (StringUtil.isBlank((String)config.getAppid())) {
                map.put("manifest.id", null);
            }
            if (StringUtil.isBlank((String)config.getAppName())) {
                map.put("manifest.name", null);
            }
            if ((version = config.getVersion()) == null || StringUtil.isBlank((String)config.getVersion().getName())) {
                map.put("manifest.version.name", null);
            }
            if (version == null || StringUtil.isNotBlank((String)config.getVersion().getCode()) && !StringUtil.isInt((String)config.getVersion().getCode())) {
                map.put("manifest.version.code", "\u5fc5\u987b\u662f\u6574\u6570");
            }
            String launchPath = config.getLaunch_path();
            try {
                if (StringUtil.isBlank((String)launchPath) || !launchPath.toLowerCase().startsWith("http://") && !launchPath.toLowerCase().startsWith("https://") && !project.getFile(launchPath).exists()) {
                    map.put("manifest.launch_path", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                map.put("manifest.launch_path", "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (config.getIcons() != null && StringUtil.isNotBlank((String)(icon = config.getIcons().get_48())) && ManifastConfigurationVerification.getFileExists(project, config.getIcons().get_48()) == null) {
                map.put("manifest.icons.48", "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (config.getDeveloper() == null) {
                config.setDeveloper(new Developer());
            }
            Permission module = config.getPermissions();
            Plus plus = config.getPlus();
            if (plus != null && plus.getSplashscreen() != null && StringUtil.isNotBlank((String)(delay = plus.getSplashscreen().getDelay())) && !StringUtil.isInt((String)delay)) {
                map.put("manifest.plus.splashscreen.delay", "\u5fc5\u987b\u662f\u6574\u6570");
            }
            Distribute distribute2 = distribute = plus != null ? plus.getDistribute() : null;
            if (distribute == null || CollectionsUtil.isEmpty(distribute.getOrientation())) {
                map.put("manifest.plus.distribute.orientation", "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a");
            } else {
                List<String> orientations = distribute.getOrientation();
                int i = 0;
                while (i < orientations.size()) {
                    String orientation = orientations.get(i);
                    if (!(i >= 4 || "portrait-primary".equals(orientation) || "landscape-primary".equals(orientation) || "portrait-secondary".equals(orientation) || "landscape-secondary".equals(orientation))) {
                        map.put("manifest.plus.distribute.orientation", "\u683c\u5f0f\u4e0d\u6b63\u786e");
                        break;
                    }
                    if (i >= 4) {
                        map.put("manifest.plus.distribute.orientation", "\u6570\u76ee\u8d85\u51fa\u4e864\u4e2a\uff0c\u8bf7\u5220\u9664\u591a\u4f59\u7684\u5185\u5bb9");
                        break;
                    }
                    ++i;
                }
            }
            Icons icons = distribute != null ? distribute.getIcons() : null;
            SplashScreen splashScreen = distribute != null ? distribute.getSplashscreen() : null;
            boolean isIPhone = checkIosFullPlatform;
            boolean isIPad = checkIosFullPlatform;
            if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) {
                IOSIcon iOSIcon;
                if (!checkIosFullPlatform) {
                    AppleProfile appleProfile;
                    AppleProfile appleProfile2 = appleProfile = distribute != null ? distribute.getApple() : null;
                    if (appleProfile == null) {
                        map.put("manifest.plus.distribute.apple", null);
                    } else {
                        String devices = appleProfile.getDevices();
                        if (StringUtil.isBlank((String)devices)) {
                            map.put("manifest.plus.distribute.apple.devices", null);
                        } else {
                            isIPhone = "iphone".equals(devices) || "universal".equals(devices);
                            boolean bl = isIPad = "ipad".equals(devices) || "universal".equals(devices);
                            if (!isIPhone && !isIPad) {
                                map.put("manifest.plus.distribute.apple.devices", "\u5fc5\u987b\u662f iphone\u3001ipad \u6216 universal");
                            }
                        }
                    }
                }
                IOSIcon iOSIcon2 = iOSIcon = icons != null ? icons.getIos() : null;
                if (iOSIcon != null) {
                    IOSSplashScreen iOSSplashScreen;
                    if (iOSIcon != null && !StringUtil.isBoolean((String)iOSIcon.getPrerendered())) {
                        iOSIcon.setPrerendered("false");
                    }
                    if (isIPhone) {
                        IPhoneIcon iPhoneIcon;
                        IPhoneIcon iPhoneIcon2 = iPhoneIcon = iOSIcon != null ? iOSIcon.getIphone() : null;
                        if (iPhoneIcon != null) {
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getNormal()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getNormal()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.normal", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getNormal())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getRetina()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getRetina()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getRetina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getRetina7()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getRetina7()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.retina7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getRetina7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getRetina8()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getRetina8()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.retina8", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getRetina8())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getSettings_normal()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getSettings_normal()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.settings-normal", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getSettings_normal())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getSettings_retina()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getSettings_retina()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.settings-retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getSettings_retina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getSpotlight_normal()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getSpotlight_normal()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.spotlight-normal", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getSpotlight_normal())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getSpotlight_retina()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getSpotlight_retina()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.spotlight-retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getSpotlight_retina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getSpotlight_retina7()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getSpotlight_retina7()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.spotlight-retina7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getSpotlight_retina7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneIcon.getSettings_retina8()) && ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getSettings_retina8()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.iphone.settings-retina8", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneIcon.getSettings_retina8())) {
                                map.put("iconsplashchanged", "true");
                            }
                        }
                    }
                    if (isIPad) {
                        IPadIcon iPadIcon;
                        IPadIcon iPadIcon2 = iPadIcon = iOSIcon != null ? iOSIcon.getIpad() : null;
                        if (iPadIcon != null) {
                            if (StringUtil.isNotBlank((String)iPadIcon.getNormal()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getNormal()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.normal", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getNormal())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getRetina()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getRetina()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getRetina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getNormal7()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getNormal7()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.normal7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getNormal7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getRetina7()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getRetina7()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.retina7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getRetina7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getSettings_normal()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getSettings_normal()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.settings-normal", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getSettings_normal())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getSettings_retina()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getSettings_retina()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.settings-retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getSettings_retina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_normal()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getSpotlight_normal()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.spotlight-normal", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_normal())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_retina()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getSpotlight_retina()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.spotlight-retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_retina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_normal7()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getSpotlight_normal7()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.spotlight-normal7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_normal7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_retina7()) && ManifastConfigurationVerification.getFileExists(project, iPadIcon.getSpotlight_retina7()) == null) {
                                map.put("manifest.plus.distribute.icons.ios.ipad.spotlight-retina7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadIcon.getSpotlight_retina7())) {
                                map.put("iconsplashchanged", "true");
                            }
                        }
                    }
                    IOSSplashScreen iOSSplashScreen2 = iOSSplashScreen = splashScreen != null ? splashScreen.getIos() : null;
                    if (isIPhone) {
                        IPhoneSplashScreen iPhoneSplashScreen;
                        IPhoneSplashScreen iPhoneSplashScreen2 = iPhoneSplashScreen = iOSSplashScreen != null ? iOSSplashScreen.getIphone() : null;
                        if (iPhoneSplashScreen != null) {
                            if (StringUtil.isNotBlank((String)iPhoneSplashScreen.get_default()) && ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.get_default()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.iphone.default", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneSplashScreen.get_default())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina35()) && ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina35()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.iphone.retina35", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina35())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina40()) && ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina40()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.iphone.retina40", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina40())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina47()) && ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina47()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.iphone.retina47", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina47())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina55()) && ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina55()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.iphone.retina55", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina55())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina55l()) && ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina55l()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.iphone.retina55l", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPhoneSplashScreen.getRetina55l())) {
                                map.put("iconsplashchanged", "true");
                            }
                        }
                    }
                    if (isIPad) {
                        IPadSplashScreen iPadSplashScreen;
                        IPadSplashScreen iPadSplashScreen2 = iPadSplashScreen = iOSSplashScreen != null ? iOSSplashScreen.getIpad() : null;
                        if (iPadSplashScreen != null) {
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getPortrait()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.portrait", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait_retina()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getPortrait_retina()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.portrait-retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait_retina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getLandscape()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.landscape", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape_retina()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getLandscape_retina()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.landscape-retina", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape_retina())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait7()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getPortrait7()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.portrait7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape7()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getLandscape7()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.landscape7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait_retina7()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getPortrait_retina7()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.portrait-retina7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getPortrait_retina7())) {
                                map.put("iconsplashchanged", "true");
                            }
                            if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape_retina7()) && ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getLandscape_retina7()) == null) {
                                map.put("manifest.plus.distribute.splashscreen.ios.ipad.landscape-retina7", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                            } else if (StringUtil.isNotBlank((String)iPadSplashScreen.getLandscape_retina7())) {
                                map.put("iconsplashchanged", "true");
                            }
                        }
                    }
                }
            }
            if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
                AndroidSplashScreen androidSplashScreen;
                AndroidIcon androidIcon;
                AndroidIcon androidIcon2 = androidIcon = icons != null ? icons.getAndroid() : null;
                if (androidIcon != null) {
                    if (StringUtil.isNotBlank((String)androidIcon.getMdpi()) && ManifastConfigurationVerification.getFileExists(project, androidIcon.getMdpi()) == null) {
                        map.put("manifest.plus.distribute.icons.android.mdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidIcon.getMdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidIcon.getLdpi()) && ManifastConfigurationVerification.getFileExists(project, androidIcon.getLdpi()) == null) {
                        map.put("manifest.plus.distribute.icons.android.ldpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidIcon.getLdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidIcon.getHdpi()) && ManifastConfigurationVerification.getFileExists(project, androidIcon.getHdpi()) == null) {
                        map.put("manifest.plus.distribute.icons.android.hdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidIcon.getHdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidIcon.getXhdpi()) && ManifastConfigurationVerification.getFileExists(project, androidIcon.getXhdpi()) == null) {
                        map.put("manifest.plus.distribute.icons.android.xhdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidIcon.getXhdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidIcon.getXxhdpi()) && ManifastConfigurationVerification.getFileExists(project, androidIcon.getXxhdpi()) == null) {
                        map.put("manifest.plus.distribute.icons.android.xxhdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidIcon.getXxhdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                }
                AndroidSplashScreen androidSplashScreen2 = androidSplashScreen = splashScreen != null ? splashScreen.getAndroid() : null;
                if (androidSplashScreen != null) {
                    if (StringUtil.isNotBlank((String)androidSplashScreen.getMdpi()) && ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getMdpi()) == null) {
                        map.put("manifest.plus.distribute.splashscreen.android.mdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidSplashScreen.getMdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidSplashScreen.getLdpi()) && ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getLdpi()) == null) {
                        map.put("manifest.plus.distribute.splashscreen.android.ldpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidSplashScreen.getLdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidSplashScreen.getHdpi()) && ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getHdpi()) == null) {
                        map.put("manifest.plus.distribute.splashscreen.android.hdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidSplashScreen.getHdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidSplashScreen.getXhdpi()) && ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getXhdpi()) == null) {
                        map.put("manifest.plus.distribute.splashscreen.android.xhdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidSplashScreen.getXhdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                    if (StringUtil.isNotBlank((String)androidSplashScreen.getXxhdpi()) && ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getXxhdpi()) == null) {
                        map.put("manifest.plus.distribute.splashscreen.android.xxhdpi", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    } else if (StringUtil.isNotBlank((String)androidSplashScreen.getXxhdpi())) {
                        map.put("iconsplashchanged", "true");
                    }
                }
            }
            if (platform == null) {
                map.put("iconsplashchanged", "true");
            }
            if (checkPlugin) {
                Share share;
                IGexinPush iGexinPush;
                Push push;
                Payment payment;
                Oauth oauth;
                Maps maps;
                Plugins plugins = distribute != null ? distribute.getPlugins() : null;
                Statics statics = plugins != null ? plugins.getStatics() : null;
                boolean isAlpha = ProductUtils.isAlpha();
                boolean hasPlugin = false;
                Maps maps2 = maps = plugins != null ? plugins.getMap() : null;
                if (maps != null) {
                    Amap amap;
                    Baidu baidumap = maps.getBaidumap();
                    if (baidumap != null) {
                        hasPlugin = true;
                        if ((platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) && StringUtil.isBlank((String)baidumap.getAppkey_ios())) {
                            map.put("manifest.plus.distribute.plugins.maps.baidu.appkey_ios", null);
                        }
                        if ((platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) && StringUtil.isBlank((String)baidumap.getAppkey_android())) {
                            map.put("manifest.plus.distribute.plugins.maps.baidu.appkey_android", null);
                        }
                        if (module == null || module.getMaps() == null) {
                            map.put("manifest.permissions.Maps", "\u5730\u56feSDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((amap = maps.getAmap()) != null) {
                        hasPlugin = true;
                        if ((platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) && StringUtil.isBlank((String)amap.getAppkey_ios())) {
                            map.put("manifest.plus.distribute.plugins.maps.amap.appkey_ios", null);
                        }
                        if ((platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) && StringUtil.isBlank((String)amap.getAppkey_android())) {
                            map.put("manifest.plus.distribute.plugins.maps.amap.appkey_android", null);
                        }
                        if (module == null || module.getMaps() == null) {
                            map.put("manifest.permissions.Maps", "\u5730\u56feSDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                }
                HashMap<String, String> weixinAppids = new HashMap<String, String>();
                HashMap<String, String> qqAppids = new HashMap<String, String>();
                HashMap<String, String> sinaAppids = new HashMap<String, String>();
                Oauth oauth2 = oauth = plugins != null ? plugins.getOauth() : null;
                if (oauth != null) {
                    SinaOauth sinaOauth;
                    QqOauth qqoauth;
                    WeixinOauth weixinoauth = oauth.getWeixin();
                    if (weixinoauth != null) {
                        hasPlugin = true;
                        weixinAppids.put("manifest.plus.distribute.plugins.oauth.weixin.appid", StringUtil.trimToEmpty((String)weixinoauth.getAppid()));
                        if (StringUtil.isBlank((String)weixinoauth.getAppid())) {
                            map.put("manifest.plus.distribute.plugins.oauth.weixin.appid", null);
                        }
                        if (StringUtil.isBlank((String)weixinoauth.getAppsecret())) {
                            map.put("manifest.plus.distribute.plugins.oauth.weixin.appsecret", null);
                        }
                        if (module == null || module.getOAuth() == null) {
                            map.put("manifest.permissions.OAuth", "\u767b\u5f55\u9274\u6743SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((qqoauth = oauth.getQq()) != null) {
                        hasPlugin = true;
                        qqAppids.put("manifest.plus.distribute.plugins.oauth.qq.appid", StringUtil.trimToEmpty((String)qqoauth.getAppid()));
                        if (StringUtil.isBlank((String)qqoauth.getAppid())) {
                            map.put("manifest.plus.distribute.plugins.oauth.qq.appid", null);
                        }
                        if (module == null || module.getOAuth() == null) {
                            map.put("manifest.permissions.OAuth", "\u767b\u5f55\u9274\u6743SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((sinaOauth = oauth.getSina()) != null) {
                        hasPlugin = true;
                        sinaAppids.put("manifest.plus.distribute.plugins.oauth.sina.appkey", StringUtil.trimToEmpty((String)sinaOauth.getAppkey()));
                        if (StringUtil.isBlank((String)sinaOauth.getAppkey())) {
                            map.put("manifest.plus.distribute.plugins.oauth.sina.appkey", null);
                        }
                        if (StringUtil.isBlank((String)sinaOauth.getAppsecret())) {
                            map.put("manifest.plus.distribute.plugins.oauth.sina.appsecret", null);
                        }
                        if (StringUtil.isBlank((String)sinaOauth.getRedirect_uri())) {
                            map.put("manifest.plus.distribute.plugins.oauth.sina.redirect_uri", null);
                        }
                        if (module == null || module.getOAuth() == null) {
                            map.put("manifest.permissions.OAuth", "\u767b\u5f55\u9274\u6743SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                }
                if (!isAlpha && !hasPlugin && module != null && module.getOAuth() != null) {
                    map.put("manifest.permissions.OAuth", "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e\u767b\u5f55\u9274\u6743SDK");
                }
                Payment payment2 = payment = plugins != null ? plugins.getPayment() : null;
                if (payment != null) {
                    WeiXinpay weixin;
                    Alipay alipay = payment.getAlipay();
                    if (alipay != null) {
                        hasPlugin = true;
                        if (module == null || module.getPayment() == null) {
                            map.put("manifest.permissions.Payment", "\u652f\u4ed8SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((weixin = payment.getWeixin()) != null) {
                        hasPlugin = true;
                        weixinAppids.put("manifest.plus.distribute.plugins.payment.weixin.appid", StringUtil.trimToEmpty((String)weixin.getAppid()));
                        if (StringUtil.isBlank((String)weixin.getAppid())) {
                            map.put("manifest.plus.distribute.plugins.payment.weixin.appid", null);
                        }
                        if (module == null || module.getPayment() == null) {
                            map.put("manifest.permissions.Payment", "\u652f\u4ed8SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                }
                if (!isAlpha && !hasPlugin && module != null && module.getPayment() != null) {
                    map.put("manifest.permissions.Payment", "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e\u652f\u4ed8SDK");
                }
                hasPlugin = false;
                Push push2 = push = plugins != null ? plugins.getPush() : null;
                if (push != null && (iGexinPush = push.getIgexin()) != null) {
                    hasPlugin = true;
                    if (StringUtil.isBlank((String)iGexinPush.getAppid())) {
                        map.put("manifest.plus.distribute.plugins.push.igexin.appid", null);
                    }
                    if (StringUtil.isBlank((String)iGexinPush.getAppkey())) {
                        map.put("manifest.plus.distribute.plugins.push.igexin.appkey", null);
                    }
                    if (StringUtil.isBlank((String)iGexinPush.getAppsecret())) {
                        map.put("manifest.plus.distribute.plugins.push.igexin.appsecret", null);
                    }
                    if (module == null || module.getPush() == null) {
                        map.put("manifest.permissions.Push", "\u63a8\u9001SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                    }
                }
                if (!isAlpha && !hasPlugin && module != null && module.getPush() != null) {
                    map.put("manifest.permissions.Push", "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e\u63a8\u9001SDK");
                }
                hasPlugin = false;
                Share share2 = share = plugins != null ? plugins.getShare() : null;
                if (share != null) {
                    QQ qq;
                    Weixin weixin;
                    Tencent tencent;
                    Sina sina = share.getSina();
                    if (sina != null) {
                        hasPlugin = true;
                        sinaAppids.put("manifest.plus.distribute.plugins.share.sina.appkey", StringUtil.trimToEmpty((String)sina.getAppkey()));
                        if (StringUtil.isBlank((String)sina.getAppkey())) {
                            map.put("manifest.plus.distribute.plugins.share.sina.appkey", null);
                        }
                        if (StringUtil.isBlank((String)sina.getAppsecret())) {
                            map.put("manifest.plus.distribute.plugins.share.sina.appsecret", null);
                        }
                        if (StringUtil.isBlank((String)sina.getRedirect_uri())) {
                            map.put("manifest.plus.distribute.plugins.share.sina.redirect_uri", null);
                        }
                        if (module == null || module.getShare() == null) {
                            map.put("manifest.permissions.Share", "\u5206\u4eabSDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((tencent = share.getTencent()) != null) {
                        hasPlugin = true;
                        if (StringUtil.isBlank((String)tencent.getAppkey())) {
                            map.put("manifest.plus.distribute.plugins.share.tencent.appkey", null);
                        }
                        if (StringUtil.isBlank((String)tencent.getAppsecret())) {
                            map.put("manifest.plus.distribute.plugins.share.tencent.appsecret", null);
                        }
                        if (StringUtil.isBlank((String)tencent.getRedirect_uri())) {
                            map.put("manifest.plus.distribute.plugins.share.tencent.redirect_uri", null);
                        }
                        if (module == null || module.getShare() == null) {
                            map.put("manifest.permissions.Share", "\u5206\u4eabSDK-\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((weixin = share.getWeixin()) != null) {
                        hasPlugin = true;
                        weixinAppids.put("manifest.plus.distribute.plugins.share.weixin.appid", StringUtil.trimToEmpty((String)weixin.getAppkey()));
                        if (StringUtil.isBlank((String)weixin.getAppkey())) {
                            map.put("manifest.plus.distribute.plugins.share.weixin.appid", null);
                        }
                        if (StringUtil.isBlank((String)weixin.getAppsecret())) {
                            map.put("manifest.plus.distribute.plugins.share.weixin.appsecret", null);
                        }
                        if (module == null || module.getShare() == null) {
                            map.put("manifest.permissions.Share", "\u5206\u4eabSDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                    if ((qq = share.getQq()) != null) {
                        hasPlugin = true;
                        qqAppids.put("manifest.plus.distribute.plugins.share.qq.appid", StringUtil.trimToEmpty((String)qq.getAppid()));
                        if (StringUtil.isBlank((String)qq.getAppid())) {
                            map.put("manifest.plus.distribute.plugins.share.qq.appid", null);
                        }
                        if (module == null || module.getShare() == null) {
                            map.put("manifest.permissions.Share", "\u5206\u4eabSDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                        }
                    }
                }
                if (!isAlpha && !hasPlugin && module != null && module.getShare() != null) {
                    map.put("manifest.permissions.Share", "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e\u5206\u4eabSDK");
                }
                hasPlugin = false;
                if (statics != null && statics.getUmeng() != null) {
                    hasPlugin = true;
                    if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) {
                        if (StringUtil.isBlank((String)statics.getUmeng().getAppkey())) {
                            map.put("manifest.plus.distribute.plugins.statics.umeng.appkey_ios", null);
                        }
                        if (StringUtil.isBlank((String)statics.getUmeng().getChannelid())) {
                            map.put("manifest.plus.distribute.plugins.statics.umeng.channelid_ios", null);
                        }
                    }
                    if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
                        if (StringUtil.isBlank((String)statics.getUmeng().getAppkey_android())) {
                            map.put("manifest.plus.distribute.plugins.statics.umeng.appkey_android", null);
                        }
                        if (StringUtil.isBlank((String)statics.getUmeng().getChannelid_android())) {
                            map.put("manifest.plus.distribute.plugins.statics.umeng.channelid_android", null);
                        }
                    }
                    if (module == null || module.getStatistic() == null) {
                        map.put("manifest.permissions.Statistic", "\u7edf\u8ba1SDK\u9700\u8981\u4f7f\u7528\u6b64\u6a21\u5757\uff0c\u5982\u4e0d\u9009\u62e9\u6b64\u6a21\u5757\uff0c\u4f1a\u5bfc\u81f4\u67d0\u4e9b\u529f\u80fd\u4e0d\u53ef\u4f7f\u7528");
                    }
                }
                if (!isAlpha && !hasPlugin && module != null && module.getStatistic() != null) {
                    map.put("manifest.permissions.Statistic", "\u9009\u62e9\u6b64\u6a21\u5757\u9700\u8981\u914d\u7f6e\u7edf\u8ba1SDK");
                }
                hasPlugin = false;
                ManifastConfigurationVerification.checkEquals(weixinAppids, "\u5fae\u4fe1\u767b\u5f55\u3001\u5fae\u4fe1\u652f\u4ed8\u3001\u5fae\u4fe1\u6d88\u606f\u53ca\u670b\u53cb\u5708\u7684appid\u5fc5\u987b\u4e00\u81f4", map);
                ManifastConfigurationVerification.checkEquals(qqAppids, "QQ\u767b\u5f55\u3001\u5206\u4eab\u5230QQ\u597d\u53cb\u7684appid\u5fc5\u987b\u4e00\u81f4", map);
                ManifastConfigurationVerification.checkEquals(sinaAppids, "\u65b0\u6d6a\u5fae\u535a\u767b\u5f55\u3001\u65b0\u6d6a\u5fae\u535a\u7684appkey\u5fc5\u987b\u4e00\u81f4", map);
            }
        }
        return map;
    }

    private static void checkEquals(Map<String, String> appidMap, String error, Map<String, String> errorMap) {
        Collection<String> list;
        if (!appidMap.isEmpty() && (list = appidMap.values()) != null && list.size() > 0 && new HashSet<String>(list).size() != 1) {
            for (String key : appidMap.keySet()) {
                errorMap.put(key, error);
            }
        }
    }

    public static Map<String, String> verifyPermission(ManifastConfiguration config, IProject project, VerificationPlatform platform) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
            Field[] fields;
            Permission module = config.getPermissions();
            if (module == null) {
                return map;
            }
            Plus plus = config.getPlus();
            Set<String> nowPermissions = null;
            if (plus != null && plus.getDistribute() != null && plus.getDistribute().getGoogle() != null) {
                nowPermissions = plus.getDistribute().getGoogle().getPermissions();
            }
            Plugins plugins = null;
            if (plus != null && plus.getDistribute() != null) {
                plugins = plus.getDistribute().getPlugins();
            }
            ManifastConfigurationVerification.getModuleAndPermissionsMap(null);
            Field[] fieldArray = fields = module.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleName;
                Map<String[], List<String>> permissionMaps;
                Field field = fieldArray[n2];
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null && (permissionMaps = modulePermissionMap.get(moduleName = serializedName.value())) != null && !permissionMaps.isEmpty()) {
                    field.setAccessible(true);
                    try {
                        if (field.get(module) != null) {
                            if (permissionMaps.size() == 1 && permissionMaps.keySet().iterator().next().length == 0) {
                                List<String> requiredPermissionList = permissionMaps.values().iterator().next();
                                for (String permissionStr : requiredPermissionList) {
                                    if (nowPermissions != null && nowPermissions.contains(permissionStr)) continue;
                                    map.put("manifest.plus.distribute.google.permissions." + permissionStr, String.valueOf(moduleNameMap.get(moduleName)) + PERMISSION_ERROR_TEXT);
                                }
                            } else if (permissionMaps.size() >= 1 && plugins != null) {
                                Set<String[]> requiredPluginPaths = permissionMaps.keySet();
                                for (String[] requiredPluginPath : requiredPluginPaths) {
                                    if (ReflectUtils.getFieldValue(plugins, requiredPluginPath) == null) continue;
                                    List<String> permissionList = permissionMaps.get(requiredPluginPath);
                                    for (String permissionStr : permissionList) {
                                        if (nowPermissions != null && nowPermissions.contains(permissionStr)) continue;
                                        map.put("manifest.plus.distribute.google.permissions." + permissionStr, String.valueOf(moduleNameMap.get(moduleName)) + PERMISSION_ERROR_TEXT);
                                    }
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return map;
    }

    public static Map<String, Map<String[], List<String>>> getModuleAndPermissionsMap(JSONObject jsonConfig) {
        if (modulePermissionMap.isEmpty()) {
            block15: {
                if (jsonConfig == null) {
                    InputStream configFileInput = null;
                    try {
                        try {
                            URL url = Platform.getBundle((String)"com.pandora.editor.ui").getResource("/config/appeditor_permission.json");
                            configFileInput = url.openStream();
                            jsonConfig = new JSONObject(configFileInput);
                        }
                        catch (Throwable e) {
                            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                            IOUtils.closeQuietly(configFileInput);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(configFileInput);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)configFileInput);
                }
            }
            if (jsonConfig != null) {
                try {
                    JSONArray listJsonArray = jsonConfig.optJSONObject("modules").optJSONArray("list");
                    int i = 0;
                    while (i < listJsonArray.size()) {
                        JSONObject listJsonObject = listJsonArray.getJSONObject(i);
                        String moduleName = listJsonObject.optString("path");
                        boolean hasSub = listJsonObject.optBoolean("hassub");
                        moduleNameMap.put(moduleName, listJsonObject.optString("desc"));
                        if (listJsonObject.has("permissions")) {
                            JSONArray permissions = listJsonObject.optJSONArray("permissions");
                            HashMap<String[], List<String>> permissionsMap = new HashMap<String[], List<String>>();
                            if (!hasSub) {
                                permissionsMap.put(new String[0], Arrays.asList((String[])permissions.toArray((Object[])new String[permissions.size()])));
                                modulePermissionMap.put(moduleName, permissionsMap);
                            } else {
                                int y = 0;
                                while (y < permissions.size()) {
                                    JSONObject permissionsJsonObject = permissions.getJSONObject(y);
                                    String pluginpath = permissionsJsonObject.optString("pluginpath");
                                    JSONArray subpermissions = permissionsJsonObject.optJSONArray("subpermissions");
                                    permissionsMap.put(pluginpath.split("\\."), Arrays.asList((String[])subpermissions.toArray((Object[])new String[subpermissions.size()])));
                                    ++y;
                                }
                                modulePermissionMap.put(moduleName, permissionsMap);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                }
            }
        }
        return modulePermissionMap;
    }

    public static String getModuleShowName(String moduleName) {
        ManifastConfigurationVerification.getModuleAndPermissionsMap(null);
        return moduleNameMap.get(moduleName);
    }

    public static JsonObject setDefaultValues(ManifastConfiguration config, File configFile, IProject project, VerificationPlatform platform, boolean needAddDebug) throws IOException {
        Plugins plugins;
        Permission permissions;
        JsonElement jsonElement = new JsonParser().parse(FileUtils.readFileToString((File)configFile));
        Gson gson = new Gson();
        JsonObject json = jsonElement.getAsJsonObject();
        if (config.getPermissions() == null) {
            permissions = new Permission();
            json.add("permissions", gson.toJsonTree((Object)permissions));
            config.setPermissions(permissions);
        } else {
            permissions = config.getPermissions();
            if (permissions.getUi() != null) {
                JsonObject permissionsObject = json.getAsJsonObject("permissions");
                if (permissions.getNativeUI() == null) {
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, permissionsObject, "NativeUI", new NativeUI());
                }
                if (permissions.getNavigator() == null) {
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, permissionsObject, "Navigator", new Navigator());
                }
                if (permissions.getWebview() == null) {
                    ManifastConfigurationVerification.addDefaultObjectToParent(gson, permissionsObject, "Webview", new Webview());
                }
            }
        }
        File file = null;
        if (config.getIcons() != null) {
            JsonObject iconsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, json, "icons", config.getIcons());
            file = ManifastConfigurationVerification.getFileExists(project, config.getIcons().get_48());
            if (file != null) {
                iconsJson.addProperty("48", file.getAbsolutePath());
                config.getIcons().set_48(file.getAbsolutePath());
                file = null;
            }
        }
        if (config.getDeveloper() != null) {
            if (StringUtil.isBlank((String)config.getDeveloper().getEmail())) {
                json.getAsJsonObject("developer").addProperty("email", UserAuth.getUsername());
                config.getDeveloper().setEmail(UserAuth.getUsername());
            }
            if (StringUtil.isBlank((String)config.getDeveloper().getName())) {
                json.getAsJsonObject("developer").addProperty("name", UserAuth.getUsername());
                config.getDeveloper().setName(UserAuth.getUsername());
            }
        }
        Plus plus = config.getPlus();
        JsonObject plusJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, json, "plus", plus);
        if (StringUtil.isNotBlank((String)plus.getRamcachemode())) {
            plusJson.addProperty("ramcachemode", plus.getRamcachemode());
        }
        if (plus.getSplashscreen() != null) {
            JsonObject splashscreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, plusJson, "splashscreen", plus.getSplashscreen());
            boolean autoclose = plus.getSplashscreen().getAutoclose();
            splashscreenJson.addProperty("autoclose", Boolean.valueOf(autoclose));
        }
        JsonObject distributeJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, plusJson, "distribute", plus.getDistribute());
        if (plus.getDistribute().isDebug() || needAddDebug) {
            distributeJson.addProperty("debug", Boolean.valueOf(plus.getDistribute().isDebug()));
        }
        Icons icons = plus.getDistribute().getIcons();
        JsonObject iconsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "icons", icons);
        SplashScreen splashScreen = plus.getDistribute().getSplashscreen();
        boolean isIPhone = false;
        boolean isIPad = false;
        if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.IOS) {
            AppleProfile appleProfile = plus.getDistribute().getApple();
            JsonObject appleProfileJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "apple", plus.getDistribute().getApple());
            appleProfileJson.addProperty("appid", appleProfile.getAppid());
            appleProfileJson.addProperty("password", appleProfile.getPassword());
            appleProfileJson.addProperty("mobileprovision", appleProfile.getMobileprovision());
            appleProfileJson.addProperty("p12", appleProfile.getP12());
            String devices = appleProfile.getDevices();
            isIPhone = "iphone".equals(devices) || "universal".equals(devices);
            isIPad = "ipad".equals(devices) || "universal".equals(devices);
            appleProfileJson.addProperty("devices", devices);
            if (icons != null) {
                IOSIcon iOSIcon = icons.getIos();
                JsonObject iOSIconJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iconsJson, "ios", iOSIcon);
                if (!StringUtil.isBoolean((String)iOSIcon.getPrerendered())) {
                    iOSIcon.setPrerendered("false");
                }
                iOSIconJson.addProperty("prerendered", iOSIcon.getPrerendered());
                if (isIPhone) {
                    IPhoneIcon iPhoneIcon = iOSIcon.getIphone();
                    JsonObject iPhoneIconJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iOSIconJson, "iphone", iPhoneIcon);
                    file = ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getNormal());
                    if (file != null) {
                        iPhoneIconJson.addProperty("normal", file.getAbsolutePath());
                        iPhoneIcon.setNormal(file.getAbsolutePath());
                    } else {
                        iPhoneIconJson.addProperty("normal", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon57.png"));
                        iPhoneIcon.setNormal(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon57.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPhoneIcon.getRetina());
                    if (file != null) {
                        iPhoneIconJson.addProperty("retina", file.getAbsolutePath());
                        iPhoneIcon.setRetina(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPhoneIconJson.addProperty("retina", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/iphone-icon114.png"));
                        iPhoneIcon.setRetina(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon114.png"));
                    }
                }
                if (isIPad) {
                    IPadIcon iPadIcon = iOSIcon.getIpad();
                    JsonObject iPadIconJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iOSIconJson, "ipad", iPadIcon);
                    file = ManifastConfigurationVerification.getFileExists(project, iPadIcon.getNormal());
                    if (file != null) {
                        iPadIconJson.addProperty("normal", file.getAbsolutePath());
                        iPadIcon.setNormal(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPadIconJson.addProperty("normal", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon72.png"));
                        iPadIcon.setNormal(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon72.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPadIcon.getRetina());
                    if (file != null) {
                        iPadIconJson.addProperty("retina", file.getAbsolutePath());
                        iPadIcon.setRetina(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPadIconJson.addProperty("retina", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon144.png"));
                        iPadIcon.setRetina(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/icon144.png"));
                    }
                }
            }
            if (splashScreen != null) {
                JsonObject splashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "splashscreen", splashScreen);
                IOSSplashScreen iOSSplashScreen = splashScreen.getIos();
                JsonObject iOSSplashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, splashScreenJson, "ios", iOSSplashScreen);
                if (isIPhone) {
                    IPhoneSplashScreen iPhoneSplashScreen = iOSSplashScreen.getIphone();
                    JsonObject iPhoneSplashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iOSSplashScreenJson, "iphone", iPhoneSplashScreen);
                    file = ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.get_default());
                    if (file != null) {
                        iPhoneSplashScreenJson.addProperty("default", file.getAbsolutePath());
                        iPhoneSplashScreen.set_default(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPhoneSplashScreenJson.addProperty("default", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash320x480.png"));
                        iPhoneSplashScreen.set_default(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash320x480.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina35());
                    if (file != null) {
                        iPhoneSplashScreenJson.addProperty("retina35", file.getAbsolutePath());
                        iPhoneSplashScreen.setRetina35(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPhoneSplashScreenJson.addProperty("retina35", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash640x960.png"));
                        iPhoneSplashScreen.setRetina35(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash640x960.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPhoneSplashScreen.getRetina40());
                    if (file != null) {
                        iPhoneSplashScreenJson.addProperty("retina40", file.getAbsolutePath());
                        iPhoneSplashScreen.setRetina40(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPhoneSplashScreenJson.addProperty("retina40", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash640x1136.png"));
                        iPhoneSplashScreen.setRetina40(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash640x1136.png"));
                    }
                }
                if (isIPad) {
                    IPadSplashScreen iPadSplashScreen = iOSSplashScreen.getIpad();
                    JsonObject iPadSplashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iOSSplashScreenJson, "ipad", iPadSplashScreen);
                    file = ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getPortrait());
                    if (file != null) {
                        iPadSplashScreenJson.addProperty("portrait", file.getAbsolutePath());
                        iPadSplashScreen.setPortrait(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPadSplashScreenJson.addProperty("portrait", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash768x1004.png"));
                        iPadSplashScreen.setPortrait(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash768x1004.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getPortrait_retina());
                    if (file != null) {
                        iPadSplashScreenJson.addProperty("portrait-retina", file.getAbsolutePath());
                        iPadSplashScreen.setPortrait_retina(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPadSplashScreenJson.addProperty("portrait-retina", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash1536x2008.png"));
                        iPadSplashScreen.setPortrait_retina(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash1536x2008.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getLandscape());
                    if (file != null) {
                        iPadSplashScreenJson.addProperty("landscape", file.getAbsolutePath());
                        iPadSplashScreen.setLandscape(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPadSplashScreenJson.addProperty("landscape", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash1024x748.png"));
                        iPadSplashScreen.setLandscape(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash1024x748.png"));
                    }
                    file = ManifastConfigurationVerification.getFileExists(project, iPadSplashScreen.getLandscape_retina());
                    if (file != null) {
                        iPadSplashScreenJson.addProperty("landscape-retina", file.getAbsolutePath());
                        iPadSplashScreen.setLandscape_retina(file.getAbsolutePath());
                        file = null;
                    } else {
                        iPadSplashScreen.setLandscape_retina(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash2048x1496.png"));
                        iPadSplashScreenJson.addProperty("landscape-retina", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/ios/splash2048x1496.png"));
                    }
                }
            }
        }
        if (platform == VerificationPlatform.ALL || platform == VerificationPlatform.ANDROID) {
            JsonObject googleProfileJson;
            GoogleProfile googleProfile = config.getPlus().getDistribute().getGoogle();
            if (googleProfile != null) {
                googleProfileJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "google", googleProfile);
                googleProfileJson.addProperty("packagename", googleProfile.getPackagename());
                googleProfileJson.addProperty("password", googleProfile.getPassword());
                googleProfileJson.addProperty("aliasname", googleProfile.getAliasname());
                googleProfileJson.addProperty("keystore", googleProfile.getKeystore());
                googleProfileJson.addProperty("custompermissions", Boolean.valueOf(true));
            } else {
                googleProfileJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "google", new GoogleProfile());
                googleProfileJson.addProperty("custompermissions", Boolean.valueOf(true));
            }
            if (icons != null) {
                AndroidIcon androidIcon = icons.getAndroid();
                JsonObject androidIconJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, iconsJson, "android", androidIcon);
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getMdpi());
                if (file != null) {
                    androidIconJson.addProperty("mdpi", file.getAbsolutePath());
                    androidIcon.setMdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("mdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                    androidIcon.setMdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getLdpi());
                if (file != null) {
                    androidIconJson.addProperty("ldpi", file.getAbsolutePath());
                    androidIcon.setLdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("ldpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                    androidIcon.setLdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon48.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getHdpi());
                if (file != null) {
                    androidIconJson.addProperty("hdpi", file.getAbsolutePath());
                    androidIcon.setHdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("hdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon72.png"));
                    androidIcon.setHdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon72.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getXhdpi());
                if (file != null) {
                    androidIconJson.addProperty("xhdpi", file.getAbsolutePath());
                    androidIcon.setXhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("xhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon96.png"));
                    androidIcon.setXhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon96.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidIcon.getXxhdpi());
                if (file != null) {
                    androidIconJson.addProperty("xxhdpi", file.getAbsolutePath());
                    androidIcon.setXxhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidIconJson.addProperty("xxhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon144.png"));
                    androidIcon.setXxhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/icon144.png"));
                }
            }
            if (splashScreen != null) {
                JsonObject splashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "splashscreen", splashScreen);
                AndroidSplashScreen androidSplashScreen = splashScreen.getAndroid();
                JsonObject androidSplashScreenJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, splashScreenJson, "android", androidSplashScreen);
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getMdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("mdpi", file.getAbsolutePath());
                    androidSplashScreen.setMdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidSplashScreenJson.addProperty("mdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash240x282.png"));
                    androidSplashScreen.setMdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash240x282.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getLdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("ldpi", file.getAbsolutePath());
                    androidSplashScreen.setLdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidSplashScreenJson.addProperty("ldpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash320x442.png"));
                    androidSplashScreen.setLdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash320x442.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getHdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("hdpi", file.getAbsolutePath());
                    androidSplashScreen.setHdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidSplashScreenJson.addProperty("hdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash480x762.png"));
                    androidSplashScreen.setHdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash480x762.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getXhdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("xhdpi", file.getAbsolutePath());
                    androidSplashScreen.setXhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidSplashScreenJson.addProperty("xhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash720x1242.png"));
                    androidSplashScreen.setXhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash720x1242.png"));
                }
                file = ManifastConfigurationVerification.getFileExists(project, androidSplashScreen.getXxhdpi());
                if (file != null) {
                    androidSplashScreenJson.addProperty("xxhdpi", file.getAbsolutePath());
                    androidSplashScreen.setXxhdpi(file.getAbsolutePath());
                    file = null;
                } else {
                    androidSplashScreenJson.addProperty("xxhdpi", ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash1080x1882.png"));
                    androidSplashScreen.setXxhdpi(ManifastConfigurationVerification.getDefaultFilePath("icons/hbuilder/android/splash1080x1882.png"));
                }
            }
        }
        if ((plugins = plus.getDistribute().getPlugins()) != null) {
            Maps map;
            Push push;
            Share share;
            Speech speech;
            JsonObject pluginsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, distributeJson, "plugins", plugins);
            Statics statics = plugins.getStatics();
            if (statics != null) {
                JsonObject staticsJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "statics", statics);
                if (StringUtil.isBlank((String)statics.getDescription())) {
                    statics.setDescription("\u7ba1\u7406\u6d88\u606f\u63a8\u9001\u80fd\u529b");
                }
                staticsJson.addProperty("description", statics.getDescription());
                if (statics.getUmeng() == null) {
                    pluginsJson.remove("statics");
                    plugins.setStatics(null);
                }
            }
            if ((speech = plugins.getSpeech()) != null && (speech.getIfly() == null || StringUtil.isBlank((String)speech.getIfly().getAppid()))) {
                pluginsJson.remove("speech");
                plugins.setSpeech(null);
            }
            if ((share = plugins.getShare()) != null) {
                Sina sina = share.getSina();
                Tencent tencent = share.getTencent();
                Weixin weixin = share.getWeixin();
                if (sina == null && tencent == null && weixin == null) {
                    pluginsJson.remove("share");
                    plugins.setShare(null);
                } else {
                    JsonObject shareJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "share", share);
                    if (sina != null && (StringUtil.isBlank((String)sina.getAppkey()) || StringUtil.isBlank((String)sina.getAppsecret()) || StringUtil.isBlank((String)sina.getRedirect_uri()))) {
                        shareJson.remove("sina");
                        share.setSina(null);
                    }
                    if (tencent != null && (StringUtil.isBlank((String)tencent.getAppkey()) || StringUtil.isBlank((String)tencent.getAppsecret()) || StringUtil.isBlank((String)tencent.getRedirect_uri()))) {
                        shareJson.remove("tencent");
                        share.setTencent(null);
                    }
                    if (weixin != null && (StringUtil.isBlank((String)weixin.getAppkey()) || StringUtil.isBlank((String)weixin.getAppsecret()))) {
                        shareJson.remove("weixin");
                        share.setWeixin(null);
                    }
                }
            }
            if ((push = plugins.getPush()) != null) {
                JsonObject pushJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "push", push);
                if (!StringUtil.isBoolean((String)push.getCover())) {
                    pushJson.addProperty("cover", "false");
                    push.setCover("false");
                }
                if (StringUtil.isBlank((String)push.getDescription())) {
                    push.setDescription("\u7ba1\u7406\u6d88\u606f\u63a8\u9001\u80fd\u529b");
                }
                pushJson.addProperty("description", push.getDescription());
                IGexinPush iGexinPush = push.getIgexin();
                if (iGexinPush == null) {
                    pluginsJson.remove("push");
                    plugins.setPush(null);
                }
            }
            if ((map = plugins.getMap()) != null) {
                JsonObject mapJson = ManifastConfigurationVerification.addDefaultObjectToParent(gson, pluginsJson, "map", map);
                if (StringUtil.isBlank((String)map.getDescription())) {
                    map.setDescription("\u7ba1\u7406\u6d88\u606f\u63a8\u9001\u80fd\u529b");
                }
                mapJson.addProperty("description", push.getDescription());
                Baidu baidumap = map.getBaidumap();
                if (baidumap == null) {
                    pluginsJson.remove("map");
                    plugins.setMap(null);
                }
            }
        }
        return json;
    }

    private static JsonObject addDefaultObjectToParent(Gson gson, JsonObject parent, String name, Object object) {
        if (!parent.has(name)) {
            parent.add(name, gson.toJsonTree(object));
        }
        return parent.getAsJsonObject(name);
    }

    private static String getDefaultFilePath(String name) {
        return ResourceUtil.resourcePathToString((URL)Platform.getBundle((String)"com.pandora.editor.ui").getEntry(name));
    }

    public static File getFileExists(IProject project, String pathStr) {
        File file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)project, (String)pathStr);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static enum VerificationPlatform {
        IOS,
        ANDROID,
        ALL;

    }
}

