/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.jslib;

import com.pandora.core.jslib.JSLib;
import com.pandora.core.jslib.JavaScriptElement;
import com.pandora.core.jslib.JavaScriptLibraryElement;
import com.pandora.core.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class JavaScriptFileElement
extends JavaScriptElement {
    private String location = null;

    public JavaScriptFileElement(JavaScriptElement parent) {
        super(parent);
        if (parent instanceof JavaScriptLibraryElement) {
            ((JavaScriptLibraryElement)parent).addJavaScriptElement(this);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getProjectRelativePath() {
        if (StringUtil.isNotBlank((String)this.location) && this.location.startsWith("built_in:")) {
            return this.location.substring("built_in:".length());
        }
        return "";
    }

    @Override
    public InputStream getContents() throws CoreException {
        File file;
        String location = this.getLocation();
        if (!StringUtil.isEmpty((String)location) && location.startsWith("built_in:")) {
            location = location.substring("built_in:".length());
        }
        if ((file = new File(location = JSLib.getJSLibAbsoluteLocation(location))).exists()) {
            try {
                return new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.getContents();
    }

    @Override
    public Image getImage() {
        return ResourceManager.getPluginImage("com.pandora.core", "icons/js.png");
    }

    @Override
    public IResource getResource() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JavaScriptFileElement other = (JavaScriptFileElement)((Object)obj);
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }
}

