/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.httpclient;

import com.pandora.core.CoreActivator;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.auth.UserAuthHelper;
import com.pandora.core.auth.UserAuthService;
import com.pandora.core.exception.ConnectionException;
import com.pandora.core.httpclient.IFileUpdateProgress;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.log.HBLog;
import com.pandora.core.proxy.Proxy;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class HttpClientUtils {
    public static final String USERLOGIN_COMMADN = "UserAction!login";
    public static final String FORGETPASSWORD_COMMADN = "UserAction!forgetPassword";
    public static final String USERREG_COMMADN = "UserAction!register";
    public static final String PROXYTEST_COMMADN = "ProxyAction!verify";
    public static final String PACKAGESTATUS_COMMADN = "ProjectAction!getHistoryPackage";
    public static final String CLEARPACKAGESTATUS_COMMADN = "ProjectAction!clearHistoryPackage";
    public static final String GENERATEAPPPACKAGE_COMMADN = "ProjectAction!generateAppPackage";
    public static final String CANCELAPPPACKAGE_COMMADN = "ProjectAction!cancelAppPackage";
    public static final String CONFUSIONWGT_COMMADN = "ProjectAction!confusionWgt";
    public static final String DOWNLOADPACKAGE_COMMADN = "ProjectAction!downloadPackage";
    public static final String ACTION_COMMADN = "ProjectAction!action";
    public static final String APPLYPROJECT_COMMADN = "ProjectAction!applyProject";
    public static final String STATS_COMMADN = "StatsAction!stats";
    public static final String EVENTCHECK_COMMADN = "EventAction!check";
    public static final String EVENTPOLLING_COMMADN = "EventAction!polling";
    public static final String FEEDBACK_COMMADN = "FeedbackAction!send";
    public static final String STREAMAPPVERSION_COMMADN = "StreamApp!version";
    public static final String STREAMAPPPUBLISH_COMMADN = "StreamApp!publish";
    public static final String STREAMAPPCHECKOWNER_COMMADN = "StreamApp!checkowner";
    public static final String KUAIMAGENERATE_COMMADN = "KuaiMa!generate";
    public static final String KUAIMAGET_COMMADN = "KuaiMa!get";
    public static final String SUCESS_REPCODE = "1001";
    public static final String ERROR_REPCODE = "998";
    public static final String RSPCODE_CONNECTION_ERROR = "999";
    public static final int INTEGRAL_TYPE_ONLINE_TIME = 2;
    public static final int INTEGRAL_TYPE_SIGN_IN = 3;
    private static HttpHost proxy = null;
    private JSONObject jsonobj = null;
    Map<String, Object> map = new HashMap<String, Object>();
    HashMap<String, String> headermap = new HashMap();
    HashMap<String, Object> bodymap = new HashMap();
    List<HashMap<String, Object>> classInfoBodylist = new ArrayList<HashMap<String, Object>>();
    private Map<String, File> fileMap;
    private Map<File, IFileUpdateProgress> fileUpdateProgressMap = new HashMap<File, IFileUpdateProgress>();
    private static int timeout = 5000;

    static {
        if (Proxy.enable) {
            int proxtPort = Integer.valueOf(Proxy.port);
            proxy = new HttpHost(Proxy.url, proxtPort, Proxy.HTTP_TYPE);
        }
    }

    public HttpClientUtils() {
        this.fileMap = new HashMap<String, File>();
    }

    public static HttpClientUtils getInstance(String command) {
        if (!USERLOGIN_COMMADN.equals(command)) {
            timeout = 30000;
        }
        HttpClientUtils httpClientUtils = new HttpClientUtils();
        httpClientUtils.setRequestheader(command);
        return httpClientUtils;
    }

    public ResponseObj excute() {
        return this.excute(null, null, true);
    }

    public ResponseObj excute(HttpContext httpContext, HttpPost httpPost) {
        return this.excute(httpContext, httpPost, true);
    }

    public ResponseObj excute(HttpContext httpContext, HttpPost httpPost, boolean needRelogin) {
        return this.excute(httpContext, httpPost, needRelogin, true);
    }

    public ResponseObj excute(HttpContext httpContext, HttpPost httpPost, boolean needRelogin, boolean isService) {
        String rspjson = null;
        ResponseObj responseObj = null;
        try {
            rspjson = this.excuteCustomStringPost(httpContext, httpPost, isService);
        }
        catch (IOException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            responseObj = new ResponseObj();
            if (e instanceof HttpResponseException) {
                responseObj.setHttpErrorCode(((HttpResponseException)e).getStatusCode());
            }
            responseObj.setRspcode(RSPCODE_CONNECTION_ERROR);
            responseObj.setRspdesc("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
            return responseObj;
        }
        responseObj = HttpClientUtils.transeResponseObj(rspjson);
        try {
            if (needRelogin && !SUCESS_REPCODE.equals(responseObj.getRspcode())) {
                boolean b = UserAuthService.relogin();
                if (b) {
                    rspjson = this.excuteCustomStringPost(httpContext, httpPost, true);
                    responseObj = HttpClientUtils.transeResponseObj(rspjson);
                } else {
                    responseObj = new ResponseObj();
                    responseObj.setRspcode(ERROR_REPCODE);
                    responseObj.setRspdesc("\u7528\u6237\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u767b\u5f55\u5e76\u518d\u6b21\u5c1d\u8bd5");
                }
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            responseObj = new ResponseObj();
            responseObj.setRspcode(ERROR_REPCODE);
            responseObj.setRspdesc(e.getMessage());
            return responseObj;
        }
        return responseObj;
    }

    private String excuteCustomStringPost(HttpContext httpContext, HttpPost httpPost, boolean isService) throws IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            httpPost = this.prePostExcute(httpclient, httpPost, isService);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseBody = null;
            if (httpContext == null) {
                responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            } else {
                this.initHttpContext(httpclient, httpContext);
                responseBody = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler, httpContext);
            }
            if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
                System.out.println("<<<<<-------" + responseBody);
            }
            if (StringUtil.isNotBlank((String)responseBody)) {
                String string = responseBody;
                return string;
            }
        }
        catch (KeyManagementException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public ResponseObj excuteDownloadPost(HttpContext httpContext, HttpPost httpPost, File downloadFilePath, boolean keepDownloadFileName, boolean isService) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            httpPost = this.prePostExcute(httpclient, httpPost, isService);
            HttpResponse httpResponse = null;
            if (httpContext == null) {
                httpResponse = httpclient.execute((HttpUriRequest)httpPost);
            } else {
                this.initHttpContext(httpclient, httpContext);
                httpResponse = httpclient.execute((HttpUriRequest)httpPost, httpContext);
            }
            ResponseObj responseObj = HttpClientUtils.downloadFile(downloadFilePath, httpResponse, keepDownloadFileName, null);
            return responseObj;
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            ResponseObj responseObj = new ResponseObj();
            if (e instanceof HttpResponseException) {
                responseObj.setHttpErrorCode(((HttpResponseException)e).getStatusCode());
            }
            responseObj.setRspcode(RSPCODE_CONNECTION_ERROR);
            responseObj.setRspdesc("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
            ResponseObj responseObj2 = responseObj;
            return responseObj2;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    public static ResponseObj downloadFile(File downloadFilePath, HttpResponse httpResponse, boolean keepDownloadFileName, String getFileNameFromURL) throws FileNotFoundException, IOException {
        String fileName = HttpClientUtils.getHttpUrlFileName(httpResponse, getFileNameFromURL);
        if (StringUtil.isNotBlank((String)fileName)) {
            if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
                System.out.println("<<<<<-------" + Arrays.asList(httpResponse.getAllHeaders()));
            }
            if (keepDownloadFileName) {
                downloadFilePath = new File(downloadFilePath, fileName);
            }
            downloadFilePath.getParentFile().mkdirs();
            InputStream in = null;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(downloadFilePath);
                IOUtils.copy((InputStream)httpResponse.getEntity().getContent(), (OutputStream)out);
                ResponseObj responseObj = new ResponseObj();
                responseObj.setRspcode(SUCESS_REPCODE);
                responseObj.setDownloadFilename(fileName);
                ResponseObj responseObj2 = responseObj;
                return responseObj2;
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
            System.out.println("<<<<<-------" + responseBody);
        }
        ResponseObj responseObj = HttpClientUtils.transeResponseObj(responseBody);
        return responseObj;
    }

    private HttpPost prePostExcute(DefaultHttpClient httpclient, HttpPost httpPost, boolean isService) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpClientUtils.initConfig(httpclient);
        if (httpPost == null) {
            String s = this.headermap.get("command");
            String serverUrl = this.getServerUrl(s);
            httpPost = new HttpPost(serverUrl);
        }
        MultipartEntity me = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, "PANDORA", Charset.forName("UTF-8"));
        if (isService) {
            this.headermap.put("token", UserAuth.getToken());
            this.map.put("header", this.headermap);
            if (this.classInfoBodylist != null && this.classInfoBodylist.size() > 0) {
                if (this.bodymap != null && !this.bodymap.isEmpty()) {
                    this.classInfoBodylist.add(this.bodymap);
                }
                this.map.put("body", this.classInfoBodylist);
            } else {
                this.map.put("body", this.bodymap);
            }
            this.jsonobj = new JSONObject(this.map);
            StringBody sb = new StringBody(this.jsonobj.toString(), Charset.forName("UTF-8"));
            if (Platform.inDevelopmentMode() || Platform.inDebugMode()) {
                System.out.println("------->>>>>" + this.jsonobj);
            }
            me.addPart("param", (ContentBody)sb);
        } else {
            for (String name : this.bodymap.keySet()) {
                me.addPart(name, (ContentBody)new StringBody(this.bodymap.get(name).toString(), Charset.forName("UTF-8")));
            }
            if (Platform.inDevelopmentMode() || Platform.inDebugMode()) {
                System.out.println("------->>>>>" + this.bodymap);
            }
        }
        if (this.fileMap != null && !this.fileMap.isEmpty()) {
            Set<String> keySet = this.fileMap.keySet();
            for (String key : keySet) {
                if (!StringUtil.isNotBlank((String)key)) continue;
                String fileName = this.fileMap.get(key).getName();
                String mimeType = this.getMimeType(fileName);
                FileBody fb = null;
                fb = this.fileUpdateProgressMap != null && this.fileUpdateProgressMap.get(this.fileMap.get(key)) != null ? new FileBodyUpdateProgress(this.fileMap.get(key), mimeType, "UTF-8", this.fileUpdateProgressMap.get(this.fileMap.get(key))) : new FileBody(this.fileMap.get(key), mimeType, "UTF-8");
                me.addPart(key, (ContentBody)fb);
            }
        }
        httpPost.setEntity((HttpEntity)me);
        return httpPost;
    }

    public static void initConfig(DefaultHttpClient httpclient) throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx);
        ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = httpclient.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", (SocketFactory)ssf, 443));
        if (proxy != null && Proxy.enable) {
            httpclient = HttpClientUtils.setProxy(httpclient);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        HttpParams httpParams = httpclient.getParams();
        httpParams.setParameter("http.connection.timeout", (Object)timeout);
        httpParams.setParameter("http.socket.timeout", (Object)30000);
        httpParams.setParameter("http.protocol.content-charset", (Object)"UTF-8");
        httpParams.setParameter("http.protocol.element-charset", (Object)"UTF-8");
    }

    public ResponseObj excuteGet() {
        ResponseObj responseObj = null;
        String rspjson = null;
        try {
            rspjson = this.excuteCustomStringGet();
        }
        catch (IOException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            responseObj = new ResponseObj();
            if (e instanceof HttpResponseException) {
                responseObj.setHttpErrorCode(((HttpResponseException)e).getStatusCode());
            }
            responseObj.setRspcode(RSPCODE_CONNECTION_ERROR);
            responseObj.setRspdesc("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
            return responseObj;
        }
        responseObj = HttpClientUtils.transeResponseObj(rspjson);
        return responseObj;
    }

    private String excuteCustomStringGet() throws IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpClientUtils.initConfig(httpclient);
            String s = this.headermap.get("command");
            String serverUrl = this.getServerUrl(s);
            if (!this.bodymap.isEmpty()) {
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                for (String key : this.bodymap.keySet()) {
                    Object result = this.bodymap.get(key);
                    if (!(result instanceof String)) continue;
                    parameters.add(new BasicNameValuePair(key, (String)result));
                }
                serverUrl = String.valueOf(serverUrl) + "?" + URLEncodedUtils.format(parameters, (String)"utf-8");
            }
            HttpGet httpGet = new HttpGet(serverUrl);
            if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
                System.out.println("------->>>>>" + serverUrl);
            }
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String responseStr = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
                System.out.println("<<<<<-------" + responseStr);
            }
            String string = responseStr;
            return string;
        }
        catch (KeyManagementException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    private static ResponseObj transeResponseObj(String jsonstring) {
        ResponseObj responseObj = new ResponseObj();
        try {
            HashMap<String, Object> bodymap = new HashMap<String, Object>();
            JSONObject jsonobject = new JSONObject(jsonstring);
            JSONObject headermap = jsonobject.optJSONObject("header");
            if (headermap != null) {
                String token = headermap.optString("token");
                String command = headermap.optString("command");
                JSONObject resultmap = headermap.optJSONObject("result");
                String rspcode = resultmap.optString("rspcode");
                String rspdesc = resultmap.optString("rspdesc");
                JSONObject bodyjson = jsonobject.optJSONObject("body");
                if (bodyjson != null) {
                    bodymap.put("body", bodyjson);
                    if (SUCESS_REPCODE.equals(rspcode) && bodyjson.has("spw") && bodyjson.has("token")) {
                        bodymap.put("spw", bodyjson.opt("spw"));
                        bodymap.put("token", bodyjson.opt("token"));
                    }
                }
                responseObj.setCommap(bodymap);
                responseObj.setCommand(command);
                responseObj.setRspcode(rspcode);
                responseObj.setRspdesc(rspdesc);
                responseObj.setToken(token);
                jsonobject.clear();
            } else {
                responseObj.setRspcode(SUCESS_REPCODE);
                responseObj.getCommap().put("body", jsonobject);
            }
        }
        catch (JSONException e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
        }
        return responseObj;
    }

    public HttpPost createHttpPost() {
        String s = this.headermap.get("command");
        String serverUrl = this.getServerUrl(s);
        return new HttpPost(serverUrl);
    }

    public static DefaultHttpClient createHttpsClient() {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpclient.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
            httpclient = new DefaultHttpClient(ccm, httpclient.getParams());
            return httpclient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initHttpContext(DefaultHttpClient httpclient, HttpContext httpContext) {
        httpContext.setAttribute("http.scheme-registry", (Object)httpclient.getConnectionManager().getSchemeRegistry());
        httpContext.setAttribute("http.authscheme-registry", (Object)httpclient.getAuthSchemes());
        httpContext.setAttribute("http.cookiespec-registry", (Object)httpclient.getCookieSpecs());
        httpContext.setAttribute("http.cookie-store", (Object)httpclient.getCookieStore());
        httpContext.setAttribute("http.auth.credentials-provider", (Object)httpclient.getCredentialsProvider());
    }

    private String getMimeType(String fileName) {
        String mimeType = "text/";
        if (StringUtil.isNotBlank((String)fileName)) {
            int index = fileName.lastIndexOf(".");
            if (index > -1) {
                String extend = fileName.substring(index + 1);
                if (StringUtil.contains((String[])CoreActivator.imageExtensions, (String)extend)) {
                    mimeType = "image/";
                }
                mimeType = String.valueOf(mimeType) + extend;
            } else {
                mimeType = String.valueOf(mimeType) + "unknow";
            }
        }
        return mimeType;
    }

    private static DefaultHttpClient setProxy(DefaultHttpClient httpclient) {
        if (StringUtil.isNotBlank((String)Proxy.username)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(Proxy.username, Proxy.password);
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)creds);
            httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return httpclient;
    }

    public void setRequestheader(String command) {
        if (command != null) {
            this.headermap.put("token", UserAuth.getToken());
            this.headermap.put("command", command);
        }
    }

    public void addRequestheader(String key, String value) {
        this.headermap.put(key, value);
    }

    public void addRequestBody(Map<String, String> map) {
        this.bodymap.putAll(map);
    }

    public void addRequestBody(String key, String value) {
        this.bodymap.put(key, value);
    }

    public void addRequestBody(String key, Object value) {
        this.bodymap.put(key, value);
    }

    public <T> void addClassInfoRequestBody(Class<T> obj, List<T> list) {
        Field[] field = obj.getDeclaredFields();
        if (list == null || list.size() < 1 || field == null) {
            return;
        }
        int fieldLength = field.length;
        int i = 0;
        while (i < list.size()) {
            T t = list.get(i);
            if (t != null) {
                HashMap<String, String> tmpmap = new HashMap<String, String>();
                tmpmap.put("type", obj.getSimpleName());
                int j = 0;
                while (j < fieldLength) {
                    String key = field[j].getName();
                    if (StringUtil.isNotBlank((String)key)) {
                        try {
                            String fileValue = BeanUtils.getProperty(t, (String)key);
                            if (StringUtil.isBlank((String)fileValue)) {
                                fileValue = "";
                            }
                            if (fileValue.indexOf("\r\n") > 0) {
                                fileValue = fileValue.replace("\r\n", " \\ \r\n");
                                fileValue = "\\" + fileValue;
                            } else if (fileValue.indexOf("\n") > 0) {
                                fileValue = fileValue.replace("\n", " \\ \n");
                                fileValue = "\\" + fileValue;
                            }
                            tmpmap.put(key, fileValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    ++j;
                }
                this.classInfoBodylist.add(tmpmap);
            }
            ++i;
        }
    }

    private String getServerUrl(String key) {
        if (key.equals(USERLOGIN_COMMADN)) {
            return UserAuthHelper.getPreferenceString("USER_LOGIN");
        }
        if (key.equals(USERREG_COMMADN)) {
            return UserAuthHelper.getPreferenceString("USER_REGISTER");
        }
        if (key.equals(PACKAGESTATUS_COMMADN)) {
            return UserAuthHelper.getPreferenceString("PACKAGE_HISTORY_URL");
        }
        if (key.equals(CLEARPACKAGESTATUS_COMMADN)) {
            return UserAuthHelper.getPreferenceString("CLEAR_PACKAGE_HISTORY_URL_KEY");
        }
        if (key.equals(GENERATEAPPPACKAGE_COMMADN)) {
            return UserAuthHelper.getPreferenceString("PACKAGE_SUBMIT_URL");
        }
        if (key.equals(CANCELAPPPACKAGE_COMMADN)) {
            return UserAuthHelper.getPreferenceString("PACKAGE_CANCEL_URL");
        }
        if (key.equals(DOWNLOADPACKAGE_COMMADN)) {
            return UserAuthHelper.getPreferenceString("PACKAGE_DOWNLOAD_URL");
        }
        if (key.equals(ACTION_COMMADN)) {
            return UserAuthHelper.getPreferenceString("PACKAGE_ACTION_URL");
        }
        if (key.equals(FORGETPASSWORD_COMMADN)) {
            return UserAuthHelper.getPreferenceString("USER_FORGET");
        }
        if (key.equals(APPLYPROJECT_COMMADN)) {
            return UserAuthHelper.getPreferenceString("APP_CREATE_URL");
        }
        if (key.equals(STATS_COMMADN)) {
            return UserAuthHelper.getPreferenceString("LOG_URL");
        }
        if (key.equals(FEEDBACK_COMMADN)) {
            return UserAuthHelper.getPreferenceString("FEEDBACK_URL");
        }
        if (key.equals("INTEGRAL_URL")) {
            return UserAuthHelper.getPreferenceString("INTEGRAL_URL");
        }
        if (key.equals("SCORE_URL")) {
            return UserAuthHelper.getPreferenceString("SCORE_URL");
        }
        if (key.equals("FORGET_URL")) {
            return UserAuthHelper.getPreferenceString("FORGET_URL");
        }
        if (key.equals(EVENTCHECK_COMMADN)) {
            return UserAuthHelper.getPreferenceString("EVENTCHECK_URL");
        }
        if (key.equals(EVENTPOLLING_COMMADN)) {
            return UserAuthHelper.getPreferenceString("EVENTPOLLING_URL");
        }
        if (key.equals(STREAMAPPVERSION_COMMADN)) {
            return UserAuthHelper.getPreferenceString("STREAMAPPVERSION_URL");
        }
        if (key.equals(STREAMAPPPUBLISH_COMMADN)) {
            return UserAuthHelper.getPreferenceString("STREAMAPPPUBLISH_URL");
        }
        if (key.equals(STREAMAPPCHECKOWNER_COMMADN)) {
            return UserAuthHelper.getPreferenceString("STREAMAPPCHECKOWNER_URL");
        }
        if (key.equals(CONFUSIONWGT_COMMADN)) {
            return UserAuthHelper.getPreferenceString("CONFUSIONWGT_URL");
        }
        if (key.equals(KUAIMAGENERATE_COMMADN)) {
            return UserAuthHelper.getPreferenceString("KUAIMAGENERATE_URL");
        }
        if (key.equals(KUAIMAGET_COMMADN)) {
            return UserAuthHelper.getPreferenceString("KUAIMAGET_URL");
        }
        return "";
    }

    public void addFileBody(String key, File file) {
        if (StringUtil.isNotBlank((String)key) && file != null) {
            this.fileMap.put(key, file);
        }
    }

    public void addFileBody(String key, File file, IFileUpdateProgress updateFileProgress) {
        if (StringUtil.isNotBlank((String)key) && file != null) {
            this.fileMap.put(key, file);
            if (updateFileProgress != null) {
                this.fileUpdateProgressMap.put(file, updateFileProgress);
            }
        }
    }

    public String getScore() {
        if (StringUtil.isBlank((String)UserAuth.getToken())) {
            return "--";
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpGet = new HttpGet();
            List<BasicNameValuePair> parameters = Arrays.asList(new BasicNameValuePair("token", UserAuth.getToken()));
            String str = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(parameters));
            httpGet.setURI(new URI(String.valueOf(this.getServerUrl("SCORE_URL")) + "?" + str));
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            if (proxy != null && Proxy.enable) {
                httpclient = HttpClientUtils.setProxy(httpclient);
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            HttpParams httpParams = httpclient.getParams();
            httpParams.setParameter("http.connection.timeout", (Object)timeout);
            httpParams.setParameter("http.socket.timeout", (Object)30000);
            httpParams.setParameter("http.protocol.content-charset", (Object)"UTF-8");
            httpParams.setParameter("http.protocol.element-charset", (Object)"UTF-8");
            if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
                System.out.println("Integral ------->>>>>" + httpGet.getURI());
            }
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            if (Platform.inDebugMode() || Platform.inDevelopmentMode()) {
                System.out.println("Integral <<<<<-------" + responseBody);
            }
            if (StringUtil.isNotBlank((String)responseBody)) {
                JSONObject jsonobject = new JSONObject(responseBody);
                if (jsonobject.containsKey((Object)"code") && "10000".equals(jsonobject.getString("code"))) {
                    int score = (Integer)jsonobject.get("score");
                    String string = String.valueOf(score);
                    return string;
                }
                return "--";
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            return "--";
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return "--";
    }

    public boolean postIntegralData(int type) throws ConnectionException {
        if (StringUtil.isBlank((String)UserAuth.getToken())) {
            return false;
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            JSONObject jsonobject;
            HttpGet httpGet = new HttpGet();
            List<BasicNameValuePair> parameters = Arrays.asList(new BasicNameValuePair("token", UserAuth.getToken()), new BasicNameValuePair("type", String.valueOf(type)));
            String str = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(parameters));
            httpGet.setURI(new URI(String.valueOf(this.getServerUrl("INTEGRAL_URL")) + "?" + str));
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            if (proxy != null && Proxy.enable) {
                httpclient = HttpClientUtils.setProxy(httpclient);
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            HttpParams httpParams = httpclient.getParams();
            httpParams.setParameter("http.connection.timeout", (Object)timeout);
            httpParams.setParameter("http.socket.timeout", (Object)30000);
            httpParams.setParameter("http.protocol.content-charset", (Object)"UTF-8");
            httpParams.setParameter("http.protocol.element-charset", (Object)"UTF-8");
            if (Platform.inDevelopmentMode() || Platform.inDebugMode()) {
                System.out.println("Integral ------->>>>>" + httpGet.getURI());
            }
            String responseBody = (String)httpclient.execute((HttpUriRequest)httpGet, (ResponseHandler)responseHandler);
            if (Platform.inDevelopmentMode() || Platform.inDebugMode()) {
                System.out.println("Integral <<<<<-------" + responseBody);
            }
            if (StringUtil.isNotBlank((String)responseBody) && (jsonobject = new JSONObject(responseBody)).containsKey((Object)"code") && "10000".equals(jsonobject.getString("code"))) {
                return true;
            }
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage());
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return false;
    }

    public static String getHttpUrlFileName(HttpResponse http) {
        Header head = http.getFirstHeader("Content-Disposition");
        String filename = null;
        if (head != null && StringUtil.isNotBlank((String)head.getValue())) {
            filename = head.getValue().substring(head.getValue().indexOf("filename") + 10, head.getValue().length() - 1);
        }
        return filename;
    }

    public static String getHttpUrlFileName(HttpResponse http, String url) {
        int index;
        String filename = HttpClientUtils.getHttpUrlFileName(http);
        if (StringUtil.isBlank((String)filename) && StringUtil.isNotBlank((String)url) && (index = url.replace("\\", "/").lastIndexOf("/")) < url.length() - 1) {
            index = index < 0 ? 0 : index + 1;
            filename = url.substring(index);
        }
        return filename;
    }

    private class FileBodyUpdateProgress
    extends FileBody {
        private IFileUpdateProgress fileUpdateProgress;

        public FileBodyUpdateProgress(File file, String mimeType, String charset, IFileUpdateProgress fileUpdateProgress) {
            super(file, mimeType, charset);
            this.fileUpdateProgress = fileUpdateProgress;
        }

        public void writeTo(OutputStream out) throws IOException {
            InputStream in = super.getInputStream();
            try {
                try {
                    byte[] tmp = new byte[4096];
                    long contentLength = this.getContentLength();
                    long progress = 0L;
                    int len = 0;
                    while ((len = in.read(tmp)) != -1) {
                        out.write(tmp, 0, len);
                        this.fileUpdateProgress.update(contentLength, progress += (long)len);
                    }
                    out.flush();
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
                    in.close();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

