/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.appstream;

import com.google.gson.annotations.Expose;
import com.pandora.core.utils.CollectionsUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class RelationTree {
    @Expose
    private URI path = null;
    @Expose
    private List<RelationTree> children;
    private RelationTree parent = null;
    private Collection<String> containStrings;
    private Map<String, String> basePaths;
    private boolean link = false;
    private Collection<String> subPages;

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isLink() {
        return this.link;
    }

    public RelationTree(URI path) {
        this.path = path;
    }

    public void addString(String str) {
        if (this.containStrings == null) {
            this.containStrings = new HashSet<String>();
        }
        this.containStrings.add(str);
    }

    public void addSubPage(String subPage) {
        if (this.subPages == null) {
            this.subPages = new HashSet<String>();
        }
        this.subPages.add(subPage);
    }

    public Collection<String> getSubPages() {
        return this.subPages;
    }

    public Collection<String> getContainStrings() {
        return this.containStrings;
    }

    public String getBasePath(String key) {
        if (this.basePaths == null) {
            return "";
        }
        return this.basePaths.get(key);
    }

    public void addChild(RelationTree child) {
        if (this.children == null) {
            this.children = new ArrayList<RelationTree>();
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setParent(this);
        }
    }

    public RelationTree getParent() {
        return this.parent;
    }

    public void setParent(RelationTree parent) {
        this.parent = parent;
    }

    public boolean isPageView() {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(this.path.getPath());
        return contentType != null && "com.aptana.contenttype.html".equals(contentType.getId());
    }

    public boolean isContainer() {
        return this.path != null && (this.isPageView() || this.path.getPath().toLowerCase().endsWith(".css"));
    }

    public boolean hasChildren() {
        return CollectionsUtil.isNotEmpty(this.children);
    }

    public RelationTree getContainer() {
        RelationTree container = this;
        while (!container.isContainer()) {
            if (container.getParent() == null) break;
            container = container.getParent();
        }
        return container;
    }

    public URI getPath() {
        return this.path;
    }

    public List<RelationTree> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        String name = this.getPath().toString().toLowerCase();
        return !this.isContainer() && !name.endsWith(".js");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationTree other = (RelationTree)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return this.path == null ? "" : this.path.toString();
    }

    public void registerBasePath(String key, String basePath) {
        if (this.basePaths == null) {
            this.basePaths = new HashMap<String, String>();
        }
        this.basePaths.put(key, basePath);
    }
}

