/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.appstream;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.CoreActivator;
import com.pandora.core.appstream.ASTParseManager;
import com.pandora.core.appstream.AppStream;
import com.pandora.core.appstream.IASTParser;
import com.pandora.core.appstream.IAppStreamBuilder;
import com.pandora.core.appstream.Idle;
import com.pandora.core.appstream.Page;
import com.pandora.core.appstream.RelationTree;
import com.pandora.core.log.HBLog;
import com.pandora.core.project.HMobileConvertor;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.RegistryUtils;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IDocument;

public class AppStreamFileBuilder {
    private static final Pattern cssUrlPattern = Pattern.compile("url\\(([^\\(\\)])*\\)");
    private static final Pattern urlPattern = Pattern.compile("((/.*/)|(/)|(.*))[\\.]{1}([a-zA-Z0-9]+$)");
    private static final QualifiedName APPSTREAM_EXPIRED_QUALIFIED_NAME = new QualifiedName("com.pandora.core", "hasAlertAppstreamFileIsExpired");
    private Set<File> unpackageSet;

    public Set<File> getUnpackageList() {
        return this.unpackageSet;
    }

    public void setUnpackageList(ArrayList<String> unpackageList, IProject project) {
        if (CollectionsUtil.isEmpty(unpackageList)) {
            return;
        }
        this.unpackageSet = new HashSet<File>();
        for (String unpackage : unpackageList) {
            this.unpackageSet.add(project.getLocation().append(unpackage).toFile());
        }
    }

    private static IAppStreamBuilder getBuilder() {
        try {
            List<IAppStreamBuilder> builds = RegistryUtils.getEp(IAppStreamBuilder.class, "com.pandora.core.appstream.builder", "builder", "class");
            if (CollectionsUtil.isNotEmpty(builds)) {
                return builds.get(0);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new IAppStreamBuilder(){

            @Override
            public void buildAppStreamFile2Manifest(HMobileProject hMobile) {
            }

            @Override
            public boolean isNeedUserConfirm() {
                return false;
            }

            @Override
            public IStatus prePublishCheck(HMobileProject hMobile, Dialog dialog) {
                return Status.CANCEL_STATUS;
            }

            @Override
            public String checkDuplicateKey(IFile manifest, IDocument document) {
                return document != null ? document.get() : null;
            }
        };
    }

    public Map build(HMobileProject hMobile, IProgressMonitor monitor) throws Exception {
        return this.build(hMobile, monitor, false);
    }

    public Map build(HMobileProject hMobile, IProgressMonitor monitor, boolean isAutoUpdate) throws Exception {
        if (isAutoUpdate) {
            monitor.beginTask("\u6b63\u5728\u91cd\u65b0\u751f\u6210\u9875\u9762\u5f15\u7528\u5173\u7cfb...", 100);
        } else {
            monitor.beginTask("\u6b63\u5728\u521d\u59cb\u5316\u9875\u9762\u5f15\u7528\u5173\u7cfb\uff0c\u8bf7\u7a0d\u5019...", 100);
        }
        if (hMobile.getAppConfig() == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u914d\u7f6e\u6587\u4ef6manifest.json");
        }
        String launchPath = hMobile.getAppConfig().getLaunch_path();
        if (StringUtil.isEmpty((String)launchPath)) {
            throw new RuntimeException("App\u5165\u53e3\u9875\u9762\u6ca1\u6709\u914d\u7f6e\uff01");
        }
        IProject project = hMobile.getProject();
        IFile launchFile = project.getFile(launchPath);
        if (!launchFile.exists()) {
            throw new RuntimeException("\u5165\u53e3\u9875\u9762\u5bf9\u5e94\u7684\u8d44\u6e90\u5728\u9879\u76ee\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        RelationTree root = new RelationTree(launchFile.getLocationURI());
        HashSet<URI> visitedUris = new HashSet<URI>();
        monitor.worked(5);
        this.processRelationTree(launchFile, root, project, visitedUris, true, monitor);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(85);
        AppStream appStream = new AppStream();
        this.generateAppStream(root, appStream, project, 0, true);
        monitor.worked(90);
        Idle idle = this.queryIdleResources(appStream, project);
        appStream.setIdle(idle);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.worked(95);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)appStream);
        Map map = (Map)gson.fromJson(json, LinkedHashMap.class);
        if (monitor.isCanceled()) {
            return null;
        }
        return map;
    }

    public boolean hasAlertAppstreamFileIsExpired(HMobileProject hMobile) {
        boolean hasAlert = false;
        try {
            hasAlert = Boolean.parseBoolean(hMobile.getProject().getPersistentProperty(APPSTREAM_EXPIRED_QUALIFIED_NAME));
        }
        catch (CoreException ex) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)ex);
        }
        return hasAlert;
    }

    public void setAlertAppstreamFileIsExpired(HMobileProject hMobile, boolean hasAlert) {
        try {
            hMobile.getProject().setPersistentProperty(APPSTREAM_EXPIRED_QUALIFIED_NAME, String.valueOf(hasAlert));
        }
        catch (CoreException ex) {
            HBLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)ex);
        }
    }

    public void buildAppStreamFile2Manifest(HMobileProject hMobile) {
        if (hMobile == null) {
            return;
        }
        IFile streamFile = hMobile.getProject().getFile("appstream.json");
        if (streamFile.exists() && !this.hasAlertAppstreamFileIsExpired(hMobile)) {
            AppStreamFileBuilder.getBuilder().buildAppStreamFile2Manifest(hMobile);
            this.setAlertAppstreamFileIsExpired(hMobile, true);
        }
    }

    public boolean isNeedUserConfirm(HMobileProject hMobile) {
        return AppStreamFileBuilder.getBuilder().isNeedUserConfirm();
    }

    public IStatus prePublishCheck(HMobileProject hMobile, Dialog dialog) {
        return AppStreamFileBuilder.getBuilder().prePublishCheck(hMobile, dialog);
    }

    public boolean isExistsDependencies(HMobileProject hMobile) {
        IProject project = hMobile.getProject();
        IFile configFile = project.getFile("manifest.json");
        if (configFile == null) {
            return false;
        }
        Gson gson = StreamJsonUtil.createGson();
        String content = StreamJsonUtil.getContents((IFile)configFile);
        Map maniFestJSonMap = AppStreamFileBuilder.jsonToMap(configFile, gson, StreamJsonUtil.createDocument((String)content));
        return maniFestJSonMap.containsKey("dependencies");
    }

    public void buildFromManiFest(HMobileProject hMobile, File file) throws IOException {
        String content = this.buildFromManiFest(hMobile);
        file.getParentFile().mkdirs();
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)Charset.forName("UTF-8"));
    }

    public String buildFromManiFest(HMobileProject hMobile) {
        ArrayList launchreferList;
        String content;
        Map msJSonMap;
        IProject project = hMobile.getProject();
        IFile configFile = project.getFile("manifest.json");
        if (configFile == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u4e3b\u914d\u7f6e\u6587\u4ef6manifest.json");
        }
        String launchPath = hMobile.getAppConfig().getLaunch_path();
        if (StringUtil.isBlank((String)launchPath)) {
            throw new RuntimeException("\u5165\u53e3\u9875\u9762\u6ca1\u6709\u914d\u7f6e\uff01");
        }
        IFile launchFile = project.getFile(launchPath);
        if (!launchFile.exists()) {
            throw new RuntimeException("\u5165\u53e3\u9875\u9762\u4e0d\u5b58\u5728\uff01");
        }
        Gson gson = StreamJsonUtil.createGson();
        Map maniFestJSonMap = (Map)gson.fromJson(gson.toJson((Object)(msJSonMap = (Map)gson.fromJson(content = StreamJsonUtil.getContents((IFile)configFile), Map.class))), Map.class);
        Map dependMap = (Map)maniFestJSonMap.get("dependencies");
        if (dependMap == null) {
            throw new RuntimeException("dependencies\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        Map pageMap = (Map)dependMap.get("pages");
        if (pageMap == null) {
            throw new RuntimeException("pages\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        Map launchPathMap = (Map)pageMap.get(launchPath);
        if (launchPathMap == null) {
            throw new RuntimeException("\u5165\u53e3\u9875\u9762\u5f15\u7528\u5173\u7cfb\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        this.setUnpackageList((ArrayList)maniFestJSonMap.get("unpackage"), project);
        this.processIndex(dependMap, project);
        Map idleMap = this.queryIdleResources(dependMap, project);
        HashSet<String> launchResourceSet = new HashSet<String>();
        HashSet<String> launchReferceSet = new HashSet<String>();
        launchResourceSet.add("manifest.json");
        ArrayList launchResourceList = (ArrayList)launchPathMap.get("resources");
        if (!CollectionsUtil.isEmpty((Collection)launchResourceList)) {
            launchResourceSet.addAll(launchResourceList);
        }
        if (!CollectionsUtil.isEmpty((Collection)(launchreferList = (ArrayList)launchPathMap.get("refer")))) {
            launchReferceSet.addAll(launchreferList);
        }
        HashSet<String> visitor = new HashSet<String>();
        this.processLaunchResourcesAndRefers(pageMap, launchResourceSet, launchReferceSet, launchResourceList, visitor);
        Object[] launchResources = launchResourceSet.toArray(new String[launchResourceSet.size()]);
        launchResourceList = (ArrayList)CollectionsUtil.newList((Object[])launchResources);
        launchPathMap.put("resources", launchResourceList);
        Object[] launchRefers = launchReferceSet.toArray(new String[launchReferceSet.size()]);
        launchreferList = (ArrayList)CollectionsUtil.newList((Object[])launchRefers);
        launchPathMap.put("refer", launchreferList);
        AppStream appStream = new AppStream();
        appStream.setProtocol(new String[]{"http", "https"});
        appStream.setUrl("");
        appStream.setVersion(hMobile.getAppConfig().getVersion().getName());
        HashSet<String> referSet = new HashSet<String>();
        appStream.setMain(this.getPage(project, launchPathMap, launchPath, referSet));
        LinkedHashMap<String, Page> pages = new LinkedHashMap<String, Page>();
        Set keySet = pageMap.keySet();
        keySet.remove(launchPath);
        for (String key : keySet) {
            Map pMap = (Map)pageMap.get(key);
            if (pMap == null || !this.checkResourceExist(project, key)) continue;
            pages.put(key, this.getPage(project, pMap, key, referSet));
        }
        for (String refer : referSet) {
            if (keySet.contains(refer)) continue;
            this.setPage(pages, refer);
        }
        appStream.setPages(pages);
        if (idleMap != null) {
            ArrayList idleList = (ArrayList)idleMap.get("resources");
            HashSet<String> tempSet = new HashSet<String>();
            if (CollectionsUtil.isNotEmpty((Collection)idleList)) {
                AppStream as = new AppStream();
                for (String idle : idleList) {
                    if (!this.isPageView(idle)) continue;
                    if (!pageMap.containsKey(idle)) {
                        IFile idFile = project.getFile(idle);
                        if (!idFile.exists()) continue;
                        RelationTree root = new RelationTree(idFile.getLocationURI());
                        HashSet<URI> visitedUris = new HashSet<URI>();
                        this.processRelationTree(idFile, root, project, visitedUris, false, (IProgressMonitor)new NullProgressMonitor());
                        this.generateAppStream(root, as, project, 0, true);
                    }
                    tempSet.add(idle);
                }
                idleList.removeAll(tempSet);
                Map<String, Page> asPagesMap = as.getPages();
                if (asPagesMap != null && !asPagesMap.isEmpty()) {
                    Set<String> askeys = asPagesMap.keySet();
                    for (String key : askeys) {
                        if (StringUtil.isBlank((String)key)) continue;
                        Page asPage = asPagesMap.get(key);
                        if (!pages.containsKey(key)) {
                            pages.put(key, asPage);
                        }
                        Object[] pRes = asPage.getResources();
                        Object[] pRef = asPage.getRefer();
                        idleList.removeAll(CollectionsUtil.newList((Object[])pRes));
                        idleList.removeAll(CollectionsUtil.newList((Object[])pRef));
                    }
                }
                idleMap.put("resources", idleList);
            }
            appStream.setIdle(this.getIdle(project, idleMap));
        }
        this.filterStreamResources(appStream);
        return StreamJsonUtil.toJson((Gson)gson, (Object)appStream);
    }

    public void setPage(Map<String, Page> pages, String refer) {
        Page page = this.createPage(refer);
        pages.put(refer, page);
    }

    public Page createPage(String refer) {
        Page page = new Page();
        page.setHref(refer);
        page.setPriority(0);
        return page;
    }

    public boolean isPageView(String fileName) {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
        return contentType != null && "com.aptana.contenttype.html".equals(contentType.getId());
    }

    public Idle getIdle(IProject project, Map idleMap) {
        Idle idle = new Idle();
        ArrayList idleList = (ArrayList)idleMap.get("resources");
        if (!CollectionsUtil.isEmpty((Collection)idleList)) {
            HashSet<String> tmp = new HashSet<String>();
            for (String idleStr : idleList) {
                if (this.checkResourceExist(project, idleStr)) continue;
                tmp.add(idleStr);
            }
            idleList.removeAll(tmp);
            idle.setResources(idleList.toArray(new String[idleList.size()]));
        }
        return idle;
    }

    public Page getPage(IProject project, Map pMap, String href, Set<String> referSet) {
        Page page = new Page();
        page.setResources(this.getResources(project, "resources", pMap, referSet));
        page.setRefer(this.getResources(project, "refer", pMap, referSet));
        page.setHref(href);
        page.setPriority(this.getPripority(pMap));
        return page;
    }

    public boolean checkResourceExist(IProject project, String url) {
        if (project == null || StringUtil.isBlank((String)url)) {
            return false;
        }
        IFile file = project.getFile(url);
        return file.exists();
    }

    public String[] getResources(IProject project, String key, Map map, Set<String> referSet) {
        ArrayList rsList = (ArrayList)map.get(key);
        if (rsList == null) {
            rsList = new ArrayList();
        }
        HashSet<String> tmp = new HashSet<String>();
        for (String rs : rsList) {
            if (this.checkResourceExist(project, rs)) continue;
            tmp.add(rs);
        }
        rsList.removeAll(tmp);
        if ("refer".equals(key)) {
            referSet.addAll(rsList);
        }
        return rsList.toArray(new String[rsList.size()]);
    }

    public int getPripority(Map launchPathMap) {
        int p = 0;
        Object o = launchPathMap.get("priority");
        if (o != null) {
            p = ((Double)launchPathMap.get("priority")).intValue();
        }
        return p;
    }

    public void processLaunchResourcesAndRefers(Map pageMap, Set<String> launchResourceSet, Set<String> launchReferceSet, ArrayList<String> launchResourceList, HashSet<String> visitor) {
        if (CollectionsUtil.isEmpty(launchResourceList)) {
            return;
        }
        for (String resource : launchResourceList) {
            ArrayList resourceList;
            if (visitor.contains(resource)) continue;
            visitor.add(resource);
            Map resourceMap = (Map)pageMap.get(resource);
            if (resourceMap == null || resourceMap.isEmpty()) continue;
            ArrayList referList = (ArrayList)resourceMap.get("refer");
            if (!CollectionsUtil.isEmpty((Collection)referList)) {
                launchReferceSet.addAll(referList);
            }
            if (!CollectionsUtil.isEmpty((Collection)(resourceList = (ArrayList)resourceMap.get("resources")))) {
                launchResourceSet.addAll(resourceList);
                this.processLaunchResourcesAndRefers(pageMap, launchResourceSet, launchReferceSet, resourceList, visitor);
            }
            pageMap.remove(resource);
        }
    }

    protected void filterStreamResources(AppStream appStream) {
        Page main = appStream.getMain();
        if (main != null && main.getResources() != null) {
            HashSet<String> mainResources = new HashSet<String>();
            mainResources.addAll(Arrays.asList(main.getResources()));
            for (Page page : appStream.getPages().values()) {
                ArrayList<String> reslist = new ArrayList<String>();
                if (page.getResources() == null) continue;
                String[] stringArray = page.getResources();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String resource = stringArray[n2];
                    if (!mainResources.contains(resource)) {
                        reslist.add(resource);
                    }
                    ++n2;
                }
                page.setResources(reslist.toArray(new String[reslist.size()]));
            }
        }
    }

    public Map queryIdleResources(Map streamMap, IProject project) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)streamMap);
        AppStream stream = (AppStream)gson.fromJson(json, AppStream.class);
        Idle idle = this.queryIdleResources(stream, project);
        if (idle != null) {
            String idleJson = gson.toJson((Object)idle);
            return (Map)gson.fromJson(idleJson, Map.class);
        }
        return null;
    }

    public void processIndex(Map streamMap, IProject project) {
        try {
            Map pageMap;
            HMobileProject hMobile;
            String launchPath;
            String index = "index";
            if (!streamMap.containsKey(index) && StringUtil.isNotBlank((String)(launchPath = (hMobile = HMobileConvertor.convert(project)).getAppConfig().getLaunch_path())) && (pageMap = (Map)streamMap.get("pages")) != null) {
                streamMap.put(index, pageMap.get(launchPath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Idle queryIdleResources(AppStream appStream, IProject project) {
        Idle idleNode = new Idle();
        try {
            final HashSet allAppFiles = new HashSet();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getName().startsWith(".")) {
                        return false;
                    }
                    if (!CollectionsUtil.isEmpty(AppStreamFileBuilder.this.getUnpackageList())) {
                        File file = resource.getLocation().toFile();
                        if (AppStreamFileBuilder.this.getUnpackageList().contains(file)) {
                            return false;
                        }
                    }
                    if (resource instanceof IContainer) {
                        return !(resource.getParent() instanceof IProject) || !"unpackage".equals(resource.getName());
                    }
                    if (resource instanceof IFile) {
                        allAppFiles.add(resource.getProjectRelativePath().toString());
                    }
                    return false;
                }
            });
            ArrayList<Page> pages = new ArrayList<Page>();
            if (appStream.getMain() != null) {
                pages.add(appStream.getMain());
            }
            if (CollectionsUtil.isNotEmpty(appStream.getPages())) {
                pages.addAll(appStream.getPages().values());
            }
            HashSet<String> appStreamFiles = new HashSet<String>();
            appStreamFiles.addAll(appStream.getPages().keySet());
            for (Page page : pages) {
                appStreamFiles.add(page.getHref());
                if (page.getResources() != null) {
                    appStreamFiles.addAll(Arrays.asList(page.getResources()));
                }
                if (page.getRefer() == null) continue;
                appStreamFiles.addAll(Arrays.asList(page.getRefer()));
            }
            allAppFiles.remove(".project");
            allAppFiles.remove("manifest.json");
            allAppFiles.remove("appstream.json");
            HashSet<String> idleFiles = new HashSet<String>();
            for (String idle : allAppFiles) {
                if (appStreamFiles.contains(idle)) continue;
                idleFiles.add(idle);
            }
            if (CollectionsUtil.isNotEmpty(idleFiles)) {
                HashSet<String> filterIdleFiles = new HashSet<String>();
                for (String idleFile : idleFiles) {
                    if (!idleFile.startsWith("appstream@") || !idleFile.endsWith(".bak.json")) continue;
                    filterIdleFiles.add(idleFile);
                }
                idleFiles.removeAll(filterIdleFiles);
                idleNode.setResources(idleFiles.toArray(new String[idleFiles.size()]));
                return idleNode;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return idleNode;
    }

    protected void generateAppStream(RelationTree root, AppStream appStream, IProject project, int priority, boolean main) {
        URI baseUri = project.getLocationURI();
        Page page = new Page();
        page.setPriority(priority);
        page.setHref(baseUri.relativize(root.getPath()).toString());
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<String> refers = new ArrayList<String>();
        if (root.hasChildren()) {
            for (RelationTree child : root.getChildren()) {
                String resourcePath;
                if (!child.isPageView()) {
                    resourcePath = baseUri.relativize(child.getPath()).toString();
                    resources.add(resourcePath);
                    this.collectResources(child, resources, baseUri);
                    continue;
                }
                resourcePath = baseUri.relativize(child.getPath()).toString();
                if (root.getSubPages() != null && root.getSubPages().contains(resourcePath)) {
                    resources.add(resourcePath);
                } else {
                    refers.add(resourcePath);
                }
                this.generateAppStream(child, appStream, project, priority++, false);
            }
            page.setResources(resources.toArray(new String[resources.size()]));
            if (CollectionsUtil.isNotEmpty(refers)) {
                page.setRefer(refers.toArray(new String[refers.size()]));
            }
        }
        appStream.addPage(page.getHref(), page);
    }

    private void collectResources(RelationTree container, List<String> resources, URI baseUri) {
        block5: {
            block4: {
                if (!container.hasChildren()) break block4;
                for (RelationTree child : container.getChildren()) {
                    resources.add(baseUri.relativize(child.getPath()).toString());
                    if (child.isLeaf()) continue;
                    this.collectResources(child, resources, baseUri);
                }
                break block5;
            }
            if (!container.isLink()) break block5;
            RelationTree root = container;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            RelationTree actualTree = this.getActualTree(container, root);
            if (actualTree != null && actualTree.hasChildren()) {
                for (RelationTree child : actualTree.getChildren()) {
                    resources.add(baseUri.relativize(child.getPath()).toString());
                    if (child.isLeaf()) continue;
                    this.collectResources(child, resources, baseUri);
                }
            }
        }
    }

    private RelationTree getActualTree(RelationTree container, RelationTree root) {
        RelationTree result = null;
        if (root.hasChildren()) {
            for (RelationTree child : root.getChildren()) {
                if (child.getPath().toString().equals(container.getPath().toString()) && !child.isLink()) {
                    return child;
                }
                result = this.getActualTree(container, child);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    protected boolean processAST(IFile file, RelationTree tree, IProject project, Set<URI> visitedUris) {
        try {
            IASTParser parser;
            IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            if (contentType != null && (parser = ASTParseManager.getParser(contentType.getId())) != null) {
                return parser.processAST(file, tree, project, visitedUris);
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void processRelationTree(IFile file, RelationTree tree, IProject project, Set<URI> visitedUris, boolean needRecursion, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked((visitedUris.size() % 15 + 1) / 15);
        if (visitedUris.contains(tree.getPath()) && tree.isContainer()) {
            tree.setLink(true);
            return;
        }
        visitedUris.add(tree.getPath());
        if (file.exists()) {
            LinkedHashSet<String> allStrings = new LinkedHashSet<String>();
            RelationTree container = tree.getContainer();
            URI baseUri = container.getPath();
            this.processAST(file, tree, project, visitedUris);
            if (CollectionsUtil.isNotEmpty(tree.getContainStrings())) {
                allStrings.addAll(tree.getContainStrings());
            }
            this.processPattern(file, allStrings);
            for (String strContents : allStrings) {
                if (strContents.length() > 200) continue;
                if (strContents.indexOf(63) > 0) {
                    strContents = strContents.substring(0, strContents.lastIndexOf(63));
                }
                Matcher uMatcher = urlPattern.matcher(strContents);
                while (uMatcher.find()) {
                    try {
                        RelationTree childTree;
                        String strUri = uMatcher.group();
                        URI refURI = baseUri.resolve(strUri);
                        String resourcePath = project.getLocationURI().relativize(refURI).toString();
                        IFile childFile = project.getFile(resourcePath);
                        if (childFile.exists()) {
                            childTree = new RelationTree(childFile.getLocationURI());
                            container.addChild(childTree);
                            if (childTree.isLeaf() || !needRecursion && childTree.isPageView()) continue;
                            this.processRelationTree(childFile, childTree, project, visitedUris, needRecursion, monitor);
                            continue;
                        }
                        if (!strUri.startsWith("_www")) continue;
                        strUri = strUri.substring("_www".length());
                        refURI = baseUri.resolve(strUri);
                        resourcePath = project.getLocationURI().relativize(refURI).toString();
                        childFile = project.getFile(resourcePath);
                        if (!childFile.exists()) continue;
                        childTree = new RelationTree(childFile.getLocationURI());
                        container.addChild(childTree);
                        if (childTree.isLeaf() || !needRecursion && childTree.isPageView()) continue;
                        this.processRelationTree(childFile, childTree, project, visitedUris, needRecursion, monitor);
                    }
                    catch (Exception e) {
                        if (e instanceof URISyntaxException || e instanceof IllegalArgumentException) continue;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void processPattern(IFile file, Set<String> allStrings) {
        try {
            List lines = IOUtils.readLines((InputStream)file.getContents());
            for (String lineStr : lines) {
                if (StringUtil.isEmpty((String)lineStr)) continue;
                Matcher cssUrlMatcher = cssUrlPattern.matcher(lineStr);
                while (cssUrlMatcher.find()) {
                    String strings = cssUrlMatcher.group();
                    try {
                        String strContents;
                        if (strings.length() <= 5 || (strContents = strings.substring(4, strings.length() - 1)).length() > 200) continue;
                        allStrings.add(strContents);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    public List<String> getIdleResources(HMobileProject mProject) {
        Map idles;
        Map dependencies;
        String content;
        Gson gson;
        Map maniFestJSonMap;
        ArrayList<String> results = new ArrayList<String>();
        IProject project = mProject.getProject();
        IFile configFile = project.getFile("manifest.json");
        if (configFile != null && (maniFestJSonMap = AppStreamFileBuilder.jsonToMap(configFile, gson = StreamJsonUtil.createGson(), StreamJsonUtil.createDocument((String)(content = StreamJsonUtil.getContents((IFile)configFile))))).containsKey("dependencies") && (dependencies = (Map)maniFestJSonMap.get("dependencies")).containsKey("idle") && (idles = (Map)dependencies.get("idle")).containsKey("resources")) {
            Collection idleResources = (Collection)idles.get("resources");
            if (maniFestJSonMap.containsKey("unpackage")) {
                Collection unpackages = (Collection)maniFestJSonMap.get("unpackage");
                for (Object obj : unpackages) {
                    String path = obj.toString();
                    IResource res = project.findMember(path);
                    if (res == null || !res.exists()) continue;
                    if (res instanceof IFolder) {
                        if (!path.endsWith("/")) {
                            path = String.valueOf(path) + "/";
                        }
                        for (Object idle : new ArrayList(idleResources)) {
                            String idlePath = idle.toString();
                            if (!idlePath.startsWith(path)) continue;
                            idleResources.remove(idle);
                        }
                        continue;
                    }
                    if (!(res instanceof IFile)) continue;
                    idleResources.remove(obj);
                }
            }
            for (Object idle : idleResources) {
                String idlePath;
                IResource res;
                if (idle == null || (res = project.findMember(idlePath = idle.toString())) == null || !res.exists()) continue;
                results.add(idlePath);
            }
        }
        return results;
    }

    public boolean hasIdleResources(HMobileProject mProject) {
        List<String> idles = this.getIdleResources(mProject);
        return !idles.isEmpty();
    }

    public static Map jsonToMap(IFile manifest, Gson gs, IDocument document) {
        if (document == null || gs == null) {
            return null;
        }
        String content = document.get();
        try {
            return (Map)gs.fromJson(content, Map.class);
        }
        catch (JsonSyntaxException e) {
            if (e.getMessage().contains("duplicate key: dependencies")) {
                content = AppStreamFileBuilder.getBuilder().checkDuplicateKey(manifest, document);
                return (Map)gs.fromJson(content, Map.class);
            }
            throw e;
        }
    }
}

